/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.util.TaglibManagerWrapper;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StrutsJSPTagAttributeHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        IFile file = this.getFile();
        XModel xModel = StrutsJSPTagAttributeHyperlink.getXModel((IFile)file);
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        Properties p = this.getRequestProperties(region);
        p.put("file", file);
        List list = provider.getList(xModel, "struts.open.taglibrary", p.getProperty("prefix"), p);
        if (list != null && list.size() >= 1) {
            this.openFileInEditor((String)list.get(0));
            return;
        }
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getURI(region);
        if (value != null) {
            p.setProperty("prefix", value);
        }
        if ((value = this.getTagName(region)) != null) {
            p.setProperty("name", value);
        }
        if ((value = this.getTagAttributeName(region)) != null) {
            p.setProperty("attribute", value);
        }
        return p;
    }

    private String getURI(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof Element)) {
                return null;
            }
            Node node = n.getParentNode();
            String nodeName = node.getNodeName();
            if (nodeName.indexOf(58) == -1) {
                return null;
            }
            String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
            if (nodePrefix == null || nodePrefix.length() == 0) {
                return null;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(this.getDocument(), region.getOffset());
            if (!tmw.exists()) {
                return null;
            }
            String string = tmw.getUri(nodePrefix);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    private String getTagName(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof Element)) {
                return null;
            }
            Node node = n.getParentNode();
            String tagName = node.getNodeName();
            if (tagName.indexOf(58) == -1) {
                return null;
            }
            String string = tagName.substring(tagName.indexOf(58) + 1);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private String getTagAttributeName(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            IRegion region;
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            final int propStart = bStart + start;
            final int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public int getLength() {
                    return propLength;
                }

                public int getOffset() {
                    return propStart;
                }

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }

                public String toString() {
                    return "IRegion [" + this.getOffset() + ", " + this.getLength() + "]";
                }
            };
            return iRegion;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAttributeValue(IDocument document, Node node, String attrName) {
        if (document == null || node == null || attrName == null) {
            return null;
        }
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue((IDocument)document, (Attr)attr);
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    public String getHyperlinkText() {
        String tagName = this.getTagName(this.fLastRegion);
        String attrName = this.getTagAttributeName(this.fLastRegion);
        if (tagName == null || attrName == null) {
            return StrutsTextExtMessages.OpenTagLibraryForAnAttribute;
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenTagLibraryForAttributeName, attrName, tagName);
    }
}

