/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StrutsJSPTagNameHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String STRUTS_JSP_TAG_NAME_PARTITION = "org.jboss.tools.common.text.ext.jsp.STRUTS_JSP_TAG_NAME";
    private String[] STRUTS_PROJECT_NATURES = new String[]{"org.jboss.tools.struts.strutsnature"};

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        if (document == null || superRegion == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            IRegion r = this.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = STRUTS_JSP_TAG_NAME_PARTITION;
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            IProject project = documentFile.getProject();
            int i = 0;
            while (i < this.STRUTS_PROJECT_NATURES.length) {
                if (project.getNature(this.STRUTS_PROJECT_NATURES[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof IDOMElement)) {
                return null;
            }
            IDOMElement elem = (IDOMElement)n;
            String tagName = elem.getTagName();
            int start = elem.getStartOffset();
            final int nameStart = start + (elem.isEndTag() ? "</" : "<").length();
            final int nameEnd = nameStart + tagName.length();
            if (nameStart > offset || nameEnd <= offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public int getLength() {
                    return nameEnd - nameStart;
                }

                public int getOffset() {
                    return nameStart;
                }

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }

                public String toString() {
                    return "IRegion [" + this.getOffset() + ", " + this.getLength() + "]";
                }
            };
            return iRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }
}

