/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsPropertyHyperlink
extends StrutsXModelBasedHyperlink {
    protected String getRequestMethod() {
        return "struts.open.property";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getProperty(region);
        if (value != null) {
            p.setProperty("property", value);
            p.setProperty("prefix", value);
        }
        if ((value = this.getFormAction(region)) != null) {
            p.setProperty("action", value);
        }
        if ((value = this.getFormType(region)) != null) {
            p.setProperty("type", value);
        }
        return p;
    }

    private String getProperty(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return "";
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return "";
        }
    }

    private String getFormType(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            String nodeName = node.getNodeName();
            String prefix = nodeName.substring(0, nodeName.indexOf(58));
            String formName = String.valueOf(prefix) + ":form";
            Node formNode = null;
            Node parent = node.getParentNode();
            while (parent != null) {
                if (formName.equals(parent.getNodeName())) {
                    formNode = parent;
                    break;
                }
                parent = parent.getParentNode();
            }
            if (formNode == null) {
                return null;
            }
            Attr typeAttr = (Attr)formNode.getAttributes().getNamedItem("type");
            if (typeAttr == null) {
                return null;
            }
            String string = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)typeAttr);
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private String getFormAction(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            String nodeName = node.getNodeName();
            String prefix = nodeName.substring(0, nodeName.indexOf(58));
            String formName = String.valueOf(prefix) + ":form";
            Node formNode = null;
            Node parent = node.getParentNode();
            while (parent != null) {
                if (formName.equals(parent.getNodeName())) {
                    formNode = parent;
                    break;
                }
                parent = parent.getParentNode();
            }
            if (formNode == null) {
                return null;
            }
            Attr actionAttr = (Attr)formNode.getAttributes().getNamedItem("action");
            if (actionAttr == null) {
                return null;
            }
            String string = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)actionAttr);
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String propertyName = this.getProperty(this.fLastRegion);
        String actionName = this.getFormAction(this.fLastRegion);
        if (propertyName == null || actionName == null) {
            return MessageFormat.format(Messages.OpenA, StrutsTextExtMessages.Property);
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenPropertyForFormAction, propertyName, actionName);
    }
}

