/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.ext.hyperlink.XModelBasedHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StrutsTaglibDirectiveHyperlink
extends XModelBasedHyperlink {
    protected String getRequestMethod() {
        return "struts.open.taglibrary";
    }

    private String getTaglibUri(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null || !(n instanceof Node)) {
                return null;
            }
            Node node = n;
            String uri = this.getAttributeValue(this.getDocument(), node, "uri");
            if (uri != null) {
                String string = uri;
                return string;
            }
        }
        finally {
            smw.dispose();
        }
        return null;
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String uri = this.getTaglibUri(region);
        if (uri != null) {
            p.setProperty("prefix", uri);
        }
        return p;
    }

    private String getAttributeValue(IDocument document, Node node, String attrName) {
        if (document == null || node == null || attrName == null) {
            return null;
        }
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)attr);
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            IRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Node)) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null || !(n instanceof IDOMNode)) {
                return null;
            }
            IDOMNode node = (IDOMNode)n;
            final int propStart = node.getStartOffset();
            final int propLength = node.getEndOffset() - propStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public int getLength() {
                    return propLength;
                }

                public int getOffset() {
                    return propStart;
                }

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }
            };
            return iRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String uri = this.getTaglibUri(this.fLastRegion);
        if (uri == null) {
            return MessageFormat.format(Messages.OpenA, Messages.TagLibrary);
        }
        return MessageFormat.format(Messages.OpenTagLibraryForUri, uri);
    }
}

