/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPTagAttributeValueHyperlinkPartitioner;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StrutsTaglibDirectiveHyperlinkPartitioner
extends JSPTagAttributeValueHyperlinkPartitioner {
    public static final String STRUTS_JSP_TAGLIB_DIRECTIVE_PARTITION = "org.jboss.tools.common.text.ext.jsp.STRUTS_JSP_TAGLIB_DIRECTIVE";
    private String[] STRUTS_PROJECT_NATURES = new String[]{"org.jboss.tools.struts.strutsnature"};

    protected String getPartitionType() {
        return STRUTS_JSP_TAGLIB_DIRECTIVE_PARTITION;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (!this.recognizeNature(document)) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            return n instanceof Attr || n instanceof Node;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    protected boolean recognizeNature(IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            IProject project = documentFile.getProject();
            int i = 0;
            while (i < this.STRUTS_PROJECT_NATURES.length) {
                if (project.getNature(this.STRUTS_PROJECT_NATURES[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    public IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null || !(n instanceof IDOMNode)) {
                return null;
            }
            IDOMNode node = (IDOMNode)n;
            final int propStart = node.getStartOffset();
            final int propLength = node.getEndOffset() - propStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public int getLength() {
                    return propLength;
                }

                public int getOffset() {
                    return propStart;
                }

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }
            };
            return iRegion;
        }
        finally {
            smw.dispose();
        }
    }
}

