/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsValidationBundleKeyHyperlink
extends StrutsXModelBasedHyperlink {
    protected String getRequestMethod() {
        return "struts.open.key";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getKey(region);
        if (value != null) {
            p.setProperty("key", value);
            p.setProperty("prefix", value);
        }
        if ((value = this.getBundle(region)) != null) {
            p.setProperty("bundle", value);
        }
        return p;
    }

    private String getKey(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    private String getBundle(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Attr bundleAttr = (Attr)node.getAttributes().getNamedItem("bundle");
            String string = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)bundleAttr);
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String propertyName = this.getKey(this.fLastRegion);
        String baseName = this.getBundle(this.fLastRegion);
        if (propertyName == null || baseName == null) {
            return MessageFormat.format(Messages.OpenA, StrutsTextExtMessages.ValidationBundleProperty);
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenValidationBundlePropertyForBundle, propertyName, baseName);
    }
}

