/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLTagAttributeValueHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsValidationBundleKeyHyperlinkPartitioner
extends XMLTagAttributeValueHyperlinkPartitioner {
    public static final String STRUTS_VALIDATION_BUNDLE_KEY_PARTITION = "org.jboss.tools.common.text.ext.xml.STRUTS_VALIDATION_BUNDLE_KEY";
    private static final String RESOURCE_ATTRNAME = "resource";
    private static final String FALSE_ATTRVALUE = "false";

    protected String getPartitionType() {
        return STRUTS_VALIDATION_BUNDLE_KEY_PARTITION;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (!super.recognize(document, region)) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return false;
            }
            Element parentNode = ((Attr)n).getOwnerElement();
            String resourceAttrValue = this.getAttributeValue(document, parentNode, RESOURCE_ATTRNAME);
            return resourceAttrValue == null || !FALSE_ATTRVALUE.equals(resourceAttrValue);
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAttributeValue(IDocument document, Node node, String attrName) {
        if (document == null || node == null || attrName == null) {
            return null;
        }
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue((IDocument)document, (Attr)attr);
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }
}

