/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.ClassMethodHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;

public class StrutsValidationMethodHyperlink
extends ClassMethodHyperlink {
    private static final String CLASSNAME_ATTRNAME = "classname";
    private static final String METHODPARAMS_ATTRNAME = "methodParams";

    protected String getMethodName(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    protected String getClassName(IRegion region) {
        return this.getAttributeValue(region, CLASSNAME_ATTRNAME);
    }

    protected String getMethodParams(IRegion region) {
        return this.getAttributeValue(region, METHODPARAMS_ATTRNAME);
    }

    public String getHyperlinkText() {
        String methodName = this.getMethodName(this.fLastRegion);
        if (methodName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.ValidationMethod);
        }
        return MessageFormat.format(Messages.OpenValidationMethod, methodName);
    }
}

