/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsValidationMethodHyperlink0
extends StrutsXModelBasedHyperlink {
    private static final String CLASSNAME_ATTRNAME = "classname";

    protected String getRequestMethod() {
        return "struts.open.method";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getMethodName(region);
        if (value != null) {
            p.setProperty("name", value);
            p.setProperty("prefix", value);
        }
        if ((value = this.getClassName(region)) != null) {
            p.setProperty("type", value);
        }
        return p;
    }

    private String getMethodName(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    private String getClassName(IRegion region) {
        return this.getAttributeValue(region, CLASSNAME_ATTRNAME);
    }

    private String getAttributeValue(IRegion region, String attrName) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            String string = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)attr);
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String methodName = this.getMethodName(this.fLastRegion);
        if (methodName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.ValidationMethod);
        }
        return MessageFormat.format(Messages.OpenValidationMethod, methodName);
    }
}

