/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsValidationPropertyHyperlink
extends StrutsXModelBasedHyperlink {
    private static final String NAME_ATTRNAME = "name";

    protected String getRequestMethod() {
        return "struts.open.form.bean";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getFormName(region);
        if (value != null) {
            p.setProperty("prefix", value);
        }
        if ((value = this.getProperty(region)) != null) {
            p.setProperty("property", value);
        }
        return p;
    }

    private String getProperty(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    private String getFormName(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Node parentNode = node.getParentNode();
            String string = this.getAttributeValue(this.getDocument(), parentNode, NAME_ATTRNAME);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String propertyName = this.getProperty(this.fLastRegion);
        String formName = this.getFormName(this.fLastRegion);
        if (propertyName == null || formName == null) {
            return MessageFormat.format(Messages.OpenA, StrutsTextExtMessages.ValidationProperty);
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenValidationProperty, propertyName, formName);
    }
}

