/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StrutsValidationValidatorHyperlink
extends StrutsXModelBasedHyperlink {
    protected String getRequestMethod() {
        return "struts.open.validator";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getAttributeValue(region);
        value = value == null ? "" : value;
        p.setProperty("prefix", value);
        return p;
    }

    private String getAttributeValue(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    public IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            IRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart))) {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd))) break;
                ++bEnd;
            }
            final int propStart = bStart + start;
            final int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public int getLength() {
                    return propLength;
                }

                public int getOffset() {
                    return propStart;
                }

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }

                public String toString() {
                    return "IRegion [" + this.getOffset() + ", " + this.getLength() + "]";
                }
            };
            return iRegion;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String validator = this.getAttributeValue(this.fLastRegion);
        if (validator == null) {
            return MessageFormat.format(Messages.OpenA, StrutsTextExtMessages.Validator);
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenValidator, validator);
    }
}

