/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLContextParamLinkHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StrutsXMLContextParamLinkHyperlinkPartitioner
extends XMLContextParamLinkHyperlinkPartitioner {
    public static final String STRUTS_XML_CONTEXT_PARAM_LINK_PARTITION = "org.jboss.tools.common.text.ext.xml.STRUTS_XML_CONTEXT_PARAM_LINK";
    private String[] STRUTS_PROJECT_NATURES = new String[]{"org.jboss.tools.struts.strutsnature"};
    private static final String SERVLET_TAGNAME = "servlet";
    private static final String SERVLET_CLASS_TAGNAME = "servlet-class";
    private static final String INIT_PARAM_TAGNAME = "init-param";
    private static final String PARAM_NAME_TAGNAME = "param-name";
    private static final String PARAM_VALUE_TAGNAME = "param-value";
    private static final String[] VALID_INIT_PARAM_NAMES = new String[]{"config"};
    private static final String[] VALID_SERVLET_CLASSES = new String[]{"org.apache.struts.action.ActionServlet"};

    protected String getPartitionType() {
        return STRUTS_XML_CONTEXT_PARAM_LINK_PARTITION;
    }

    protected boolean recognizeNature(IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            IProject project = documentFile.getProject();
            int i = 0;
            while (i < this.STRUTS_PROJECT_NATURES.length) {
                if (project.getNature(this.STRUTS_PROJECT_NATURES[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (!this.recognizeNature(document)) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Text)) {
                return false;
            }
            Node paramValueNode = n.getParentNode();
            if (paramValueNode == null || !PARAM_VALUE_TAGNAME.equals(paramValueNode.getNodeName())) {
                return false;
            }
            Node initParamNode = paramValueNode.getParentNode();
            if (initParamNode == null || !INIT_PARAM_TAGNAME.equals(initParamNode.getNodeName())) {
                return false;
            }
            Node servletNode = initParamNode.getParentNode();
            if (servletNode == null || !SERVLET_TAGNAME.equals(servletNode.getNodeName())) {
                return false;
            }
            Node paramNameNode = null;
            NodeList children = initParamNode.getChildNodes();
            int i = 0;
            while (paramNameNode == null && children != null && i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element && PARAM_NAME_TAGNAME.equals(child.getNodeName())) {
                    paramNameNode = child;
                }
                ++i;
            }
            if (paramNameNode == null) {
                return false;
            }
            String paramNameValue = null;
            NodeList list = paramNameNode.getChildNodes();
            int i2 = 0;
            while (list != null && i2 < list.getLength()) {
                if (list.item(i2) instanceof Text) {
                    Text text = (Text)list.item(i2);
                    int start = Utils.getValueStart((Node)text);
                    int end = Utils.getValueEnd((Node)text);
                    if (start >= 0) {
                        paramNameValue = paramNameValue == null ? Utils.trimQuotes((String)document.get(start, end - start)) : String.valueOf(paramNameValue) + Utils.trimQuotes((String)document.get(start, end - start));
                    }
                }
                ++i2;
            }
            if (paramNameValue == null) {
                return false;
            }
            boolean paramNameValueIsCorrect = false;
            int i3 = 0;
            if (i3 < VALID_INIT_PARAM_NAMES.length && VALID_INIT_PARAM_NAMES[i3].equals(paramNameValue)) {
                paramNameValueIsCorrect = true;
            }
            if (!paramNameValueIsCorrect && paramNameValue.startsWith("config/")) {
                paramNameValueIsCorrect = true;
            }
            if (!paramNameValueIsCorrect) {
                return false;
            }
            Node servletClassNode = null;
            children = servletNode.getChildNodes();
            int i4 = 0;
            while (servletClassNode == null && children != null && i4 < children.getLength()) {
                Node child = children.item(i4);
                if (child instanceof Element && SERVLET_CLASS_TAGNAME.equals(child.getNodeName())) {
                    servletClassNode = child;
                }
                ++i4;
            }
            if (servletClassNode == null) {
                return false;
            }
            String servletClassValue = null;
            list = servletClassNode.getChildNodes();
            int i5 = 0;
            while (list != null && i5 < list.getLength()) {
                if (list.item(i5) instanceof Text) {
                    Text text = (Text)list.item(i5);
                    int start = Utils.getValueStart((Node)text);
                    int end = Utils.getValueEnd((Node)text);
                    if (start >= 0) {
                        servletClassValue = servletClassValue == null ? Utils.trimQuotes((String)document.get(start, end - start)) : String.valueOf(servletClassValue) + Utils.trimQuotes((String)document.get(start, end - start));
                    }
                }
                ++i5;
            }
            if (servletClassValue == null) {
                return false;
            }
            boolean servletClassValueIsCorrect = false;
            int i6 = 0;
            if (i6 < VALID_SERVLET_CLASSES.length && VALID_SERVLET_CLASSES[i6].equals(servletClassValue)) {
                servletClassValueIsCorrect = true;
            }
            boolean bl = paramNameValueIsCorrect && servletClassValueIsCorrect;
            return bl;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return false;
        }
        finally {
            smw.dispose();
        }
    }
}

