/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class StrutsXModelBasedHyperlink
extends AbstractHyperlink {
    protected IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        IFile documentFile = this.getFile();
        XModel xModel = StrutsXModelBasedHyperlink.getXModel((IFile)documentFile);
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        Properties p = this.getRequestProperties(region);
        p.put("file", documentFile);
        List list = provider.getList(xModel, this.getRequestMethod(), p.getProperty("prefix"), p);
        if (list != null && list.size() >= 1) {
            this.openFileInEditor((String)list.get(0));
            return;
        }
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    protected abstract String getRequestMethod();

    protected abstract Properties getRequestProperties(IRegion var1);

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            IRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            final int propStart = bStart + start;
            final int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public int getLength() {
                    return propLength;
                }

                public int getOffset() {
                    return propStart;
                }

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }

                public String toString() {
                    return "IRegion [" + this.getOffset() + ", " + this.getLength() + "]";
                }
            };
            return iRegion;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAttributeValue(IDocument document, Node node, String attrName) {
        if (document == null || node == null || attrName == null) {
            return null;
        }
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue((IDocument)document, (Attr)attr);
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }
}

