/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.indirection;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.ValueHolder;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkQueryValueHolder;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;

public class IndirectSet
implements Set,
IndirectContainer,
Cloneable,
Serializable {
    private Set delegate = null;
    private ValueHolderInterface valueHolder;
    private String attributeName;
    protected int initialCapacity = 10;
    protected float loadFactor = 0.75f;

    public IndirectSet() {
        this.valueHolder = null;
    }

    public IndirectSet(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.valueHolder = null;
    }

    public IndirectSet(int initialCapacity, float loadFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.valueHolder = null;
    }

    public IndirectSet(Collection c) {
        this.valueHolder = new ValueHolder(new HashSet(c));
    }

    public synchronized boolean add(Object o) {
        this.getDelegate().add(o);
        this.raiseAddChangeEvent(o);
        return true;
    }

    public synchronized boolean addAll(Collection c) {
        if (this.hasBeenRegistered()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.add(objects.next());
            }
            return true;
        }
        return this.getDelegate().addAll(c);
    }

    protected Set buildDelegate() {
        return (Set)this.getValueHolder().getValue();
    }

    public void clear() {
        if (this.hasBeenRegistered()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(o);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public Object clone() {
        try {
            IndirectSet result = (IndirectSet)super.clone();
            result.delegate = this.cloneDelegate();
            result.attributeName = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("clone not supported");
        }
    }

    protected Set cloneDelegate() {
        Method cloneMethod;
        try {
            cloneMethod = PrivilegedAccessController.getMethod(this.getDelegate().getClass(), "clone", null, false);
        }
        catch (NoSuchMethodException ex) {
            throw QueryException.cloneMethodRequired();
        }
        try {
            return (Set)PrivilegedAccessController.invokeMethod(cloneMethod, this.getDelegate(), null);
        }
        catch (IllegalAccessException ex1) {
            throw QueryException.cloneMethodInaccessible();
        }
        catch (InvocationTargetException ex2) {
            throw QueryException.cloneMethodThrowException(ex2.getTargetException());
        }
    }

    public boolean contains(Object o) {
        return this.getDelegate().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.getDelegate().containsAll(c);
    }

    public boolean equals(Object o) {
        return ((Object)this.getDelegate()).equals(o);
    }

    protected Set getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.buildDelegate();
        }
        return this.delegate;
    }

    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = new ValueHolder(new HashSet(this.initialCapacity, this.loadFactor));
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public int hashCode() {
        return ((Object)this.getDelegate()).hashCode();
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectSet.this.getDelegate().iterator();
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectSet.this.raiseRemoveChangeEvent(this.currentObject);
            }
        };
    }

    public synchronized boolean remove(Object o) {
        if (this.getDelegate().remove(o)) {
            this.raiseRemoveChangeEvent(o);
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection c) {
        if (this.hasBeenRegistered()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.remove(objects.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(c);
    }

    public synchronized boolean retainAll(Collection c) {
        if (this.hasBeenRegistered()) {
            Iterator objects = this.getDelegate().iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (c.contains(object)) continue;
                objects.remove();
                this.raiseRemoveChangeEvent(object);
            }
            return true;
        }
        return this.getDelegate().retainAll(c);
    }

    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getDelegate().toArray(a);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }

    protected void raiseAddChangeEvent(Object element) {
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object element) {
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(element);
        }
    }

    public String getTopLinkAttributeName() {
        return this.attributeName;
    }

    public void setTopLinkAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }
}

