/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3;

import java.util.Map;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import oracle.toplink.essentials.ejb.cmp3.EntityManager;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.EntityTransactionWrapper;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.JTATransactionWrapper;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.TransactionWrapper;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ResultSetMappingQuery;
import oracle.toplink.essentials.threetier.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
extends oracle.toplink.essentials.internal.ejb.cmp3.base.EntityManagerImpl
implements EntityManager {
    private FlushModeType flushMode = FlushModeType.AUTO;

    public EntityManagerImpl(String sessionName, boolean propagatePersistenceContext, boolean extended) {
        super(sessionName, propagatePersistenceContext, extended);
    }

    public EntityManagerImpl(ServerSession serverSession, boolean propagatePersistenceContext, boolean extended) {
        this(serverSession, null, propagatePersistenceContext, extended);
    }

    public EntityManagerImpl(ServerSession serverSession, Map properties, boolean propagePersistenceContext, boolean extended) {
        super(serverSession, properties, propagePersistenceContext, extended);
    }

    @Override
    public <T> T merge(T entity) {
        try {
            return (T)this.mergeInternal(entity);
        }
        catch (RuntimeException e) {
            this.transaction.setRollbackOnlyInternal();
            throw e;
        }
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.findInternal(entityClass, primaryKey);
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = this.findInternal(entityClass, primaryKey);
        if (returnValue == null) {
            Object[] o = new Object[]{primaryKey};
            String message = ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_reference", o);
            throw new EntityNotFoundException(message);
        }
        return (T)returnValue;
    }

    @Override
    public Query createQuery(String ejbqlString) {
        EJBQueryImpl ejbqImpl;
        this.verifyOpen();
        try {
            ejbqImpl = new EJBQueryImpl(ejbqlString, this);
        }
        catch (EJBQLException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("wrap_ejbql_exception"), ex);
        }
        return ejbqImpl;
    }

    @Override
    public Query createNamedQuery(String name) {
        this.verifyOpen();
        return new EJBQueryImpl(name, this, true);
    }

    @Override
    public Query createNativeQuery(String sqlString) {
        this.verifyOpen();
        return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(sqlString, false), this);
    }

    @Override
    public Query createNativeQuery(String sqlString, Class resultType) {
        DatabaseQuery query = this.createNativeQueryInternal(sqlString, resultType);
        return new EJBQueryImpl(query, this);
    }

    @Override
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.verifyOpen();
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(resultSetMapping);
        query.setSQLString(sqlString);
        return new EJBQueryImpl((DatabaseQuery)query, this);
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public Query createQuery(Expression expression, Class resultType) {
        DatabaseQuery query = this.createQueryInternal(expression, resultType);
        return new EJBQueryImpl(query, this);
    }

    @Override
    public EntityTransaction getTransaction() {
        return ((TransactionWrapper)((Object)this.transaction)).getTransaction();
    }

    @Override
    public boolean isFlushModeAUTO() {
        return this.flushMode == FlushModeType.AUTO;
    }

    @Override
    protected void setJTATransactionWrapper() {
        this.transaction = new JTATransactionWrapper(this);
    }

    @Override
    protected void setEntityTransactionWrapper() {
        this.transaction = new EntityTransactionWrapper(this);
    }
}

