/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.EntityMappingsXMLLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.TableInfo;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLDescriptorMetadata;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLEntityClassListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XPathEngine;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.Id;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.SequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.SequencingProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.TableGenerator;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.queryframework.ColumnResult;
import oracle.toplink.essentials.queryframework.EJBQLPlaceHolderQuery;
import oracle.toplink.essentials.queryframework.EntityResult;
import oracle.toplink.essentials.queryframework.FieldResult;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.sessions.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityMappingsXMLProcessor
extends MetadataProcessor {
    private String m_defaultAccess = "";
    private String m_defaultCatalog = "";
    private String m_defaultSchema = "";
    private String m_access;
    private String m_schema;
    private String m_catalog;
    private String m_package;
    private HashMap m_namedQueries;
    private HashMap m_namedNativeQueries;
    private Project m_project;
    private Document m_document;
    private XMLHelper m_xmlHelper;
    private XPathEngine m_xPathEngine;
    private SequencingProcessor m_sequencingProcessor;

    public EntityMappingsXMLProcessor() {
        this(true);
    }

    public EntityMappingsXMLProcessor(boolean enableLazyForOneToOne) {
        this.m_enableLazyForOneToOne = enableLazyForOneToOne;
        this.m_namedQueries = new HashMap();
        this.m_namedNativeQueries = new HashMap();
    }

    public void addEntityListeners(Session session) {
    }

    protected void addEventMethodNameToListener(XMLListener listener, Node node, String eventTag) {
        Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{eventTag});
        if (result != null) {
            listener.addEventMethodName(eventTag, this.m_xPathEngine.selectSingleNode(result, new String[]{"@method-name"}).getNodeValue());
        }
    }

    protected void addEventMethodNameToMap(HashMap methodMap, Node node, String eventTag) {
        Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{eventTag});
        if (result != null) {
            methodMap.put(eventTag, this.m_xPathEngine.selectSingleNode(result, new String[]{"@method-name"}).getNodeValue());
        }
    }

    public void addNamedQueriesToSession(Session session) {
        HashMap hints;
        String queryString;
        HashMap props;
        for (String queryName : this.m_namedQueries.keySet()) {
            if (session.getQuery(queryName) != null) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                continue;
            }
            try {
                props = (HashMap)this.m_namedQueries.get(queryName);
                queryString = (String)props.get("query");
                hints = (HashMap)props.get("hint");
                session.addEjbqlPlaceHolderQuery(new EJBQLPlaceHolderQuery(queryName, queryString, hints));
            }
            catch (Exception exception) {
                this.getValidator().throwErrorProcessingNamedQueryElement(queryName, exception);
            }
        }
        for (String queryName : this.m_namedNativeQueries.keySet()) {
            if (session.getQuery(queryName) != null) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                continue;
            }
            try {
                Class resultClass;
                props = (HashMap)this.m_namedNativeQueries.get(queryName);
                queryString = (String)props.get("query");
                hints = (HashMap)props.get("hint");
                if (props.containsKey("@result-class") && (resultClass = MetadataHelper.getClassForName((String)props.get("@result-class"), this.m_loader)) != Void.TYPE) {
                    session.addQuery(queryName, EJBQueryImpl.buildSQLDatabaseQuery(resultClass, queryString, hints));
                    continue;
                }
                if (props.containsKey("@result-set-mapping")) {
                    session.addQuery(queryName, EJBQueryImpl.buildSQLDatabaseQuery((String)props.get("@result-set-mapping"), queryString, hints));
                    continue;
                }
                session.addQuery(queryName, EJBQueryImpl.buildSQLDatabaseQuery(queryString, hints));
            }
            catch (Exception exception) {
                this.getValidator().throwErrorProcessingNamedQueryElement(queryName, exception);
            }
        }
    }

    protected static Set buildClassSetForNodeList(Document xmlDoc, String xPath, String defaultPkg) {
        HashSet<String> classNameSet = new HashSet<String>();
        XPathEngine xPathEngine = XPathEngine.getInstance();
        NodeList nodes = xPathEngine.selectNodes(xmlDoc, new String[]{"entity-mappings", xPath});
        int nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            classNameSet.add(XMLHelper.getFullyQualifiedClassName(xPathEngine.selectSingleNode(nodes.item(i), new String[]{"@class"}).getNodeValue(), defaultPkg));
        }
        return classNameSet;
    }

    public static Set buildClassSet(URL xmlDocumentURL, ClassLoader loader) {
        XPathEngine xPathEngine = XPathEngine.getInstance();
        HashSet classSet = new HashSet();
        Document xmlDoc = XMLHelper.parseDocument(xmlDocumentURL, loader);
        String defaultPkg = "";
        Node node = xPathEngine.selectSingleNode(xmlDoc, new String[]{"entity-mappings", "package", "text()"});
        if (node != null) {
            defaultPkg = node.getNodeValue();
        }
        classSet.addAll(EntityMappingsXMLProcessor.buildClassSetForNodeList(xmlDoc, "entity", defaultPkg));
        classSet.addAll(EntityMappingsXMLProcessor.buildClassSetForNodeList(xmlDoc, "embeddable", defaultPkg));
        return classSet;
    }

    protected XMLAccessor createAccessor(Node attributeNode, XMLDescriptorMetadata dmd) {
        String attributeName = this.m_xPathEngine.selectSingleNode(attributeNode, new String[]{"@name"}).getNodeValue();
        return new XMLAccessor(attributeName, this, dmd, attributeNode);
    }

    protected SQLResultSetMapping createSQLResultSetMapping(Node node) {
        NodeList columnResultList;
        SQLResultSetMapping mapping = new SQLResultSetMapping(this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"}).getNodeValue());
        NodeList entityResultNodes = this.m_xPathEngine.selectNodes(node, new String[]{"entity-result"});
        if (entityResultNodes != null) {
            int nodeCount = entityResultNodes.getLength();
            for (int j = 0; j < nodeCount; ++j) {
                NodeList fieldResultNodes;
                Node erNode = entityResultNodes.item(j);
                Node result = this.m_xPathEngine.selectSingleNode(erNode, new String[]{"@entity-class"});
                Class entityClass = MetadataHelper.getClassForName(result.getNodeValue(), this.m_loader);
                EntityResult eResult = new EntityResult(entityClass.getName());
                result = this.m_xPathEngine.selectSingleNode(erNode, new String[]{"@discriminator-column"});
                if (result != null) {
                    eResult.setDiscriminatorColumn(result.getNodeValue());
                }
                if ((fieldResultNodes = this.m_xPathEngine.selectNodes(erNode, new String[]{"field-result"})) != null) {
                    int fieldCount = fieldResultNodes.getLength();
                    for (int k = 0; k < fieldCount; ++k) {
                        Node frNode = fieldResultNodes.item(k);
                        String name = this.m_xPathEngine.selectSingleNode(frNode, new String[]{"@name"}).getNodeValue();
                        String column = this.m_xPathEngine.selectSingleNode(frNode, new String[]{"@column"}).getNodeValue();
                        eResult.addFieldResult(new FieldResult(name, column));
                    }
                }
                mapping.addResult(eResult);
            }
        }
        if ((columnResultList = this.m_xPathEngine.selectNodes(node, new String[]{"column-result"})) != null) {
            int columnCount = columnResultList.getLength();
            for (int j = 0; j < columnCount; ++j) {
                mapping.addResult(new ColumnResult(this.m_xPathEngine.selectSingleNode(columnResultList.item(j), new String[]{"@name"}).getNodeValue()));
            }
        }
        return mapping;
    }

    public XMLDescriptorMetadata getMetadataDescriptor(Class cls) {
        XMLDescriptorMetadata dmd = (XMLDescriptorMetadata)this.getDescriptorMetadataMap().get(cls);
        if (dmd == null) {
            ClassDescriptor descriptorOnProject = MetadataHelper.findDescriptor(this.m_session.getProject(), cls);
            if (descriptorOnProject != null) {
                dmd = new XMLDescriptorMetadata(descriptorOnProject, cls, this.m_xmlHelper);
            } else {
                dmd = new XMLDescriptorMetadata(cls, this.m_xmlHelper);
                this.m_session.getProject().addDescriptor(dmd.getDescriptor());
            }
            this.getDescriptorMetadataMap().put(cls, dmd);
        } else {
            dmd.setHelper(this.m_xmlHelper);
        }
        return dmd;
    }

    public HashMap getDescriptorMetadataMap() {
        if (this.m_metadataDescriptors == null) {
            this.m_metadataDescriptors = new HashMap();
        }
        return this.m_metadataDescriptors;
    }

    protected Object[] getCascadeTypes(XMLAccessor accessor) {
        HashSet<String> cascadeVals = new HashSet<String>();
        if (accessor.hasCascade()) {
            NodeList cascadeNodes = accessor.getCascade();
            int nodeCount = cascadeNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                cascadeVals.add(cascadeNodes.item(i).getLocalName());
            }
        }
        return cascadeVals.toArray();
    }

    protected String getFieldName(String candidateName, String defaultName, String context, Class javaClass) {
        if (candidateName != null && !candidateName.equals("")) {
            return candidateName;
        }
        this.getLogger().logConfigMessage(context, javaClass, (Object)defaultName);
        return defaultName;
    }

    protected XMLHelper getHelper() {
        return this.m_xmlHelper;
    }

    protected Object getTypedHintValue(String hintName, String hintValue, String queryName, String entityClass) {
        try {
            if (hintName.equals("toplink.reference-class")) {
                return MetadataHelper.getClassForName(hintValue, this.m_loader);
            }
            if (hintName.equals("toplink.cache-usage") || hintName.equals("toplink.cascade")) {
                return Integer.valueOf(hintValue);
            }
            if (hintName.equals("toplink.refresh")) {
                return Boolean.valueOf(hintValue);
            }
            if (hintName.equals("toplink.pessimistic-lock")) {
                return Short.valueOf(hintValue);
            }
            if (hintName.equals("toplink.expression") || hintName.equals("toplink.call")) {
                this.getLogger().logWarningMessage("orm_warning_ignore_query_hint_unsupported_type", hintName, queryName, entityClass);
                return null;
            }
        }
        catch (ClassCastException exception) {
            // empty catch block
        }
        this.getLogger().logWarningMessage("orm_warning_ignore_query_hint_unknown_type", hintName, queryName, entityClass);
        return null;
    }

    public EntityMappingsXMLLogger getLogger() {
        return (EntityMappingsXMLLogger)this.m_logger;
    }

    protected List getPrimaryKeyFields(XMLDescriptorMetadata dmd) {
        List primaryKeyFields = dmd.getPrimaryKeyFields();
        if (primaryKeyFields.isEmpty() && dmd.isInheritanceSubclass()) {
            primaryKeyFields = this.getMetadataDescriptor(this.m_xmlHelper.locateRootEntity(dmd.getJavaClass())).getPrimaryKeyFields();
        }
        return primaryKeyFields;
    }

    protected Object[] getPrimaryKeyJoinColumns(Node node) {
        Object[] pkJoinCols = new Object[]{};
        NodeList primaryKeyJoinColumns = this.m_xPathEngine.selectNodes(node, new String[]{"primary-key-join-column"});
        if (primaryKeyJoinColumns != null) {
            pkJoinCols = new Object[primaryKeyJoinColumns.getLength()];
            int columnCount = primaryKeyJoinColumns.getLength();
            for (int i = 0; i < columnCount; ++i) {
                pkJoinCols[i] = primaryKeyJoinColumns.item(i);
            }
        }
        return pkJoinCols;
    }

    protected DatabaseTable getRelationTable(XMLAccessor accessor) {
        DatabaseTable relationTable;
        Node joinTableNode = accessor.getJoinTableNode();
        if (joinTableNode != null) {
            String tableName = "";
            String catalogName = this.m_catalog;
            String schemaName = this.m_schema;
            Node attr = this.m_xPathEngine.selectSingleNode(joinTableNode, new String[]{"@name"});
            if (attr != null) {
                tableName = attr.getNodeValue();
            }
            if ((attr = this.m_xPathEngine.selectSingleNode(joinTableNode, new String[]{"@schema"})) != null) {
                schemaName = attr.getNodeValue();
            }
            if ((attr = this.m_xPathEngine.selectSingleNode(joinTableNode, new String[]{"@catalog"})) != null) {
                catalogName = attr.getNodeValue();
            }
            relationTable = this.buildJoinTable(tableName, catalogName, schemaName, accessor);
            this.processUniqueConstraints(this.getUniqueConstraints(joinTableNode), relationTable);
        } else {
            relationTable = this.buildJoinTable(accessor);
        }
        return relationTable;
    }

    protected TableInfo getTableInfo(Node generatorNode) {
        TableInfo tableInfo;
        String tableName = "";
        String catalogName = this.m_catalog;
        String schemaName = this.m_schema;
        Object[] uniqueConstraints = new Object[]{};
        if (generatorNode != null) {
            Node attr = this.m_xPathEngine.selectSingleNode(generatorNode, new String[]{"@table"});
            if (attr != null) {
                tableName = attr.getNodeValue();
            }
            if ((attr = this.m_xPathEngine.selectSingleNode(generatorNode, new String[]{"@schema"})) != null) {
                schemaName = attr.getNodeValue();
            }
            if ((attr = this.m_xPathEngine.selectSingleNode(generatorNode, new String[]{"@catalog"})) != null) {
                catalogName = attr.getNodeValue();
            }
            uniqueConstraints = this.getUniqueConstraints(generatorNode);
            ArrayList<Object> constraintsList = new ArrayList<Object>();
            for (int i = 0; i < uniqueConstraints.length; ++i) {
                constraintsList.add(uniqueConstraints[i]);
            }
            tableInfo = new TableInfo(tableName, catalogName, schemaName, constraintsList);
        } else {
            tableInfo = new TableInfo();
            tableInfo.isSpecified(false);
        }
        return tableInfo;
    }

    protected void init(AbstractSession session, URL xmlDocumentURL) {
        this.m_project = session.getProject();
        this.m_xPathEngine = XPathEngine.getInstance();
        this.m_session = session;
        this.m_sequencingProcessor = new SequencingProcessor();
        this.m_logger = new EntityMappingsXMLLogger(session);
        this.m_validator = new XMLValidator();
        this.m_xmlHelper = new XMLHelper(xmlDocumentURL, this.m_loader);
        this.m_relatedEntities = new HashSet();
        this.m_access = this.m_defaultAccess;
        this.m_schema = this.m_defaultSchema;
        this.m_catalog = this.m_defaultCatalog;
        this.m_package = this.m_xmlHelper.getPackage();
        this.m_document = this.m_xmlHelper.getDocument();
    }

    protected Object[] getUniqueConstraints(Node tableNode) {
        Object[] uniqueConstraints = new Object[]{};
        NodeList constraints = this.m_xPathEngine.selectNodes(tableNode, new String[]{"unique-constraint"});
        if (constraints != null) {
            int constraintCount = constraints.getLength();
            uniqueConstraints = new Object[constraintCount];
            for (int j = 0; j < constraintCount; ++j) {
                Node constraintNode = constraints.item(j);
                NodeList columnNameNodeList = this.m_xPathEngine.selectNodes(constraintNode, new String[]{"column-name", "text()"});
                if (columnNameNodeList == null) continue;
                int columnCount = columnNameNodeList.getLength();
                String[] constraintArray = new String[columnCount];
                for (int k = 0; k < columnCount; ++k) {
                    String columnName = columnNameNodeList.item(k).getNodeValue();
                    if (columnName == null || columnName.equals("")) continue;
                    constraintArray[k] = columnName;
                }
                uniqueConstraints[j] = constraintArray;
            }
        }
        return uniqueConstraints;
    }

    protected XMLValidator getValidator() {
        return (XMLValidator)this.m_validator;
    }

    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataAccessor accessor, String defaultName, String context) {
        XMLDescriptorMetadata referenceMd;
        XMLDescriptorMetadata md;
        if (context.equals("metadata_default_source_pk_column") || context.equals("metadata_default_source_fk_column")) {
            md = (XMLDescriptorMetadata)accessor.getMetadataDescriptor();
            referenceMd = (XMLDescriptorMetadata)accessor.getReferenceMetadataDescriptor();
        } else {
            md = (XMLDescriptorMetadata)accessor.getReferenceMetadataDescriptor();
            referenceMd = (XMLDescriptorMetadata)accessor.getMetadataDescriptor();
        }
        if (defaultName.equals(md.getPrimaryKeyFieldName())) {
            md.handleDefaultPrimaryKeyUsage(dbField);
        } else if (defaultName.equals(referenceMd.getPrimaryKeyFieldName())) {
            referenceMd.handleDefaultPrimaryKeyUsage(dbField);
        } else {
            referenceMd.handleComplexDefaultPrimaryKeyUsage(dbField);
        }
    }

    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataDescriptor md) {
        ((XMLDescriptorMetadata)md).handleDefaultPrimaryKeyUsage(dbField);
    }

    protected boolean handlePotentialPartialOneToOneRelationshipMapping(OneToOneMapping mapping, List joinColumns) {
        if (mapping.requiresCompletion()) {
            if (joinColumns.size() == 1) {
                MetadataJoinColumn mjc = (MetadataJoinColumn)joinColumns.get(0);
                if (mjc.getForeignKeyField().getName().equals("")) {
                    mapping.setXMLPKNameAttribute(mjc.getPrimaryKeyField().getName());
                    return true;
                }
                if (mjc.getPrimaryKeyField().getName().equals("")) {
                    mapping.setXMLFKNameAttribute(mjc.getForeignKeyField().getName());
                    return true;
                }
            }
            mapping.setRequiresCompletion(false);
        }
        return false;
    }

    protected boolean handlePotentialPartialManyToManyRelationshipMapping(ManyToManyMapping mapping, boolean isSource, List relationKeys) {
        if (!isSource && mapping.requiresCompletion()) {
            if (relationKeys.size() == 1) {
                MetadataJoinColumn mjc = (MetadataJoinColumn)relationKeys.get(0);
                if (mjc.getForeignKeyField().getName().equals("")) {
                    mapping.setXMLPKNameAttribute(mjc.getPrimaryKeyField().getName());
                    return true;
                }
                if (mjc.getPrimaryKeyField().getName().equals("")) {
                    mapping.setXMLFKNameAttribute(mjc.getForeignKeyField().getName());
                    return true;
                }
            }
            mapping.setRequiresCompletion(false);
        }
        return false;
    }

    protected boolean hasPrimaryKeyJoinColumn(Node node) {
        return this.m_xPathEngine.selectNodes(node, new String[]{"primary-key-join-column"}).getLength() > 0;
    }

    protected Node locateNode(Class cls, String searchString) {
        return this.m_xmlHelper.locateNode(cls, searchString);
    }

    protected void processAccessors(MetadataDescriptor dmd) {
        this.processAttributes((XMLDescriptorMetadata)dmd, this.m_xmlHelper.locateNode(dmd.getJavaClass()));
    }

    protected void processAssociationOverrides(MetadataAccessor accessor, AggregateObjectMapping mapping) {
    }

    protected void processAssociationOverrides(XMLDescriptorMetadata dmd, Node entityNode) {
        NodeList nodes = this.m_xPathEngine.selectNodes(entityNode, new String[]{"association-override"});
        if (nodes != null) {
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node overrideNode = nodes.item(i);
                String name = this.m_xPathEngine.selectSingleNode(overrideNode, new String[]{"@name"}).getNodeValue();
                NodeList jCols = this.m_xPathEngine.selectNodes(overrideNode, new String[]{"join-column"});
                if (jCols == null || jCols.getLength() <= 0) continue;
                dmd.addAssociationOverride(name, new Object[]{jCols});
            }
        }
    }

    protected void processAccessors(Class cls, XMLDescriptorMetadata dmd) {
        this.processAttributes(dmd, this.m_xmlHelper.locateNode(cls));
    }

    protected void processAttributeOverrides(MetadataAccessor metadataAccessor, AggregateObjectMapping mapping) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.hasAttributeOverrides()) {
            NodeList overrides = accessor.getAttributeOverrideNodes();
            int overrideCount = overrides.getLength();
            for (int i = 0; i < overrideCount; ++i) {
                Node overrideNode = overrides.item(i);
                String overrideName = this.m_xPathEngine.selectSingleNode(overrideNode, new String[]{"@name"}).getNodeValue();
                Node columnNode = this.m_xPathEngine.selectSingleNode(overrideNode, new String[]{"column"});
                this.processAttributeOverride(overrideName, columnNode, accessor, mapping);
            }
        }
    }

    protected void processAttributeOverrides(XMLDescriptorMetadata dmd) {
        this.processAttributeOverrides(dmd.getJavaClass(), dmd);
    }

    protected void processAttributeOverrides(Class cls, XMLDescriptorMetadata dmd) {
        Node entityNode = this.m_xmlHelper.locateNodeForEntity(cls);
        NodeList nodes = this.m_xPathEngine.selectNodes(entityNode, new String[]{"attribute-override"});
        if (nodes != null) {
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node node = nodes.item(i);
                String attributeName = this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"}).getNodeValue();
                Node columnNode = this.m_xPathEngine.selectSingleNode(node, new String[]{"column"});
                if (columnNode == null) continue;
                DatabaseField dbField = this.processColumn(columnNode, attributeName, dmd, dmd.getJavaClass());
                dmd.addAttributeOverride(attributeName, dbField);
            }
        }
    }

    protected void populateCollectionMapping(CollectionMapping mapping, Object oneToManyNode, MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        this.populateCollectionMapping(mapping, accessor, accessor.getTargetEntity(), this.getCascadeTypes(accessor), accessor.usesIndirection());
    }

    protected void preProcessGeneratedValue(Object generatedValueNode, MetadataAccessor accessor, DatabaseField field, MetadataDescriptor dmd) {
        String strategy = "AUTO";
        String generator = "";
        Node result = this.m_xPathEngine.selectSingleNode((Node)generatedValueNode, new String[]{"@strategy"});
        if (result != null) {
            strategy = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode((Node)generatedValueNode, new String[]{"@generator"})) != null) {
            generator = result.getNodeValue();
        }
        this.m_sequencingProcessor.preProcessId(new Id(strategy, generator), field, dmd.getDescriptor());
    }

    protected void preProcessSequenceGenerator(Node node) {
        String name;
        int initialValue = 0;
        int allocationSize = 50;
        String sequenceName = name = this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"}).getNodeValue();
        Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@sequence-name"});
        if (result != null) {
            sequenceName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@initial-value"})) != null) {
            initialValue = Integer.parseInt(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@allocation-size"})) != null) {
            allocationSize = Integer.parseInt(result.getNodeValue());
        }
        this.m_sequencingProcessor.preProcessSequenceGenerator(new SequenceGenerator(name, sequenceName, initialValue, allocationSize));
    }

    protected void preProcessSequencing(MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        Node generator = accessor.getTableGeneratorNode();
        if (generator != null) {
            this.preProcessTableGenerator(generator);
        }
        if ((generator = accessor.getSequenceGeneratorNode()) != null) {
            this.preProcessSequenceGenerator(generator);
        }
    }

    protected void preProcessTableGenerator(Node node) {
        String pkColumnName = "";
        String valueColumnName = "";
        String pkColumnValue = "";
        int initialValue = 0;
        int allocationSize = 50;
        String name = this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"}).getNodeValue();
        Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@pk-column-name"});
        if (result != null) {
            pkColumnName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@value-column-name"})) != null) {
            valueColumnName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@pk-column-value"})) != null) {
            pkColumnValue = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@initial-value"})) != null) {
            initialValue = Integer.parseInt(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"@allocation-size"})) != null) {
            allocationSize = Integer.parseInt(result.getNodeValue());
        }
        TableInfo tableInfo = this.getTableInfo(node);
        this.m_sequencingProcessor.preProcessTableGenerator(new TableGenerator(name, pkColumnName, valueColumnName, pkColumnValue, tableInfo, initialValue, allocationSize));
    }

    protected void processAttributes(XMLDescriptorMetadata dmd, Node node) {
        NodeList attributeNodes = this.m_xPathEngine.selectNodes(node, new String[]{"attributes", "child::*"});
        if (attributeNodes != null) {
            int nodeCount = attributeNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                this.processAccessor(this.createAccessor(attributeNodes.item(i), dmd));
            }
        }
        dmd.setIsProcessed(true);
    }

    protected void processBasic(MetadataAccessor metadataAccessor, DirectToFieldMapping mapping) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.isBasic()) {
            if (accessor.usesIndirection()) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_basic_fetch_lazy", accessor);
            }
            mapping.setIsOptional(accessor.isOptional());
        }
    }

    protected void processCascadeType(MetadataAccessor accessor, Object[] cTypes, ForeignReferenceMapping mapping) {
        for (int i = 0; i < cTypes.length; ++i) {
            this.setCascadeType((String)cTypes[i], mapping);
        }
        if (accessor.getMetadataDescriptor().isCascadePersistSet().booleanValue() && !mapping.isCascadePersist()) {
            this.setCascadeType("cascade-persist", mapping);
        }
    }

    protected DatabaseField processColumn(Object columnNode, Object annotatedElement, String attributeName, MetadataDescriptor dmd) {
        if (columnNode != null) {
            return this.processColumn((Node)columnNode, attributeName, (XMLDescriptorMetadata)dmd, annotatedElement);
        }
        return this.processColumnDefaults(attributeName, dmd, annotatedElement);
    }

    protected DatabaseField processColumn(MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.hasColumn()) {
            return this.processColumn(accessor.getColumnNode(), accessor.getAttributeName(), accessor.getMetadataDescriptor(), accessor.getAnnotatedElement());
        }
        return this.processColumnDefaults(accessor);
    }

    protected DatabaseField processColumn(Node columnNode, String attributeName, XMLDescriptorMetadata xmlDmd, Object element) {
        String fieldName = "";
        String columnDefinition = "";
        String tableName = "";
        boolean isUnique = false;
        boolean isNullable = true;
        boolean isInsertable = true;
        boolean isUpdatable = true;
        int length = 255;
        int precision = 0;
        int scale = 0;
        Node result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@name"});
        if (result != null) {
            fieldName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@table"})) != null) {
            tableName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@insertable"})) != null) {
            isInsertable = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@updatable"})) != null) {
            isUpdatable = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@unique"})) != null) {
            isUnique = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@nullable"})) != null) {
            isNullable = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@column-definition"})) != null) {
            columnDefinition = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@length"})) != null) {
            length = Integer.parseInt(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@precision"})) != null) {
            precision = Integer.parseInt(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(columnNode, new String[]{"@scale"})) != null) {
            scale = Integer.parseInt(result.getNodeValue());
        }
        return this.processColumn(attributeName, fieldName, columnDefinition, tableName, isUnique, isNullable, isInsertable, isUpdatable, length, precision, scale, element, xmlDmd);
    }

    protected void processDefaultId(MetadataDescriptor metadataDescriptor) {
        metadataDescriptor.setDefaultPrimaryKey();
        DatabaseField pkField = new DatabaseField();
        pkField.setTableName(metadataDescriptor.getPrimaryTableName());
        metadataDescriptor.handlePotentialDefaultTableUsage(pkField);
        pkField.setName("TOPLINKDEFAULTID");
        metadataDescriptor.addPrimaryKeyField(pkField);
    }

    protected void processDefaultListeners(List defaultListeners, HashMap defaultListenerEventMethods, XMLDescriptorMetadata xmlDmd) {
        String entityClassName = xmlDmd.getJavaClassName();
        for (String listenerClassName : defaultListeners) {
            XMLEntityListener listener = new XMLEntityListener(listenerClassName, entityClassName);
            listener.getEventMethodNames().putAll((HashMap)defaultListenerEventMethods.get(listenerClassName));
            xmlDmd.addDefaultEventListener(listener);
        }
    }

    protected void processDefaultTable(MetadataDescriptor md) {
        md.setDefaultPrimaryTable();
        super.processDefaultTable(md);
    }

    protected void processDiscriminatorColumn(Node entityNode, XMLDescriptorMetadata xmlDmd) {
        int length = 31;
        String columnName = "";
        String columnDefinition = "";
        String discriminatorType = "STRING";
        Node result = this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"discriminator-column"});
        if (result != null) {
            Node discriminatorResult = this.m_xPathEngine.selectSingleNode(result, new String[]{"@discriminator-type"});
            if (discriminatorResult != null) {
                discriminatorType = discriminatorResult.getNodeValue();
            }
            if ((discriminatorResult = this.m_xPathEngine.selectSingleNode(result, new String[]{"@name"})) != null) {
                columnName = discriminatorResult.getNodeValue();
            }
            if ((discriminatorResult = this.m_xPathEngine.selectSingleNode(result, new String[]{"@column-definition"})) != null) {
                columnDefinition = discriminatorResult.getNodeValue();
            }
            if ((discriminatorResult = this.m_xPathEngine.selectSingleNode(result, new String[]{"@length"})) != null) {
                length = Integer.parseInt(discriminatorResult.getNodeValue());
            }
        }
        this.processDiscriminatorColumn(columnName, columnDefinition, length, discriminatorType, xmlDmd);
    }

    protected void processDiscriminatorValue(MetadataDescriptor metadataDescriptor) {
        this.processDiscriminatorValue(this.m_xmlHelper.locateNodeForEntity(metadataDescriptor.getJavaClass()), (XMLDescriptorMetadata)metadataDescriptor);
    }

    protected void processDiscriminatorValue(Node entityNode, XMLDescriptorMetadata xmlDmd) {
        String dValue = null;
        Node result = this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"discriminator-value", "text()"});
        if (result != null && !result.getNodeValue().equals("")) {
            dValue = result.getNodeValue();
        }
        this.processDiscriminatorValue(dValue, (MetadataDescriptor)xmlDmd);
    }

    protected void processEnumerated(MetadataAccessor accessor, DirectToFieldMapping mapping) {
        Node enumeratedNode = ((XMLAccessor)accessor).getEnumeratedNode();
        boolean isOrdinal = true;
        String enumeratedType = enumeratedNode.getNodeValue();
        if (enumeratedType != null && !enumeratedType.equals("")) {
            isOrdinal = enumeratedType.equals("ORDINAL");
        }
        this.processEnumerated(accessor, isOrdinal, mapping);
    }

    protected void processEntities() {
        NodeList nodes = this.m_xPathEngine.selectNodes(this.m_document, new String[]{"entity-mappings", "entity"});
        if (nodes != null) {
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                this.processEntityNode(nodes.item(i));
            }
        }
    }

    protected void processEntityClass(Class cls) {
        this.processEntityNode(this.m_xmlHelper.locateNode(cls));
    }

    protected void processEntityNode(Node node) {
        String entityClassName = this.m_xmlHelper.getClassNameForNode(node);
        Class entityClass = MetadataHelper.getClassForName(entityClassName, this.m_loader);
        XMLDescriptorMetadata xmlDmd = this.getMetadataDescriptor(entityClass);
        if (!xmlDmd.isProcessed()) {
            xmlDmd.setIgnoreFlags();
            String alias = "";
            Node attr = this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"});
            if (attr != null) {
                alias = attr.getNodeValue();
            }
            this.processEntity(alias, xmlDmd);
            if (!xmlDmd.shouldIgnoreAnnotations() && (attr = this.m_xPathEngine.selectSingleNode(node, new String[]{"@metadata-complete"})) != null) {
                xmlDmd.setShouldIgnoreAnnotations(Boolean.parseBoolean(attr.getNodeValue()));
            }
            if ((attr = this.m_xPathEngine.selectSingleNode(node, new String[]{"@access"})) != null) {
                this.m_access = attr.getNodeValue();
            }
            if (this.m_access.equals("field")) {
                xmlDmd.setIsXmlFieldAccess();
            } else if (this.m_access.equals("PROPERTY")) {
                xmlDmd.setIsXmlPropertyAccess();
            }
            xmlDmd.setCatalog(this.m_catalog);
            xmlDmd.setSchema(this.m_schema);
            xmlDmd.setUsesPropertyAccess(this.m_access.equals("PROPERTY"));
            this.processNamedQueries(node, new String[]{"named-query"}, entityClassName);
            this.processNamedNativeQueries(node, new String[]{"named-native-query"}, entityClassName);
            this.processSQLResultSetMappings(node, new String[]{"sql-result-set-mapping"});
            Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{"table-generator"});
            if (result != null) {
                this.preProcessTableGenerator(result);
            }
            if ((result = this.m_xPathEngine.selectSingleNode(node, new String[]{"sequence-generator"})) != null) {
                this.preProcessSequenceGenerator(result);
            }
            this.processTable(xmlDmd, node);
            this.processIdClass(xmlDmd);
            this.processAssociationOverrides(xmlDmd, node);
            this.processAttributeOverrides(xmlDmd);
            this.processMappedSuperclasses(xmlDmd);
            this.processAttributes(xmlDmd, node);
            if (xmlDmd.hasCompositePrimaryKey()) {
                if (xmlDmd.pkClassWasNotValidated()) {
                    this.getValidator().throwInvalidCompositePKSpecification(entityClass, xmlDmd.getPKClassName());
                }
            } else if (!xmlDmd.hasPrimaryKeyFields() && !xmlDmd.isInheritanceSubclass()) {
                this.processDefaultId(xmlDmd);
            }
            this.processSecondaryTables(node, xmlDmd);
            this.processEntityListeners(node, xmlDmd);
        }
    }

    public Session processEntityMappings(AbstractSession session, URL xmlDocumentURL) {
        int i;
        int resultCount;
        this.init(session, xmlDocumentURL);
        Node node = this.m_xPathEngine.selectSingleNode(this.m_document, new String[]{"entity-mappings", "catalog", "text()"});
        if (node != null) {
            this.m_catalog = node.getNodeValue();
        }
        if ((node = this.m_xPathEngine.selectSingleNode(this.m_document, new String[]{"entity-mappings", "schema", "text()"})) != null) {
            this.m_schema = node.getNodeValue();
        }
        if ((node = this.m_xPathEngine.selectSingleNode(this.m_document, new String[]{"entity-mappings", "access", "text()"})) != null) {
            this.m_access = node.getNodeValue();
        }
        this.processNamedQueries(this.m_document, new String[]{"entity-mappings", "named-query"});
        this.processNamedNativeQueries(this.m_document, new String[]{"entity-mappings", "named-native-query"});
        this.processSQLResultSetMappings(this.m_document, new String[]{"entity-mappings", "sql-result-set-mapping"});
        NodeList results = this.m_xPathEngine.selectNodes(this.m_document, new String[]{"entity-mappings", "table-generator"});
        if (results != null) {
            resultCount = results.getLength();
            for (i = 0; i < resultCount; ++i) {
                this.preProcessTableGenerator(results.item(i));
            }
        }
        if ((results = this.m_xPathEngine.selectNodes(this.m_document, new String[]{"entity-mappings", "sequence-generator"})) != null) {
            resultCount = results.getLength();
            for (i = 0; i < resultCount; ++i) {
                this.preProcessSequenceGenerator(results.item(i));
            }
        }
        this.processEntities();
        this.m_sequencingProcessor.process(session.getProject().getLogin());
        Iterator dmdIt = this.m_relatedEntities.iterator();
        while (dmdIt.hasNext()) {
            this.processRelatedEntity((XMLDescriptorMetadata)dmdIt.next());
        }
        return session;
    }

    protected void processRelatedEntity(XMLDescriptorMetadata dmd) {
        if (dmd.isInheritanceSubclass()) {
            this.processInheritanceSubclass(dmd);
        }
        for (XMLAccessor accessor : dmd.getRelationshipAccessors()) {
            this.processRelationshipAccessor(accessor);
        }
    }

    protected void processEvents(XMLListener listener, Node node) {
        this.addEventMethodNameToListener(listener, node, "pre-persist");
        this.addEventMethodNameToListener(listener, node, "post-persist");
        this.addEventMethodNameToListener(listener, node, "pre-remove");
        this.addEventMethodNameToListener(listener, node, "post-remove");
        this.addEventMethodNameToListener(listener, node, "pre-update");
        this.addEventMethodNameToListener(listener, node, "post-update");
        this.addEventMethodNameToListener(listener, node, "post-load");
    }

    protected void processEventMethodNames(HashMap methodMap, Node node) {
        this.addEventMethodNameToMap(methodMap, node, "pre-persist");
        this.addEventMethodNameToMap(methodMap, node, "post-persist");
        this.addEventMethodNameToMap(methodMap, node, "pre-remove");
        this.addEventMethodNameToMap(methodMap, node, "post-remove");
        this.addEventMethodNameToMap(methodMap, node, "pre-update");
        this.addEventMethodNameToMap(methodMap, node, "post-update");
        this.addEventMethodNameToMap(methodMap, node, "post-load");
    }

    protected void processId(MetadataAccessor metadataAccessor, DatabaseField field) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.isId()) {
            this.processId(accessor, field, accessor.getGeneratedValueNode());
        }
    }

    protected void processIdClass(XMLDescriptorMetadata xmlDmd) {
        Class cls = xmlDmd.getJavaClass();
        Node node = this.m_xmlHelper.locateNode(cls);
        Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{"id-class"});
        if (result != null) {
            this.processIdClass(this.m_xmlHelper.getClassForNode(result), xmlDmd);
        }
    }

    protected void processInheritanceRoot(MetadataDescriptor metadataDescriptor) {
        this.processInheritanceRoot(this.m_xmlHelper.locateNode(metadataDescriptor.getJavaClass()), (XMLDescriptorMetadata)metadataDescriptor);
    }

    protected void processInheritanceRoot(Node entityNode, XMLDescriptorMetadata dmd) {
        if (dmd.ignoreInheritanceAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_INHERITANCE, dmd);
        } else {
            Node inheritanceNode = this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"inheritance"});
            if (inheritanceNode != null || dmd.isInheritanceRoot()) {
                String strategy = "SINGLE_TABLE";
                if (inheritanceNode != null) {
                    Node rootResult = this.m_xPathEngine.selectSingleNode(inheritanceNode, new String[]{"@strategy"});
                    strategy = rootResult.getNodeValue();
                }
                dmd.setInheritanceStrategy(strategy);
                this.processDiscriminatorColumn(entityNode, dmd);
                this.processDiscriminatorValue(entityNode, dmd);
            }
        }
    }

    protected MetadataJoinColumn processJoinColumn(Node joinColumnNode, XMLAccessor accessor, String targetTable, MetadataDescriptor sourceDmd) {
        String name = "";
        String referencedColumnName = "";
        boolean isUnique = false;
        boolean isNullable = true;
        boolean isInsertable = true;
        boolean isUpdatable = true;
        String columnDefinition = "";
        String tableName = "";
        Node result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@name"});
        if (result != null) {
            name = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@referenced-column-name"})) != null) {
            referencedColumnName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@unique"})) != null) {
            isUnique = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@nullable"})) != null) {
            isNullable = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@insertable"})) != null) {
            isInsertable = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@updatable"})) != null) {
            isUpdatable = Boolean.parseBoolean(result.getNodeValue());
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@column-definition"})) != null) {
            columnDefinition = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(joinColumnNode, new String[]{"@secondary-table"})) != null) {
            tableName = result.getNodeValue();
        }
        return this.processJoinColumn(accessor, targetTable, sourceDmd, name, referencedColumnName, columnDefinition, tableName, isUnique, isNullable, isInsertable, isUpdatable);
    }

    protected ArrayList processJoinColumns(MetadataAccessor metadataAccessor) {
        ArrayList<MetadataJoinColumn> allJoinColumns = new ArrayList<MetadataJoinColumn>();
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        XMLDescriptorMetadata dmd = accessor.getMetadataDescriptor();
        String targetTableName = dmd.getPrimaryTableName();
        MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
        String sourceTableName = referenceDmd.getPrimaryTableName();
        Node node = accessor.getAttributeNode();
        String attributeName = accessor.getAttributeName();
        NodeList joinColumns = dmd.hasAssociationOverrideFor(accessor) ? (NodeList)dmd.getAssociationOverrideFor(accessor)[0] : this.m_xPathEngine.selectNodes(node, new String[]{"join-column"});
        if (referenceDmd.hasCompositePrimaryKey()) {
            if (joinColumns == null || joinColumns.getLength() != referenceDmd.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompleteJoinColumnsSpecified(dmd.getJavaClass(), attributeName);
            }
            int columnCount = joinColumns.getLength();
            for (int i = 0; i < columnCount; ++i) {
                allJoinColumns.add(this.processJoinColumn(joinColumns.item(i), accessor, targetTableName, referenceDmd));
            }
        } else if (joinColumns != null && joinColumns.getLength() != 0) {
            if (joinColumns.getLength() > 1) {
                this.getValidator().throwExcessiveJoinColumnsSpecified(dmd.getJavaClass(), attributeName);
            }
            allJoinColumns.add(this.processJoinColumn(joinColumns.item(0), accessor, targetTableName, referenceDmd));
        } else {
            this.addJoinColumnDefault(allJoinColumns, sourceTableName, targetTableName, dmd);
        }
        return allJoinColumns;
    }

    protected void processJoinTable(MetadataAccessor metadataAccessor, ManyToManyMapping mapping) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (!accessor.isTargetEntityDefinedInDocument()) {
            mapping.setRequiresCompletion(true);
        }
        DatabaseTable relationTable = this.getRelationTable(accessor);
        mapping.setRelationTable(relationTable);
        String relationTableName = relationTable.getQualifiedName();
        ArrayList<MetadataJoinColumn> sourceKeys = new ArrayList<MetadataJoinColumn>();
        ArrayList<MetadataJoinColumn> targetKeys = new ArrayList<MetadataJoinColumn>();
        Node joinTableNode = accessor.getJoinTableNode();
        if (joinTableNode != null) {
            int i;
            int columnCount;
            NodeList jCols = this.m_xPathEngine.selectNodes(joinTableNode, new String[]{"join-column"});
            if (jCols != null) {
                columnCount = jCols.getLength();
                for (i = 0; i < columnCount; ++i) {
                    sourceKeys.add(this.processJoinColumn(jCols.item(i), accessor, relationTableName, accessor.getMetadataDescriptor()));
                }
            }
            if ((jCols = this.m_xPathEngine.selectNodes(joinTableNode, new String[]{"inverse-join-column"})) != null) {
                columnCount = jCols.getLength();
                for (i = 0; i < columnCount; ++i) {
                    targetKeys.add(this.processJoinColumn(jCols.item(i), accessor, relationTableName, accessor.getReferenceMetadataDescriptor()));
                }
            }
        }
        this.processJoinTable(accessor, mapping, sourceKeys, targetKeys);
    }

    protected void processEntityListeners(Node node, XMLDescriptorMetadata xmlDmd) {
        xmlDmd.setExcludeSuperclassListeners(this.m_xPathEngine.selectSingleNode(node, new String[]{"exclude-superclass-listeners"}) != null);
        xmlDmd.setExcludeDefaultListeners(this.m_xPathEngine.selectSingleNode(node, new String[]{"exclude-default-listeners"}) != null);
        this.processEntityListeners(node, new String[]{"entity-listeners", "entity-listener"}, xmlDmd);
        this.processEntityEventListener(node, xmlDmd);
    }

    protected void processEntityListeners(Node node, String[] xPath, XMLDescriptorMetadata xmlDmd) {
        NodeList listenerNodes = this.m_xPathEngine.selectNodes(node, xPath);
        if (listenerNodes.getLength() > 0) {
            int nodeCount = listenerNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node listenerNode = listenerNodes.item(i);
                String listenerClassName = this.m_xmlHelper.getClassNameForNode(listenerNode);
                XMLEntityListener listener = new XMLEntityListener(listenerClassName, xmlDmd.getJavaClassName());
                this.processEvents(listener, listenerNode);
                xmlDmd.addEntityListenerEventListener(listener);
            }
        }
    }

    protected void processEntityEventListener(Node node, XMLDescriptorMetadata xmlDmd) {
        if (this.m_xmlHelper.entityHasCallbackMethod(node)) {
            XMLEntityClassListener listener = new XMLEntityClassListener(xmlDmd.getJavaClassName());
            this.processEvents(listener, node);
            xmlDmd.setEntityEventListener(listener);
        }
    }

    protected void processManyToMany(MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        this.processManyToMany(accessor, accessor.getTargetEntity(), this.getCascadeTypes(accessor), accessor.usesIndirection(), accessor.getMappedBy());
    }

    protected void processManyToOne(MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        this.processManyToOne(accessor, accessor.getTargetEntity(), this.getCascadeTypes(accessor), accessor.usesIndirection(), accessor.isOptional());
    }

    protected String processMapKey(MetadataAccessor metadataAccessor, CollectionMapping mapping) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (!accessor.hasMapKey()) {
            return null;
        }
        return this.processMapKey(accessor, mapping, accessor.getMapKey());
    }

    protected void processMappedSuperclasses(XMLDescriptorMetadata dmd) {
        for (Class cls : dmd.getMappedSuperclasses()) {
            this.processAccessors(cls, dmd);
            this.processAttributeOverrides(cls, dmd);
        }
    }

    protected void processNamedNativeQueries(Node node, String[] xPath) {
        this.processNamedNativeQueries(node, xPath, "");
    }

    protected void processNamedNativeQueries(Node node, String[] xPath, String entityClassName) {
        NodeList queries = this.m_xPathEngine.selectNodes(node, xPath);
        if (queries != null) {
            int queryCount = queries.getLength();
            for (int i = 0; i < queryCount; ++i) {
                Node queryNode = queries.item(i);
                String queryName = this.m_xPathEngine.selectSingleNode(queryNode, new String[]{"@name"}).getNodeValue();
                if (this.m_namedNativeQueries.containsKey(queryName)) {
                    this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                    continue;
                }
                Node ejbqlNode = this.m_xPathEngine.selectSingleNode(queryNode, new String[]{"query", "text()"});
                String ejbql = "";
                if (ejbqlNode != null && ejbqlNode.getNodeValue() != null) {
                    ejbql = ejbqlNode.getNodeValue();
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("query", ejbql);
                Node result = this.m_xPathEngine.selectSingleNode(queryNode, new String[]{"@result-class"});
                if (result != null && !result.getNodeValue().equals("")) {
                    props.put("@result-class", this.m_xmlHelper.getFullyQualifiedClassName(result.getNodeValue()));
                }
                if ((result = this.m_xPathEngine.selectSingleNode(queryNode, new String[]{"@result-set-mapping"})) != null && !result.getNodeValue().equals("")) {
                    props.put("@result-set-mapping", result.getNodeValue());
                }
                props.put("hint", this.processQueryHints(queryNode, queryName, entityClassName));
                this.m_namedNativeQueries.put(queryName, props);
            }
        }
    }

    protected void processNamedQueries(Node node, String[] xPath) {
        this.processNamedQueries(node, xPath, "");
    }

    protected void processNamedQueries(Node node, String[] xPath, String entityClassName) {
        NodeList queries = this.m_xPathEngine.selectNodes(node, xPath);
        if (queries != null) {
            int queryCount = queries.getLength();
            for (int i = 0; i < queryCount; ++i) {
                Node queryNode = queries.item(i);
                String queryName = this.m_xPathEngine.selectSingleNode(queryNode, new String[]{"@name"}).getNodeValue();
                if (this.m_namedQueries.containsKey(queryName)) {
                    this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName, entityClassName);
                    continue;
                }
                Node ejbqlNode = this.m_xPathEngine.selectSingleNode(queryNode, new String[]{"query", "text()"});
                String ejbql = "";
                if (ejbqlNode != null && ejbqlNode.getNodeValue() != null) {
                    ejbql = ejbqlNode.getNodeValue();
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("query", ejbql);
                props.put("hint", this.processQueryHints(queryNode, queryName, entityClassName));
                this.m_namedQueries.put(queryName, props);
            }
        }
    }

    protected void processOneToMany(MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        this.processOneToMany(accessor, accessor.getAttributeNode(), accessor.getMappedBy());
    }

    protected void processOneToOne(MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        this.processOneToOne(accessor, accessor.getTargetEntity(), this.getCascadeTypes(accessor), accessor.usesIndirection(), accessor.isOptional(), accessor.getMappedBy());
    }

    protected void processOrderBy(MetadataAccessor metadataAccessor, CollectionMapping mapping) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.hasOrderBy()) {
            this.processOrderBy(accessor, mapping, accessor.getOrderByNode().getNodeValue());
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping, MetadataAccessor accessor) {
        if (!((XMLAccessor)accessor).isTargetEntityDefinedInDocument()) {
            mapping.setRequiresCompletion(true);
        }
        super.processOwningMappingKeys(mapping, accessor);
    }

    protected void processPersistenceUnitDefault(String key, Node contextNode, HashMap puDefaults) {
        Node node = this.m_xPathEngine.selectSingleNode(contextNode, new String[]{key, "text()"});
        if (node != null) {
            String nodeValue = node.getNodeValue();
            Object existingValue = puDefaults.get(key);
            if (existingValue != null && !((String)existingValue).equals(nodeValue)) {
                this.getValidator().throwPersistenceUnitMetadataConflict(key);
            }
            puDefaults.put(key, nodeValue);
        } else {
            puDefaults.put(key, "");
        }
    }

    public void processPersistenceUnitMetadata(AbstractSession session, Collection mappingFiles, Collection entities) {
        this.m_session = session;
        Boolean cascadePersist = null;
        Boolean metadataComplete = null;
        HashMap<String, Serializable> puDefaults = new HashMap<String, Serializable>();
        HashMap defaultListenerList = new HashMap();
        ArrayList<String> orderedDefaultListenerList = new ArrayList<String>();
        if (!mappingFiles.isEmpty()) {
            this.m_xPathEngine = XPathEngine.getInstance();
            puDefaults.put("entity-listeners", defaultListenerList);
            Iterator mapIt = mappingFiles.iterator();
            while (mapIt.hasNext()) {
                NodeList listenerNodes;
                this.m_xmlHelper = new XMLHelper((URL)mapIt.next(), this.m_loader);
                String[] xPath = new String[]{"entity-mappings", "persistence-unit-metadata"};
                Node contextNode = this.m_xPathEngine.selectSingleNode(this.m_xmlHelper.getDocument(), xPath);
                if (contextNode == null) continue;
                Node result = this.m_xPathEngine.selectSingleNode(contextNode, new String[]{"xml-mapping-metadata-complete"});
                if (result == null) {
                    if (metadataComplete == null) {
                        metadataComplete = false;
                    } else if (metadataComplete.booleanValue()) {
                        this.getValidator().throwPersistenceUnitMetadataConflict("xml-mapping-metadata-complete");
                    }
                } else if (metadataComplete == null) {
                    metadataComplete = true;
                    puDefaults.put("xml-mapping-metadata-complete", Boolean.valueOf(true));
                } else if (!metadataComplete.booleanValue()) {
                    this.getValidator().throwPersistenceUnitMetadataConflict("xml-mapping-metadata-complete");
                }
                contextNode = this.m_xPathEngine.selectSingleNode(contextNode, new String[]{"persistence-unit-defaults"});
                if (contextNode == null) continue;
                this.processPersistenceUnitDefault("access", contextNode, puDefaults);
                this.m_defaultAccess = (String)puDefaults.get("access");
                this.processPersistenceUnitDefault("schema", contextNode, puDefaults);
                this.m_defaultSchema = (String)puDefaults.get("schema");
                this.processPersistenceUnitDefault("catalog", contextNode, puDefaults);
                this.m_defaultCatalog = (String)puDefaults.get("catalog");
                result = this.m_xPathEngine.selectSingleNode(contextNode, new String[]{"cascade-persist"});
                if (result == null) {
                    if (cascadePersist == null) {
                        cascadePersist = false;
                    } else if (cascadePersist.booleanValue()) {
                        this.getValidator().throwPersistenceUnitMetadataConflict("cascade-persist");
                    }
                } else if (cascadePersist == null) {
                    cascadePersist = true;
                    puDefaults.put("cascade-persist", Boolean.valueOf(true));
                } else if (!cascadePersist.booleanValue()) {
                    this.getValidator().throwPersistenceUnitMetadataConflict("cascade-persist");
                }
                if ((listenerNodes = this.m_xPathEngine.selectNodes(contextNode, xPath = new String[]{"entity-listeners", "entity-listener"})) == null || listenerNodes.getLength() <= 0) continue;
                int listenerCount = listenerNodes.getLength();
                for (int i = 0; i < listenerCount; ++i) {
                    Node listenerNode = listenerNodes.item(i);
                    String listenerClassName = this.m_xmlHelper.getClassNameForNode(listenerNode);
                    HashMap methodMap = new HashMap();
                    this.processEventMethodNames(methodMap, listenerNode);
                    defaultListenerList.put(listenerClassName, methodMap);
                    orderedDefaultListenerList.add(listenerClassName);
                }
            }
        }
        if (!entities.isEmpty()) {
            for (Class entityClass : entities) {
                XMLDescriptorMetadata xmlDmd = new XMLDescriptorMetadata(entityClass, null);
                this.m_session.getProject().addDescriptor(xmlDmd.getDescriptor());
                this.getDescriptorMetadataMap().put(entityClass, xmlDmd);
                if (this.m_defaultAccess.equals("field")) {
                    xmlDmd.setIsXmlFieldAccess();
                } else if (this.m_defaultAccess.equals("PROPERTY")) {
                    xmlDmd.setIsXmlPropertyAccess();
                }
                xmlDmd.setCatalog(this.m_defaultSchema);
                xmlDmd.setSchema(this.m_defaultCatalog);
                if (puDefaults.get("cascade-persist") != null) {
                    xmlDmd.setShouldUseCascadePersist(true);
                }
                this.processDefaultListeners(orderedDefaultListenerList, defaultListenerList, xmlDmd);
                xmlDmd.setShouldIgnoreAnnotations(puDefaults.get("xml-mapping-metadata-complete") != null);
            }
        }
    }

    protected MetadataJoinColumn processPrimaryKeyJoinColumnNode(Node pkJoinColNode, String sourceTable, String targetTable, MetadataDescriptor dmd) {
        String name = "";
        String referencedColumnName = "";
        String columnDefinition = "";
        Node result = this.m_xPathEngine.selectSingleNode(pkJoinColNode, new String[]{"@name"});
        if (result != null) {
            name = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(pkJoinColNode, new String[]{"@referenced-column-name"})) != null) {
            referencedColumnName = result.getNodeValue();
        }
        if ((result = this.m_xPathEngine.selectSingleNode(pkJoinColNode, new String[]{"@column-definition"})) != null) {
            columnDefinition = result.getNodeValue();
        }
        return this.processPrimaryKeyJoinColumn(name, referencedColumnName, columnDefinition, sourceTable, targetTable, dmd);
    }

    protected ArrayList processPrimaryKeyJoinColumns(Object[] pkJoinCols, String sourceTableName, String targetTableName, MetadataDescriptor dmd) {
        ArrayList<MetadataJoinColumn> joinColumnDetails = new ArrayList<MetadataJoinColumn>();
        for (int i = 0; i < pkJoinCols.length; ++i) {
            joinColumnDetails.add(this.processPrimaryKeyJoinColumnNode((Node)pkJoinCols[i], sourceTableName, targetTableName, dmd));
        }
        return joinColumnDetails;
    }

    protected ArrayList processPrimaryKeyJoinColumns(String sourceTable, String targetTable, Object element, MetadataDescriptor dmd) {
        Node entityNode = this.m_xmlHelper.locateNode(dmd.getJavaClass());
        Node node = element instanceof String ? this.m_xmlHelper.locateNodeForAttribute(entityNode, (String)element) : entityNode;
        ArrayList<MetadataJoinColumn> joinColumnDetails = new ArrayList<MetadataJoinColumn>();
        Class entityClass = dmd.getJavaClass();
        NodeList primaryKeyJoinColumns = this.m_xPathEngine.selectNodes(node, new String[]{"primary-key-join-column"});
        if (dmd.hasCompositePrimaryKey()) {
            if (primaryKeyJoinColumns == null || primaryKeyJoinColumns.getLength() != dmd.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(entityClass);
            }
        } else if (primaryKeyJoinColumns != null && primaryKeyJoinColumns.getLength() > 1) {
            this.getValidator().throwExcessivePrimaryKeyJoinColumnsSpecified(entityClass);
        }
        if (primaryKeyJoinColumns != null) {
            int columnCount = primaryKeyJoinColumns.getLength();
            for (int i = 0; i < columnCount; ++i) {
                Node pkJoinColumnNode = primaryKeyJoinColumns.item(i);
                String name = "";
                String referencedColumnName = "";
                String columnDefinition = "";
                Node result = this.m_xPathEngine.selectSingleNode(pkJoinColumnNode, new String[]{"@name"});
                if (result != null) {
                    name = result.getNodeValue();
                }
                if ((result = this.m_xPathEngine.selectSingleNode(pkJoinColumnNode, new String[]{"@referenced-column-name"})) != null) {
                    referencedColumnName = result.getNodeValue();
                }
                if ((result = this.m_xPathEngine.selectSingleNode(pkJoinColumnNode, new String[]{"@column-definition"})) != null) {
                    columnDefinition = result.getNodeValue();
                }
                joinColumnDetails.add(this.processPrimaryKeyJoinColumn(name, referencedColumnName, columnDefinition, sourceTable, targetTable, dmd));
            }
        }
        this.addJoinColumnDefault(joinColumnDetails, sourceTable, targetTable, dmd);
        return joinColumnDetails;
    }

    protected HashMap processQueryHints(Node queryNode, String queryName, String entityClass) {
        HashMap<String, Object> hintMap = new HashMap<String, Object>();
        NodeList hints = this.m_xPathEngine.selectNodes(queryNode, new String[]{"hint"});
        if (hints != null) {
            int hintCount = hints.getLength();
            for (int h = 0; h < hintCount; ++h) {
                Node hintNode = hints.item(h);
                String hintName = this.m_xPathEngine.selectSingleNode(hintNode, new String[]{"@name"}).getNodeValue();
                String hintValue = this.m_xPathEngine.selectSingleNode(hintNode, new String[]{"@value"}).getNodeValue();
                Object typedHintValue = this.getTypedHintValue(hintName, hintValue, queryName, entityClass);
                if (typedHintValue == null) continue;
                hintMap.put(hintName, typedHintValue);
            }
        }
        return hintMap;
    }

    protected void processSecondaryTables(Node entityNode, XMLDescriptorMetadata dmd) {
        NodeList secondaryTables = this.m_xPathEngine.selectNodes(entityNode, new String[]{"secondary-table"});
        if (secondaryTables != null) {
            int tableCount = secondaryTables.getLength();
            for (int i = 0; i < tableCount; ++i) {
                Node tableNode = secondaryTables.item(i);
                String catalog = this.m_catalog;
                String schema = this.m_schema;
                Node result = this.m_xPathEngine.selectSingleNode(tableNode, new String[]{"@name"});
                String tableName = result.getNodeValue();
                result = this.m_xPathEngine.selectSingleNode(tableNode, new String[]{"@catalog"});
                if (result != null) {
                    catalog = result.getNodeValue();
                }
                if ((result = this.m_xPathEngine.selectSingleNode(tableNode, new String[]{"@schema"})) != null) {
                    schema = result.getNodeValue();
                }
                this.processSecondaryTable(tableName, schema, catalog, this.getUniqueConstraints(tableNode), this.getPrimaryKeyJoinColumns(tableNode), dmd);
            }
        }
    }

    protected void processSQLResultSetMappings(Node node, String[] xPath) {
        NodeList sqlResultSetNodes = this.m_xPathEngine.selectNodes(node, xPath);
        if (sqlResultSetNodes != null) {
            int nodeCount = sqlResultSetNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                this.m_session.getProject().addSQLResultSetMapping(this.createSQLResultSetMapping(sqlResultSetNodes.item(i)));
            }
        }
    }

    protected void processTable(XMLDescriptorMetadata dmd, Node node) {
        if (dmd.ignoreTableAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_TABLE, dmd.getJavaClass());
        } else {
            Node result = this.m_xPathEngine.selectSingleNode(node, new String[]{"table"});
            if (result != null) {
                String schemaName = this.m_schema;
                String catalogName = this.m_catalog;
                String tableName = "";
                Node attr = this.m_xPathEngine.selectSingleNode(result, new String[]{"@name"});
                if (attr != null) {
                    tableName = attr.getNodeValue();
                }
                if ((attr = this.m_xPathEngine.selectSingleNode(result, new String[]{"@schema"})) != null) {
                    schemaName = attr.getNodeValue();
                }
                if ((attr = this.m_xPathEngine.selectSingleNode(result, new String[]{"@catalog"})) != null) {
                    catalogName = attr.getNodeValue();
                }
                this.processTable(tableName, catalogName, schemaName, this.getUniqueConstraints(result), dmd);
            } else {
                this.processDefaultTable(dmd);
            }
        }
    }

    protected void processTemporal(MetadataAccessor metadataAccessor, DirectToFieldMapping mapping) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.hasTemporal()) {
            this.processTemporal(accessor, accessor.getTemporalNode().getNodeValue(), mapping);
        } else {
            this.getValidator().throwNoTemporalTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName());
        }
    }

    protected void processUniqueConstraints(Object[] constraints, DatabaseTable dbTable) {
        for (int i = 0; i < constraints.length; ++i) {
            dbTable.addUniqueConstraint((String[])constraints[i]);
        }
    }
}

