/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.exceptions.XMLParseException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLExceptionHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XPathEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHelper {
    private Document m_xmlDoc;
    private ClassLoader m_loader;
    private String m_defaultPkg;
    private XPathEngine m_xPathEngine = XPathEngine.getInstance();

    public XMLHelper(Document xmlDoc, ClassLoader loader) {
        this.m_loader = loader;
        this.m_xmlDoc = xmlDoc;
        Node node = this.m_xPathEngine.selectSingleNode(this.m_xmlDoc, new String[]{"entity-mappings", "package", "text()"});
        this.m_defaultPkg = node != null && node.getNodeValue() != null ? node.getNodeValue() : "";
    }

    public XMLHelper(URL xmlDocURL, ClassLoader loader) {
        this(XMLHelper.parseDocument(xmlDocURL, loader), loader);
    }

    boolean entityHasCallbackMethod(Node entityNode) {
        return this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"pre-persist"}) != null || this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"post-persist"}) != null || this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"pre-remove"}) != null || this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"post-remove"}) != null || this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"pre-update"}) != null || this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"post-update"}) != null || this.m_xPathEngine.selectSingleNode(entityNode, new String[]{"post-load"}) != null;
    }

    Class getClassForName(String className) {
        return MetadataHelper.getClassForName(this.getFullyQualifiedClassName(className), this.m_loader);
    }

    Class getClassForNode(Node node) {
        return MetadataHelper.getClassForName(this.getClassNameForNode(node), this.m_loader);
    }

    String getClassNameForNode(Node node) {
        return this.getFullyQualifiedClassName(this.m_xPathEngine.selectSingleNode(node, new String[]{"@class"}).getNodeValue());
    }

    Document getDocument() {
        return this.m_xmlDoc;
    }

    String getFullyQualifiedClassName(String className) {
        return XMLHelper.getFullyQualifiedClassName(className, this.m_defaultPkg);
    }

    static String getFullyQualifiedClassName(String className, String packageName) {
        if (packageName.equals("") || className.indexOf(".") != -1) {
            return className;
        }
        if (packageName.endsWith(".")) {
            return packageName + className;
        }
        return packageName + "." + className;
    }

    String getLoggingContextForDefaultMappingReferenceClass(Node mappingNode) {
        if (mappingNode.getLocalName().equals("one-to-one")) {
            return "metadata_default_one_to_one_reference_class";
        }
        if (mappingNode.getLocalName().equals("one-to-many")) {
            return "metadata_default_one_to_many_reference_class";
        }
        if (mappingNode.getLocalName().equals("many-to-one")) {
            return "metadata_default_many_to_one_reference_class";
        }
        return "metadata_default_many_to_many_reference_class";
    }

    Node getMappedSuperclassNode(Class entityClass) {
        for (Class parent = entityClass.getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
            Node mappedClassNode = this.locateNodeForMappedSuperclass(parent);
            if (mappedClassNode == null) continue;
            return mappedClassNode;
        }
        return null;
    }

    String getPackage() {
        return this.m_defaultPkg;
    }

    boolean isSerializedObjectConverterRequired(Class cls) {
        if (cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Character.TYPE) || cls.equals(char[].class) || cls.equals(Byte.TYPE) || cls.equals(byte[].class) || cls.equals(Short.TYPE) || cls.equals(Float.TYPE) || cls.equals(Double.TYPE) || cls.equals(Boolean.TYPE)) {
            return false;
        }
        if (cls.equals(Long.class) || cls.equals(Short.class) || cls.equals(Float.class) || cls.equals(Byte.class) || cls.equals(Byte[].class) || cls.equals(String.class) || cls.equals(Double.class) || cls.equals(Number.class) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(Character[].class) || cls.equals(BigInteger.class) || cls.equals(BigDecimal.class)) {
            return false;
        }
        return !cls.equals(Date.class) && !cls.equals(java.util.Date.class) && !cls.equals(GregorianCalendar.class) && !cls.equals(Calendar.class) && !cls.equals(Timestamp.class);
    }

    Class locateClassForEntity(String entityName) {
        XPathEngine xPathEngine = XPathEngine.getInstance();
        Node entityNode = this.locateNodeForEntity(entityName);
        if (entityNode != null) {
            return MetadataHelper.getClassForName(this.getFullyQualifiedClassName(xPathEngine.selectSingleNode(entityNode, new String[]{"@class"}).getNodeValue()), this.m_loader);
        }
        return null;
    }

    Node locateNode(Class cls) {
        Node result = null;
        result = this.locateNodeForEntity(cls);
        if (result == null) {
            result = this.locateNodeForMappedSuperclass(cls);
        }
        if (result == null) {
            result = this.locateNodeForEmbeddable(cls);
        }
        return result;
    }

    Node locateNode(Class cls, String searchString) {
        NodeList nodes = this.m_xPathEngine.selectNodes(this.m_xmlDoc, new String[]{"entity-mappings", searchString});
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!this.getClassNameForNode(node).equals(cls.getName())) continue;
                return node;
            }
        }
        return null;
    }

    Node locateNodeForAttribute(Node node, String attributeName) {
        NodeList attributeNodes = this.m_xPathEngine.selectNodes(node, new String[]{"attributes", "child::*"});
        if (attributeNodes != null) {
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                Node attributeNode = attributeNodes.item(i);
                if (!this.m_xPathEngine.selectSingleNode(attributeNode, new String[]{"@name"}).getNodeValue().equals(attributeName)) continue;
                return attributeNode;
            }
        }
        return null;
    }

    Node locateNodeForEntityAttribute(Class owningClass, String attributeName) {
        Node node = this.locateNodeForEntity(owningClass);
        if (node == null) {
            return null;
        }
        return this.locateNodeForAttribute(node, attributeName);
    }

    Node locateNodeForEmbeddable(Class cls) {
        return this.locateNode(cls, "embeddable");
    }

    Node locateNodeForEmbeddable(String embeddable) {
        NodeList nodes = this.m_xPathEngine.selectNodes(this.m_xmlDoc, new String[]{"entity-mappings", "embeddable"});
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node attr = this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"});
                if (attr == null || !attr.getNodeValue().equals(embeddable)) continue;
                return node;
            }
        }
        return null;
    }

    Node locateNodeForEntity(Class cls) {
        return this.locateNode(cls, "entity");
    }

    Node locateNodeForEntity(String entityName) {
        NodeList nodes = this.m_xPathEngine.selectNodes(this.m_xmlDoc, new String[]{"entity-mappings", "entity"});
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node attr = this.m_xPathEngine.selectSingleNode(node, new String[]{"@name"});
                if (attr == null || !attr.getNodeValue().equals(entityName)) continue;
                return node;
            }
        }
        return null;
    }

    Node locateNodeForMappedSuperclassAttribute(Class owningClass, String attributeName) {
        Node node = this.locateNodeForMappedSuperclass(owningClass);
        if (node == null) {
            return null;
        }
        return this.locateNodeForAttribute(node, attributeName);
    }

    Node locateNodeForMappedSuperclass(Class cls) {
        return this.locateNode(cls, "mapped-superclass");
    }

    Class locateParentEntity(Class entityClass) {
        Class superClass = entityClass.getSuperclass();
        if (superClass != null) {
            while (superClass != Object.class) {
                if (this.locateNodeForEntity(superClass) != null) {
                    return superClass;
                }
                superClass = superClass.getSuperclass();
            }
        }
        return entityClass;
    }

    Class locateRootEntity(Class entityClass) {
        Node entityNode;
        Class superClass = entityClass.getSuperclass();
        if (superClass != null && (entityNode = this.locateNodeForEntity(superClass)) != null) {
            return this.locateRootEntity(superClass);
        }
        return entityClass;
    }

    boolean nodeHasInheritance(Node node) {
        if (node == null) {
            return false;
        }
        return this.m_xPathEngine.selectSingleNode(node, new String[]{"inheritance"}) != null;
    }

    boolean nodeHasPrimaryKeyJoinColumns(Node node) {
        if (node == null) {
            return false;
        }
        NodeList nodes = this.m_xPathEngine.selectNodes(node, new String[]{"primary-key-join-column"});
        return nodes != null && nodes.getLength() > 0;
    }

    static Document parseDocument(URL xmlDocumentURL, ClassLoader loader) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dbf.setValidating(true);
        URL schemaURL = loader.getResource("orm_1_0.xsd");
        if (schemaURL != null) {
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL.toString());
        }
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pex) {
            throw XMLParseException.exceptionCreatingDocumentBuilder(xmlDocumentURL.getFile(), pex);
        }
        XMLExceptionHandler xmlExceptionHandler = new XMLExceptionHandler();
        db.setErrorHandler(xmlExceptionHandler);
        Document doc = null;
        try {
            doc = db.parse(xmlDocumentURL.openStream());
        }
        catch (IOException ioex) {
            throw XMLParseException.exceptionReadingXMLDocument(xmlDocumentURL.getFile(), ioex);
        }
        catch (SAXException saxex) {
            // empty catch block
        }
        XMLException xmlEx = xmlExceptionHandler.getXMLException();
        if (xmlEx != null) {
            throw ValidationException.invalidEntityMappingsDocument(xmlDocumentURL.getFile(), xmlEx);
        }
        return doc;
    }
}

