/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.expressions.ExpressionOperator;
import oracle.toplink.essentials.internal.expressions.CompoundExpression;
import oracle.toplink.essentials.internal.expressions.ConstantExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.FieldExpression;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.ParameterExpression;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.expressions.TableAliasLookup;
import oracle.toplink.essentials.internal.expressions.TableExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;

public class RelationExpression
extends CompoundExpression {
    protected boolean allChildrenAreFields() {
        return this.getFirstChild().getFields().size() == 1 && this.getSecondChild().getFields().size() == 1;
    }

    protected void convertNodeToUseOuterJoin() {
        if (this.getOperator().getSelector() == 4 && this.allChildrenAreFields()) {
            this.setOperator(this.getOperator(6));
        }
    }

    public String descriptionOfNodeType() {
        return "Relation";
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        Object rightValue = this.getSecondChild().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        Object leftValue = this.getFirstChild().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        if (rightValue instanceof Vector) {
            Enumeration rightEnum = ((Vector)rightValue).elements();
            while (rightEnum.hasMoreElements()) {
                Object tempRight = rightEnum.nextElement();
                if (leftValue instanceof Vector && this.doesAnyOfLeftValuesConform((Vector)leftValue, tempRight, session)) {
                    return true;
                }
                if (!this.doValuesConform(leftValue, tempRight, session)) continue;
                return true;
            }
            return false;
        }
        if (leftValue instanceof Vector) {
            return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
        }
        return this.doValuesConform(leftValue, rightValue, session);
    }

    protected boolean doesAnyOfLeftValuesConform(Vector leftValues, Object rightValue, AbstractSession session) {
        for (int index = 0; index < leftValues.size(); ++index) {
            Object leftValue = leftValues.get(index);
            if (!this.doValuesConform(leftValue, rightValue, session)) continue;
            return true;
        }
        return false;
    }

    protected boolean doValuesConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (this.isObjectComparison()) {
            return this.doesObjectConform(leftValue, rightValue, session);
        }
        return this.getOperator().doesRelationConform(leftValue, rightValue);
    }

    public boolean doesObjectConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (leftValue == null && rightValue == null) {
            return this.performSelector(true);
        }
        if (leftValue == null || rightValue == null) {
            return this.performSelector(false);
        }
        Class<?> javaClass = leftValue.getClass();
        if (javaClass != rightValue.getClass()) {
            return this.performSelector(false);
        }
        ClassDescriptor descriptor = session.getDescriptor(javaClass);
        if (descriptor.isAggregateDescriptor()) {
            throw QueryException.cannotConformExpression();
        }
        Vector leftPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(leftValue, session);
        Vector rightPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(rightValue, session);
        CacheKey rightCacheKey = new CacheKey(rightPrimaryKey);
        CacheKey leftCacheKey = new CacheKey(leftPrimaryKey);
        return this.performSelector(rightCacheKey.equals(leftCacheKey));
    }

    public boolean extractPrimaryKeyValues(boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        if (requireExactMatch && this.getOperator().getSelector() != 4) {
            return false;
        }
        if (!requireExactMatch && this.getOperator().getSelector() == 13) {
            return false;
        }
        DatabaseField field = null;
        Object value = null;
        if (this.getSecondChild().isConstantExpression()) {
            value = ((ConstantExpression)this.getSecondChild()).getValue();
        } else if (this.getSecondChild().isParameterExpression()) {
            value = translationRow.get(((ParameterExpression)this.getSecondChild()).getField());
        } else if (this.getFirstChild().isConstantExpression()) {
            value = ((ConstantExpression)this.getFirstChild()).getValue();
        } else if (this.getFirstChild().isParameterExpression()) {
            value = translationRow.get(((ParameterExpression)this.getFirstChild()).getField());
        }
        if (value == null) {
            return false;
        }
        if (this.getFirstChild().isFieldExpression()) {
            if (this.getFirstChild().getBuilder() != ((FieldExpression)this.getFirstChild()).getBaseExpression()) {
                return false;
            }
            field = ((FieldExpression)this.getFirstChild()).getField();
        } else if (this.getFirstChild().isQueryKeyExpression()) {
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(((QueryKeyExpression)this.getFirstChild()).getName());
            if (mapping != null && !mapping.isPrimaryKeyMapping()) {
                return false;
            }
            if (mapping != null && (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping())) {
                mapping.writeFromAttributeIntoRow(value, primaryKeyRow, this.getSession());
                return true;
            }
            if (this.getFirstChild().getBuilder() != ((QueryKeyExpression)this.getFirstChild()).getBaseExpression() || mapping != null && !mapping.isDirectToFieldMapping()) {
                return false;
            }
            field = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.getFirstChild().getName());
        } else if (this.getSecondChild().isFieldExpression()) {
            if (this.getFirstChild().getBuilder() != ((FieldExpression)this.getSecondChild()).getBaseExpression()) {
                return false;
            }
            field = ((FieldExpression)this.getSecondChild()).getField();
        } else if (this.getSecondChild().isQueryKeyExpression()) {
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(((QueryKeyExpression)this.getSecondChild()).getName());
            if (mapping != null && !mapping.isPrimaryKeyMapping()) {
                return false;
            }
            if (mapping != null && (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping())) {
                mapping.writeFromAttributeIntoRow(value, primaryKeyRow, this.getSession());
                return true;
            }
            if (this.getSecondChild().getBuilder() != ((QueryKeyExpression)this.getSecondChild()).getBaseExpression() || mapping != null && !mapping.isDirectToFieldMapping()) {
                return false;
            }
            field = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.getSecondChild().getName());
        } else {
            return false;
        }
        if (field == null || !descriptor.getPrimaryKeyFields().contains(field)) {
            return false;
        }
        primaryKeyRow.put(field, value);
        return true;
    }

    public boolean isEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 4) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    public boolean isNotEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 5) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    protected boolean isObjectComparison() {
        if (!this.getFirstChild().isObjectExpression() || ((ObjectExpression)this.getFirstChild()).isAttribute()) {
            return false;
        }
        DatabaseMapping mapping = ((ObjectExpression)this.getFirstChild()).getMapping();
        if (mapping != null && mapping.isDirectCollectionMapping()) {
            return false;
        }
        return this.getSecondChild().isObjectExpression() || this.getSecondChild().isValueExpression();
    }

    public boolean isRelationExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (!this.isObjectComparison()) {
            return super.normalize(normalizer);
        }
        this.validateNode();
        if (this.getOperator().getSelector() != 4 && this.getOperator().getSelector() != 5) {
            throw QueryException.invalidOperatorForObjectComparison(this);
        }
        Expression foreignKeyJoin = null;
        ObjectExpression first = (ObjectExpression)this.getFirstChild();
        if (first.isExpressionBuilder() && this.getSecondChild().isQueryKeyExpression() && !((QueryKeyExpression)this.getSecondChild()).hasDerivedExpressions()) {
            first = (ExpressionBuilder)first.normalize(normalizer);
            Vector foreignKeyJoinPointer = new Vector(1);
            QueryKeyExpression second = (QueryKeyExpression)this.getSecondChild();
            if (second.hasBeenNormalized()) {
                second.setHasBeenNormalized(false);
            }
            second = (QueryKeyExpression)second.normalize(normalizer, foreignKeyJoinPointer);
            if (!foreignKeyJoinPointer.isEmpty()) {
                foreignKeyJoin = (Expression)foreignKeyJoinPointer.firstElement();
                if (first.getTableAliases() == null) {
                    TableAliasLookup tableAliases = new TableAliasLookup();
                    first.setTableAliases(tableAliases);
                    second.setTableAliases(tableAliases);
                } else {
                    second.setTableAliases(first.getTableAliases());
                }
            }
        } else if (!first.isExpressionBuilder() && !((QueryKeyExpression)first).shouldQueryToManyRelationship() && ((QueryKeyExpression)first).getMapping() != null) {
            if (first.getBaseExpression() != null) {
                first.setBaseExpression(first.getBaseExpression().normalize(normalizer));
            }
            if (this.getSecondChild().isConstantExpression()) {
                Object targetObject = ((ConstantExpression)this.getSecondChild()).getValue();
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, targetObject, this.getSession());
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, this.getSecondChild(), this.getSession());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (foreignKeyJoin == null) {
            first = (ObjectExpression)first.normalize(normalizer);
            if (this.getSecondChild().isConstantExpression()) {
                Expression keyExpression = first.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(((ConstantExpression)this.getSecondChild()).getValue(), this.getSession());
                foreignKeyJoin = first.twist(keyExpression, first);
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                foreignKeyJoin = first.twist(first.getDescriptor().getObjectBuilder().getPrimaryKeyExpression(), this.getSecondChild());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (this.getOperator().getSelector() == 5) {
            foreignKeyJoin = foreignKeyJoin.not();
        }
        return foreignKeyJoin.normalize(normalizer);
    }

    public boolean performSelector(boolean areValuesEqual) {
        int n = this.getOperator().getSelector();
        this.getOperator();
        if (n == 4) {
            return areValuesEqual;
        }
        int n2 = this.getOperator().getSelector();
        this.getOperator();
        if (n2 == 5) {
            return !areValuesEqual;
        }
        throw QueryException.cannotConformExpression();
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (this.isEqualNull(printer)) {
            this.getFirstChild().isNull().printSQL(printer);
        } else if (this.isNotEqualNull(printer)) {
            this.getFirstChild().notNull().printSQL(printer);
        } else {
            super.printSQL(printer);
        }
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        Expression tempFirstChild = this.getFirstChild();
        Expression tempSecondChild = this.getSecondChild();
        realOperator.printJavaDuo(tempFirstChild, tempSecondChild, printer);
    }

    public void printSQLNoParens(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printDuo(this.getFirstChild(), this.getSecondChild(), printer);
    }

    public void validateNode() {
        if (this.getFirstChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getFirstChild()).getTable());
        }
        if (this.getSecondChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getSecondChild()).getTable());
        }
    }
}

