/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.AggregateNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class CountNode
extends AggregateNode {
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            if (this.getLeft().isDotNode()) {
                reportQuery.addCount(this.resolveAttribute(), this.getArgumentExpression(context), Long.class);
            } else {
                reportQuery.addCount("COUNT", this.getArgumentExpression(context), Long.class);
            }
        }
    }

    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            this.left.validate(context);
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.getLongClassType());
        }
    }

    public Expression generateExpression(GenerationContext context) {
        return this.getArgumentExpression(context).count();
    }

    public boolean isCountNode() {
        return true;
    }

    public String getAsString() {
        return "COUNT(" + this.left.getAsString() + ")";
    }
}

