/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.ArrayList;
import java.util.List;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.DotNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.QueryNode;
import oracle.toplink.essentials.internal.parsing.SelectGenerationContext;
import oracle.toplink.essentials.internal.parsing.VariableNode;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class SelectNode
extends QueryNode {
    private List selectExpressions = new ArrayList();
    private boolean distinct = false;

    private void addSelectExpression(Object theNode) {
        this.selectExpressions.add(theNode);
    }

    public List getSelectExpressions() {
        return this.selectExpressions;
    }

    public void setSelectExpressions(List exprs) {
        this.selectExpressions = exprs;
    }

    public boolean usesDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void applyToQuery(DatabaseQuery theQuery, GenerationContext context) {
        ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)theQuery;
        if (this.selectExpressions.isEmpty()) {
            return;
        }
        if (!(this.isSingleSelectExpression() && this.getFirstSelectExpressionNode().isCountNode() || !this.usesDistinct())) {
            this.getParseTree().setDistinctState((short)1);
            readQuery.setDistinctState((short)1);
        }
        if (readQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)readQuery;
            reportQuery.returnWithoutReportQueryResult();
            if (this.isSingleSelectExpression() && !this.getFirstSelectExpressionNode().isConstructorNode()) {
                reportQuery.returnSingleAttribute();
            }
        }
        for (Node node : this.selectExpressions) {
            node.applyToQuery(readQuery, context);
        }
        if (this.hasOneToOneSelected(context)) {
            readQuery.setProperty("return null if primary key is null", Boolean.TRUE);
        } else {
            readQuery.removeProperty("return null if primary key is null");
        }
    }

    public boolean hasOneToOneSelected(GenerationContext context) {
        for (Node node : this.selectExpressions) {
            if (!this.hasOneToOneSelected(node, context)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOneToOneSelected(Node node, GenerationContext context) {
        if (node.isCountNode()) {
            return false;
        }
        if (node.isAggregateNode()) {
            return this.hasOneToOneSelected(node.getLeft(), context);
        }
        if (node.isVariableNode()) {
            return !this.nodeRefersToObject(node, context);
        }
        return !this.selectingDirectToField(node, context);
    }

    public boolean hasAttributeSelected(Node node, GenerationContext context) {
        if (node == null) {
            return false;
        }
        if (this.selectingDirectToField(node, context)) {
            return true;
        }
        if (node.isAggregateNode()) {
            return this.hasAttributeSelected(node.getLeft(), context);
        }
        return false;
    }

    public void verifySelectedAlias(GenerationContext context) {
        for (Node node : this.selectExpressions) {
            if (node.isDotNode()) {
                return;
            }
            node.resolveClass(context);
        }
    }

    public boolean isSelected(String variableName) {
        for (Node node : this.selectExpressions) {
            if (!node.isVariableNode() || !((VariableNode)node).getCanonicalVariableName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectNode() {
        return true;
    }

    public void validate(ParseTreeContext context) {
        for (Node item : this.selectExpressions) {
            item.validate(context);
        }
    }

    public Class resolveClass(GenerationContext context) {
        return this.getReferenceClass(context);
    }

    public Expression generateExpression(GenerationContext context) {
        Expression expression = null;
        for (Node node : this.selectExpressions) {
            if (node.isVariableNode()) {
                String variableNameForLeft = ((VariableNode)node).getCanonicalVariableName();
                if (context.getParseTreeContext().isRangeVariable(variableNameForLeft)) continue;
            }
            if (this.selectingDirectToField(node, context) || node.isAggregateNode()) continue;
            if (!this.hasAttributeSelected(node, context) && !node.isCountNode()) {
                ((SelectGenerationContext)context).useOuterJoins();
            }
            Expression generatedExpression = node.generateExpression(context);
            ((SelectGenerationContext)context).dontUseOuterJoins();
            if (!node.isVariableNode()) continue;
            Expression nodeExpression = context.selectedExpressionFor(((VariableNode)node).getCanonicalVariableName());
            if (nodeExpression != null) {
                generatedExpression = nodeExpression.getBuilder().getQueryClass() == context.getBaseQueryClass() ? nodeExpression.equal(generatedExpression) : generatedExpression.equal(nodeExpression);
            }
            if (expression == null) {
                expression = generatedExpression;
                continue;
            }
            expression.and(generatedExpression);
        }
        return expression;
    }

    public Class getReferenceClass(GenerationContext context) {
        return this.getClassOfFirstVariable(context);
    }

    private Class getClassOfFirstVariable(GenerationContext context) {
        Class clazz = null;
        String variable = this.getParseTree().getFromNode().getFirstVariable();
        ParseTreeContext parseTreeContext = context.getParseTreeContext();
        if (parseTreeContext.isRangeVariable(variable)) {
            String schema = parseTreeContext.schemaForVariable(variable);
            clazz = parseTreeContext.classForSchemaName(schema, context);
        } else {
            Node path = parseTreeContext.pathForVariable(variable);
            clazz = path.resolveClass(context);
        }
        return clazz;
    }

    public boolean isVariableInINClauseSelected(GenerationContext context) {
        for (Node node : this.selectExpressions) {
            if (!node.isVariableNode()) continue;
            String variableNameForLeft = ((VariableNode)node).getCanonicalVariableName();
            if (context.getParseTreeContext().isRangeVariable(variableNameForLeft)) continue;
            return true;
        }
        return false;
    }

    public boolean nodeRefersToObject(Node node, GenerationContext context) {
        ClassDescriptor descriptor;
        if (!node.isVariableNode()) {
            return false;
        }
        String name = ((VariableNode)node).getCanonicalVariableName();
        String alias = context.getParseTreeContext().schemaForVariable(name);
        return alias != null && (descriptor = context.getSession().getDescriptorForAlias(alias)) != null;
    }

    private boolean selectingDirectToField(Node node, GenerationContext context) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        return ((DotNode)node).endsWithDirectToField(context);
    }

    private Node getFirstSelectExpressionNode() {
        return this.selectExpressions.size() > 0 ? (Node)this.selectExpressions.get(0) : null;
    }

    private boolean isSingleSelectExpression() {
        return this.selectExpressions.size() == 1;
    }
}

