/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings.converters;

import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.sessions.Session;

public class ClassInstanceConverter
implements Converter {
    protected DatabaseMapping mapping;

    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object attributeValue = null;
        if (fieldValue != null) {
            Class attributeClass = (Class)((AbstractSession)session).getDatasourcePlatform().convertObject(fieldValue, ClassConstants.CLASS);
            try {
                attributeValue = PrivilegedAccessController.newInstanceFromClass(attributeClass);
            }
            catch (Exception exception) {
                throw ConversionException.couldNotBeConverted(fieldValue, attributeClass, exception);
            }
        }
        return attributeValue;
    }

    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        if (attributeValue == null) {
            return null;
        }
        return attributeValue.getClass().getName();
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        AbstractDirectMapping directMapping;
        this.mapping = mapping;
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(ClassConstants.STRING);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    public boolean isMutable() {
        return false;
    }
}

