/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings.converters;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.Association;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.sessions.Session;

public class ObjectTypeConverter
implements Converter {
    protected DatabaseMapping mapping;
    protected transient Map fieldToAttributeValues;
    protected Map attributeToFieldValues = new HashMap(10);
    protected transient Object defaultAttributeValue;
    protected transient Class fieldClassification;
    protected transient String fieldClassificationName;

    public ObjectTypeConverter() {
        this.fieldToAttributeValues = new HashMap(10);
    }

    public ObjectTypeConverter(DatabaseMapping mapping) {
        this();
        this.mapping = mapping;
    }

    public void addConversionValue(Object fieldValue, Object attributeValue) {
        if (fieldValue == null) {
            fieldValue = Helper.getNullWrapper();
        }
        if (attributeValue == null) {
            attributeValue = Helper.getNullWrapper();
        }
        this.getFieldToAttributeValues().put(fieldValue, attributeValue);
        this.getAttributeToFieldValues().put(attributeValue, fieldValue);
    }

    public void addToAttributeOnlyConversionValue(Object fieldValue, Object attributeValue) {
        if (fieldValue == null) {
            fieldValue = Helper.getNullWrapper();
        }
        if (attributeValue == null) {
            attributeValue = Helper.getNullWrapper();
        }
        this.getFieldToAttributeValues().put(fieldValue, attributeValue);
    }

    public Map getAttributeToFieldValues() {
        return this.attributeToFieldValues;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object attributeValue = null;
        if (fieldValue == null) {
            attributeValue = this.getFieldToAttributeValues().get(Helper.getNullWrapper());
        } else {
            try {
                fieldValue = ((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(fieldValue, this.getFieldClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
            }
            attributeValue = this.getFieldToAttributeValues().get(fieldValue);
            if (attributeValue == null) {
                if (this.getDefaultAttributeValue() != null) {
                    attributeValue = this.getDefaultAttributeValue();
                } else {
                    throw DescriptorException.noFieldValueConversionToAttributeValueProvided(fieldValue, this.getMapping().getField(), this.getMapping());
                }
            }
        }
        return attributeValue;
    }

    public Object getDefaultAttributeValue() {
        return this.defaultAttributeValue;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public Class getFieldClassification() {
        return this.fieldClassification;
    }

    public String getFieldClassificationName() {
        if (this.fieldClassificationName == null && this.fieldClassification != null) {
            this.fieldClassificationName = this.fieldClassification.getName();
        }
        return this.fieldClassificationName;
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) {
        return this.getFieldClassification();
    }

    public Map getFieldToAttributeValues() {
        return this.fieldToAttributeValues;
    }

    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        Object fieldValue;
        if (attributeValue == null) {
            fieldValue = this.getAttributeToFieldValues().get(Helper.getNullWrapper());
        } else {
            fieldValue = this.getAttributeToFieldValues().get(attributeValue);
            if (fieldValue == null) {
                throw DescriptorException.noAttributeValueConversionToFieldValueProvided(attributeValue, this.getMapping());
            }
        }
        return fieldValue;
    }

    public boolean isObjectTypeMapping() {
        return true;
    }

    public void mapBooleans() {
        this.addConversionValue("F", new Boolean(false));
        this.addConversionValue("T", new Boolean(true));
    }

    public void mapGenders() {
        this.addConversionValue("F", "Female");
        this.addConversionValue("M", "Male");
    }

    public void mapResponses() {
        this.addConversionValue("Y", "Yes");
        this.addConversionValue("N", "No");
    }

    public void initializeFieldClassification(Session session) throws DescriptorException {
        AbstractDirectMapping directMapping;
        if (this.getFieldToAttributeValues().isEmpty()) {
            return;
        }
        Class<?> type = null;
        Iterator fieldValuesEnum = this.getFieldToAttributeValues().keySet().iterator();
        while (fieldValuesEnum.hasNext() && type == null) {
            Object value = fieldValuesEnum.next();
            if (value == Helper.getNullWrapper()) continue;
            type = value.getClass();
        }
        this.setFieldClassification(type);
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(type);
        }
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        this.mapping = mapping;
        this.initializeFieldClassification(session);
    }

    public void setAttributeToFieldValues(Map attributeToFieldValues) {
        this.attributeToFieldValues = attributeToFieldValues;
    }

    public void setDefaultAttributeValue(Object defaultAttributeValue) {
        this.defaultAttributeValue = defaultAttributeValue;
    }

    public void setFieldClassification(Class fieldClassification) {
        this.fieldClassification = fieldClassification;
    }

    public void setFieldClassificationName(String fieldClassificationName) {
        this.fieldClassificationName = fieldClassificationName;
    }

    public void setFieldToAttributeValueAssociations(Vector fieldToAttributeValueAssociations) {
        this.setFieldToAttributeValues(new Hashtable(fieldToAttributeValueAssociations.size() + 1));
        this.setAttributeToFieldValues(new Hashtable(fieldToAttributeValueAssociations.size() + 1));
        Enumeration associationsEnum = fieldToAttributeValueAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = (Association)associationsEnum.nextElement();
            this.addConversionValue(association.getKey(), association.getValue());
        }
    }

    public void setFieldToAttributeValues(Map fieldToAttributeValues) {
        this.fieldToAttributeValues = fieldToAttributeValues;
    }

    public boolean isMutable() {
        return false;
    }
}

