/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedString;
import org.jCharts.Legend;
import org.jCharts.imageMap.ImageMap;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.test.HTMLGenerator;

public abstract class Chart
implements Serializable {
    private Graphics2D graphics2D;
    private int width;
    private int height;
    private Legend legend;
    private ChartProperties chartProperties;
    private boolean generateImageMap = false;
    private ImageMap imageMap = null;
    private BufferedImage bufferedImage = null;

    public Chart(LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.chartProperties = chartProperties;
        if (legendProperties != null) {
            this.legend = new Legend(this, legendProperties);
        }
    }

    public boolean getGenerateImageMapFlag() {
        return this.generateImageMap;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void renderWithImageMap() {
        this.bufferedImage = new BufferedImage(this.getImageWidth(), this.getImageHeight(), 1);
        this.setGraphics2D(this.bufferedImage.createGraphics());
        this.generateImageMap = true;
        this.render();
    }

    public void render() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
        this.graphics2D.setPaint(this.chartProperties.getBackgroundPaint());
        this.graphics2D.fill(float_);
        if (this.chartProperties.getBorderStroke() != null) {
            this.graphics2D.setPaint(this.chartProperties.getBorderPaint());
            this.graphics2D.setStroke(this.chartProperties.getBorderStroke());
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            this.graphics2D.draw(float_);
        }
        this.renderChart();
    }

    protected float renderChartTitle(String string, FontRenderContext fontRenderContext) {
        float f = 0.0f;
        if (string != null) {
            TextLayout textLayout = null;
            float f2 = this.getChartProperties().getEdgePadding();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.getChartProperties().getTitleFont());
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            this.getGraphics2D().setPaint(this.getChartProperties().getTitlePaint());
            while ((textLayout = lineBreakMeasurer.nextLayout((float)this.getImageWidth() - this.getChartProperties().getEdgePadding() * 2.0f)) != null) {
                textLayout.draw(this.getGraphics2D(), ((float)this.getImageWidth() - textLayout.getAdvance()) / 2.0f, f2 += textLayout.getAscent());
                f += f2 + textLayout.getDescent();
            }
        }
        return f;
    }

    protected abstract void renderChart();

    public final int getImageWidth() {
        return this.width;
    }

    public final int getImageHeight() {
        return this.height;
    }

    public final ChartProperties getChartProperties() {
        return this.chartProperties;
    }

    protected final Legend getLegend() {
        return this.legend;
    }

    public final boolean hasLegend() {
        return this.legend != null;
    }

    public final void setGraphics2D(Graphics2D graphics2D) {
        this.graphics2D = graphics2D;
    }

    public final Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    public final void setImageMap(ImageMap imageMap) {
        this.imageMap = imageMap;
    }

    public final ImageMap getImageMap() {
        return this.imageMap;
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string) {
        hTMLGenerator.chartTableStart(this.getClass().getName(), string);
        hTMLGenerator.chartTableRowStart();
        this.chartProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        if (this.legend != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

