/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.util.HashSet;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumns;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.helper.DatabaseField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsDescriptor
extends MetadataDescriptor {
    private HashSet<NamedQuery> m_namedQueries;
    private HashSet<NamedNativeQuery> m_namedNativeQueries;

    public AnnotationsDescriptor(Class javaClass) {
        super(javaClass);
        this.init();
    }

    public AnnotationsDescriptor(ClassDescriptor descriptor, Class javaClass) {
        super(descriptor, javaClass);
        this.init();
    }

    public AnnotationsDescriptor(MetadataDescriptor md) {
        super(md);
        this.m_mappedSuperclasses = null;
        this.init();
    }

    public void addNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.m_namedNativeQueries.add(namedNativeQuery);
    }

    public void addNamedQuery(NamedQuery namedQuery) {
        this.m_namedQueries.add(namedQuery);
    }

    public HashSet<NamedNativeQuery> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public HashSet<NamedQuery> getNamedQueries() {
        return this.m_namedQueries;
    }

    @Override
    public void handlePotentialDefaultTableUsage(DatabaseField dbField) {
    }

    @Override
    protected boolean hasEntityTag(Class cls) {
        return cls.isAnnotationPresent(Entity.class);
    }

    @Override
    protected boolean hasInheritanceTag(Class entityClass) {
        return entityClass.isAnnotationPresent(Inheritance.class);
    }

    @Override
    protected boolean hasMappedSuperclassTag(Class cls) {
        return cls.isAnnotationPresent(MappedSuperclass.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return this.m_javaClass.isAnnotationPresent(PrimaryKeyJoinColumns.class);
    }

    private void init() {
        this.m_namedQueries = new HashSet();
        this.m_namedNativeQueries = new HashSet();
    }

    public void setInheritanceStrategy(InheritanceType inheritanceStrategy) {
        if (inheritanceStrategy == InheritanceType.TABLE_PER_CLASS) {
            throw ValidationException.tablePerClassInheritanceNotSupported(this.m_javaClass);
        }
        this.m_usesSingleTableInheritanceStrategy = inheritanceStrategy == InheritanceType.SINGLE_TABLE;
    }

    @Override
    public boolean usesPropertyAccess() {
        if (this.isInheritanceSubclass()) {
            return AnnotationsHelper.usesPropertyAccess((AnnotationsDescriptor)this.getInheritanceRootDmd());
        }
        return AnnotationsHelper.usesPropertyAccess(this);
    }
}

