/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.Clob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.mappings.converters.EnumTypeConverter;
import oracle.toplink.essentials.mappings.converters.SerializedObjectConverter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;

public abstract class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataLogger m_logger;
    protected MetadataValidator m_validator;
    protected AbstractSession m_session;
    protected HashMap m_metadataDescriptors;
    protected boolean m_enableLazyForOneToOne;
    protected HashSet m_relatedEntities;

    protected void addJoinColumnDefault(List joinColumns, String sourceTableName, String targetTableName, MetadataDescriptor md) {
        if (joinColumns.isEmpty()) {
            MetadataJoinColumn mjc = new MetadataJoinColumn();
            mjc.getPrimaryKeyField().setTableName(sourceTableName);
            mjc.getForeignKeyField().setTableName(targetTableName);
            md.handlePotentialDefaultTableUsage(mjc.getForeignKeyField());
            joinColumns.add(mjc);
        }
    }

    protected void addManyToManyRelationKeyFields(List relationKeys, ManyToManyMapping mapping, MetadataAccessor accessor, String defaultFieldName, MetadataDescriptor md, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (md.hasCompositePrimaryKey()) {
            if (relationKeys.size() != md.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
            }
        } else {
            this.addJoinColumnDefault(relationKeys, md.getPrimaryTableName(), mapping.getRelationTableQualifiedName(), md);
        }
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        if (!this.handlePotentialPartialManyToManyRelationshipMapping(mapping, isSource, relationKeys)) {
            for (MetadataJoinColumn mjc : relationKeys) {
                String defaultPKFieldName = md.getPrimaryKeyFieldName();
                DatabaseField pkField = mjc.getPrimaryKeyField();
                if (mapping.requiresCompletion() && !isSource) {
                    pkField.setName(mapping.getXMLPKNameAttribute());
                }
                pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX, accessor));
                DatabaseField fkField = mjc.getForeignKeyField();
                String defaultFKFieldName = defaultFieldName + "_" + defaultPKFieldName;
                if (mapping.requiresCompletion() && !isSource) {
                    fkField.setName(mapping.getXMLFKNameAttribute());
                }
                fkField.setName(this.getName(fkField, defaultFKFieldName, FK_CTX, accessor));
                if (isSource) {
                    mapping.addSourceRelationKeyField(fkField, pkField);
                    continue;
                }
                mapping.addTargetRelationKeyField(fkField, pkField);
            }
        }
    }

    protected void addMultipleTableKeyField(MetadataJoinColumn mjc, String PK_CTX, String FK_CTX, MetadataDescriptor md) {
        String defaultPKFieldName = md.getPrimaryKeyFieldName();
        DatabaseField pkField = mjc.getPrimaryKeyField();
        pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX, md));
        DatabaseField fkField = mjc.getForeignKeyField();
        fkField.setName(this.getName(fkField, pkField.getName(), FK_CTX, md));
        if (fkField.getName().equals(pkField.getName())) {
            md.addMultipleTablePrimaryKeyField(pkField, fkField);
        } else {
            md.addMultipleTableForeignKeyField(pkField, fkField);
        }
    }

    protected DatabaseTable buildJoinTable(MetadataAccessor accessor) {
        return this.buildJoinTable("", "", "", accessor);
    }

    protected DatabaseTable buildJoinTable(String name, String catalog, String schema, MetadataAccessor accessor) {
        String sourceName = Helper.getShortClassName(accessor.getJavaClassName()).toUpperCase();
        String targetName = Helper.getShortClassName(accessor.getReferenceClassName()).toUpperCase();
        String defaultName = sourceName + "_" + targetName;
        Object element = accessor.getAnnotatedElement();
        name = this.getName(name, defaultName, "metadata_default_join_table_name", element);
        return this.buildTable(name, catalog, "metadata_default_join_table_catalog", schema, "metadata_default_join_table_schema", element, accessor.getMetadataDescriptor());
    }

    protected DatabaseTable buildTable(String name, String catalog, String schema, MetadataDescriptor md) {
        name = this.getName(name, md.getDefaultTableName(), "metadata_default_table_name", md.getJavaClass());
        return this.buildTable(name, catalog, "metadata_default_table_catalog", schema, "metadata_default_table_schema", md.getJavaClass(), md);
    }

    protected DatabaseTable buildTable(String name, String catalog, String catalogContext, String schema, String schemaContext, Object element, MetadataDescriptor md) {
        catalog = this.getName(catalog, md.getCatalog(), catalogContext, element);
        schema = this.getName(schema, md.getSchema(), schemaContext, element);
        return new DatabaseTable(MetadataHelper.getFullyQualifiedTableName(name, catalog, schema));
    }

    protected DatabaseField getDatabaseField(MetadataAccessor accessor) {
        if (accessor.getMetadataDescriptor().hasAttributeOverrideFor(accessor)) {
            return accessor.getMetadataDescriptor().getAttributeOverrideFor(accessor);
        }
        return this.processColumn(accessor);
    }

    public abstract MetadataLogger getLogger();

    public abstract MetadataDescriptor getMetadataDescriptor(Class var1);

    protected String getName(DatabaseField field, String defaultName, String context, MetadataAccessor accessor) {
        String name = field.getName();
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return name;
        }
        this.getLogger().logConfigMessage(context, accessor.getAnnotatedElement(), (Object)defaultName);
        this.handlePotentialDefaultPrimaryKeyUsage(field, accessor, defaultName, context);
        return defaultName;
    }

    protected String getName(DatabaseField field, String defaultName, String context, MetadataDescriptor md) {
        String name = field.getName();
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return name;
        }
        this.getLogger().logConfigMessage(context, md.getJavaClass(), (Object)defaultName);
        if (defaultName.equals(md.getPrimaryKeyFieldName())) {
            this.handlePotentialDefaultPrimaryKeyUsage(field, md);
        }
        return defaultName;
    }

    protected String getName(String name, String defaultName, String context, Object element) {
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return name;
        }
        this.getLogger().logConfigMessage(context, element, (Object)defaultName);
        return defaultName;
    }

    protected DatabaseMapping getOwningMapping(MetadataAccessor accessor, String ownerAttributeName) {
        MetadataDescriptor ownerDmd = accessor.getReferenceMetadataDescriptor();
        DatabaseMapping mapping = ownerDmd.getMappingForAttributeName(ownerAttributeName);
        if (mapping == null) {
            this.getValidator().throwNoMappedByAttributeFound(ownerDmd.getJavaClass(), ownerAttributeName, accessor.getJavaClass(), accessor.getAttributeName());
        }
        return mapping;
    }

    protected abstract MetadataValidator getValidator();

    protected abstract void handlePotentialDefaultPrimaryKeyUsage(DatabaseField var1, MetadataAccessor var2, String var3, String var4);

    protected abstract void handlePotentialDefaultPrimaryKeyUsage(DatabaseField var1, MetadataDescriptor var2);

    protected abstract boolean handlePotentialPartialManyToManyRelationshipMapping(ManyToManyMapping var1, boolean var2, List var3);

    protected abstract boolean handlePotentialPartialOneToOneRelationshipMapping(OneToOneMapping var1, List var2);

    protected OneToOneMapping initOneToOneMapping(MetadataAccessor accessor, boolean usesIndirection, Object[] cascadeTypes, boolean isOptional) {
        DatabaseMapping existingMapping = accessor.getMetadataDescriptor().m_descriptor.getMappingForAttributeName(accessor.getAttributeName());
        if (existingMapping != null) {
            return (OneToOneMapping)existingMapping;
        }
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setIsOptional(isOptional);
        mapping.setAttributeName(accessor.getAttributeName());
        mapping.setReferenceClassName(accessor.getReferenceClassName());
        usesIndirection = this.m_enableLazyForOneToOne ? usesIndirection : false;
        mapping.setUsesIndirection(usesIndirection);
        this.setAccessorMethods(accessor, mapping);
        this.processCascadeType(accessor, cascadeTypes, mapping);
        return mapping;
    }

    protected void populateCollectionMapping(CollectionMapping mapping, MetadataAccessor accessor, Class targetEntity, Object[] cascadeTypes, boolean usesIndirection) {
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setAttributeName(accessor.getAttributeName());
        this.setAccessorMethods(accessor, mapping);
        this.processCascadeType(accessor, cascadeTypes, mapping);
        accessor.setReferenceClass(targetEntity, "metadata_default_one_to_many_reference_class");
        mapping.setReferenceClassName(accessor.getReferenceClassName());
        this.processOrderBy(accessor, mapping);
        String mapKey = this.processMapKey(accessor, mapping);
        MetadataHelper.setIndirectionPolicy(usesIndirection, mapping, accessor.getRawClass(), mapKey);
    }

    protected abstract void populateCollectionMapping(CollectionMapping var1, Object var2, MetadataAccessor var3);

    protected abstract void preProcessGeneratedValue(Object var1, MetadataAccessor var2, DatabaseField var3, MetadataDescriptor var4);

    protected abstract void preProcessSequencing(MetadataAccessor var1);

    protected void processAccessor(MetadataAccessor accessor) {
        accessor.store();
        this.preProcessSequencing(accessor);
        if (accessor.isEmbedded()) {
            this.processEmbedded(accessor, false);
        } else if (accessor.isEmbeddedId()) {
            this.processEmbeddedId(accessor);
        } else if (accessor.isRelationship()) {
            this.m_relatedEntities.add(accessor.getMetadataDescriptor());
        } else {
            DatabaseField field = this.getDatabaseField(accessor);
            accessor.getMetadataDescriptor().handlePotentialDefaultTableUsage(field);
            if (accessor.isVersion()) {
                if (accessor.getMetadataDescriptor().usesOptimisticLocking()) {
                    this.getLogger().logWarningMessage(MetadataLogger.IGNORE_VERSION_LOCKING, accessor);
                } else {
                    field.setType(accessor.getRawClass());
                    accessor.getMetadataDescriptor().setOptimisticLockingPolicy(field);
                }
            } else {
                this.processId(accessor, field);
            }
            if (accessor.getMetadataDescriptor().hasMappingForAccessor(accessor)) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_MAPPING, accessor);
            } else {
                this.processDirectToFieldMapping(accessor, field);
            }
        }
    }

    protected abstract void processAccessors(MetadataDescriptor var1);

    protected abstract void processAssociationOverrides(MetadataAccessor var1, AggregateObjectMapping var2);

    protected void processAttributeOverride(String name, Object column, MetadataAccessor accessor, AggregateObjectMapping mapping) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        MetadataDescriptor aggregateDmd = accessor.getReferenceMetadataDescriptor();
        DatabaseMapping aggregateMapping = aggregateDmd.getMappingForAttributeName(name);
        if (aggregateMapping == null) {
            this.getValidator().throwInvalidEmbeddableAttribute(md.getJavaClass(), mapping.getAttributeName(), aggregateDmd.getJavaClass(), name);
        }
        DatabaseField field = md.hasAttributeOverrideFor(name) ? md.getAttributeOverrideFor(name) : this.processColumn(column, accessor.getAnnotatedElement(), accessor.getAttributeName(), aggregateDmd);
        mapping.addFieldNameTranslation(field.getQualifiedName(), aggregateMapping.getField().getName());
    }

    protected void processAttributeOverride(String attributeName, Object column, MetadataDescriptor md) {
        md.addAttributeOverride(attributeName, this.processColumn(column, md.getJavaClass(), attributeName, md));
    }

    protected abstract void processAttributeOverrides(MetadataAccessor var1, AggregateObjectMapping var2);

    protected abstract void processBasic(MetadataAccessor var1, DirectToFieldMapping var2);

    protected abstract void processCascadeType(MetadataAccessor var1, Object[] var2, ForeignReferenceMapping var3);

    protected abstract DatabaseField processColumn(MetadataAccessor var1);

    protected abstract DatabaseField processColumn(Object var1, Object var2, String var3, MetadataDescriptor var4);

    protected DatabaseField processColumn(String attributeName, String fieldName, String columnDefinition, String table, boolean isUnique, boolean isNullable, boolean isInsertable, boolean isUpdatable, int length, int precision, int scale, Object element, MetadataDescriptor metadataDescriptor) {
        DatabaseField dbField = new DatabaseField();
        dbField.setUnique(isUnique);
        dbField.setNullable(isNullable);
        dbField.setInsertable(isInsertable);
        dbField.setUpdatable(isUpdatable);
        dbField.setColumnDefinition(columnDefinition);
        dbField.setLength(length);
        dbField.setPrecision(precision);
        dbField.setScale(scale);
        String tableName = table.equals("") ? metadataDescriptor.getPrimaryTableName() : table;
        this.setColumnDetails(dbField, tableName, fieldName, attributeName, element);
        return dbField;
    }

    protected DatabaseField processColumnDefaults(MetadataAccessor accessor) {
        return this.processColumnDefaults(accessor.getAttributeName(), accessor.getMetadataDescriptor(), accessor.getAttributeName());
    }

    protected DatabaseField processColumnDefaults(String attributeName, MetadataDescriptor md, Object element) {
        DatabaseField dbField = new DatabaseField();
        this.setColumnDetails(dbField, md.getPrimaryTableName(), "", attributeName, element);
        return dbField;
    }

    protected void processDefaultTable(MetadataDescriptor md) {
        this.processTable("", "", "", null, md);
    }

    protected void processDirectToFieldMapping(MetadataAccessor accessor, DatabaseField field) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setField(field);
        mapping.setIsReadOnly(field.isReadOnly());
        mapping.setAttributeName(accessor.getAttributeName());
        this.setAccessorMethods(accessor, mapping);
        this.processBasic(accessor, mapping);
        if (accessor.isEnumerated()) {
            this.processEnumerated(accessor, mapping);
        } else if (accessor.isLob()) {
            this.processLob(accessor, mapping);
        } else if (accessor.isTemporal()) {
            this.processTemporal(accessor, mapping);
        } else if (accessor.isSerialized()) {
            this.processSerialized(accessor, mapping);
        }
        accessor.getMetadataDescriptor().addMapping(mapping);
    }

    protected void processDiscriminatorColumn(String name, String columnDefinition, int length, String discriminatorType, MetadataDescriptor metadataDescriptor) {
        DatabaseField field = new DatabaseField();
        field.setTableName(metadataDescriptor.getPrimaryTableName());
        metadataDescriptor.handlePotentialDefaultTableUsage(field);
        field.setLength(length);
        field.setColumnDefinition(columnDefinition);
        field.setType(MetadataHelper.getDiscriminatorType(discriminatorType));
        field.setName(this.getName(name, "DTYPE", "metadata_default_discriminator_column", metadataDescriptor.getJavaClass()));
        metadataDescriptor.setClassIndicatorField(field);
    }

    protected abstract void processDiscriminatorValue(MetadataDescriptor var1);

    protected void processDiscriminatorValue(String discriminatorValue, MetadataDescriptor metadataDescriptor) {
        Class entityClass = metadataDescriptor.getJavaClass();
        if (!Modifier.isAbstract(entityClass.getModifiers())) {
            String classIndicator = Helper.getShortClassName(entityClass.getName());
            if (discriminatorValue != null) {
                classIndicator = discriminatorValue;
            }
            metadataDescriptor.addClassIndicator(entityClass, classIndicator);
        }
    }

    protected MetadataDescriptor processEmbeddableClass(MetadataAccessor accessor, boolean isEmbeddedId) {
        Class referenceClass = accessor.getReferenceClass();
        MetadataDescriptor md = this.getMetadataDescriptor(referenceClass);
        MetadataDescriptor owningMd = accessor.getMetadataDescriptor();
        if (!md.isProcessed()) {
            md.setDescriptorIsEmbeddable();
            this.processAccessors(md);
        }
        if (isEmbeddedId && !md.ignoreIDAnnotations()) {
            for (DatabaseMapping mapping : md.getMappings()) {
                DatabaseField field = (DatabaseField)mapping.getField().clone();
                field.setTableName(owningMd.getPrimaryTableName());
                owningMd.handlePotentialDefaultTableUsage(field);
                owningMd.addPrimaryKeyField(field);
            }
        }
        return md;
    }

    protected void processEmbedded(MetadataAccessor accessor, boolean isEmbeddedId) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        MetadataDescriptor referenceDmd = this.processEmbeddableClass(accessor, isEmbeddedId);
        md.addAggregateDmd(referenceDmd);
        if (md.hasMappingForAccessor(accessor)) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_MAPPING, md, accessor);
        } else {
            AggregateObjectMapping mapping = new AggregateObjectMapping();
            mapping.setIsReadOnly(false);
            mapping.setIsNullAllowed(true);
            mapping.setReferenceClassName(accessor.getReferenceClassName());
            mapping.setAttributeName(accessor.getAttributeName());
            this.setAccessorMethods(accessor, mapping);
            this.processAttributeOverrides(accessor, mapping);
            this.processAssociationOverrides(accessor, mapping);
            md.addMapping(mapping);
        }
    }

    protected void processEmbeddedId(MetadataAccessor accessor) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        if (md.ignoreIDAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_EMBEDDED_ID, accessor);
        } else {
            if (md.hasEmbeddedIdAttribute()) {
                this.getValidator().throwMultipleEmbeddedIdsFound(md.getJavaClass(), accessor.getAttributeName(), md.getEmbeddedIdAttributeName());
            }
            if (md.hasPrimaryKeyFields()) {
                this.getValidator().throwEmbeddedIdAndIdFound(md.getJavaClass(), accessor.getAttributeName(), md.getIdAttributeName());
            }
            md.setPKClass(accessor.getReferenceClass());
            md.setEmbeddedIdAttributeName(accessor.getAttributeName());
        }
        this.processEmbedded(accessor, true);
    }

    protected void processEntity(String alias, MetadataDescriptor descriptor) {
        if (descriptor.getAlias().equals("")) {
            ClassDescriptor d;
            if (alias.equals("")) {
                alias = Helper.getShortClassName(descriptor.getJavaClassName());
                this.getLogger().logConfigMessage("metadata_default_alias", descriptor, (Object)alias);
            }
            if ((d = this.m_session.getProject().getDescriptorForAlias(alias)) != null) {
                this.getValidator().throwNonUniqueEntityName(d.getJavaClassName(), descriptor.getJavaClassName(), alias);
            }
            descriptor.setAlias(alias);
            this.m_session.getProject().addAlias(alias, descriptor.getDescriptor());
        }
        if (descriptor.isInheritanceSubclass(this.m_metadataDescriptors)) {
            Class rootClass = descriptor.getInheritanceRootClass();
            MetadataDescriptor rootDescriptor = this.getMetadataDescriptor(rootClass);
            rootDescriptor.setIsInheritanceRoot(true);
            if (!rootDescriptor.isProcessed()) {
                this.processEntityClass(rootClass);
            }
            if (!rootDescriptor.hasInheritance()) {
                this.processInheritanceRoot(rootDescriptor);
            }
            descriptor.setInheritanceRootDmd(rootDescriptor);
            this.m_relatedEntities.add(descriptor);
        }
    }

    protected abstract void processEntityClass(Class var1);

    protected void processEnumerated(MetadataAccessor accessor, boolean isOrdinal, DirectToFieldMapping mapping) {
        Class referenceClass = accessor.getReferenceClass();
        if (accessor.hasEnumerated() && !MetadataHelper.isValidEnumeratedType(referenceClass)) {
            this.getValidator().throwInvalidTypeForEnumeratedAttribute(accessor.getJavaClass(), mapping.getAttributeName(), referenceClass);
        }
        mapping.setConverter(new EnumTypeConverter(mapping, accessor.getReferenceClassName(), isOrdinal));
    }

    protected abstract void processEnumerated(MetadataAccessor var1, DirectToFieldMapping var2);

    protected abstract void processId(MetadataAccessor var1, DatabaseField var2);

    protected void processId(MetadataAccessor accessor, DatabaseField field, Object generatedValue) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        if (md.ignoreIDAnnotations()) {
            MetadataLogger metadataLogger = this.getLogger();
            this.getLogger();
            metadataLogger.logWarningMessage(MetadataLogger.IGNORE_PRIMARY_KEY, accessor);
        } else {
            String attributeName = accessor.getAttributeName();
            if (md.hasEmbeddedIdAttribute()) {
                this.getValidator().throwEmbeddedIdAndIdFound(md.getJavaClass(), md.getEmbeddedIdAttributeName(), attributeName);
            }
            md.validatePKClassId(attributeName, accessor.getReferenceClass());
            md.addIdAttributeName(attributeName);
            md.addPrimaryKeyField(field);
            this.preProcessGeneratedValue(generatedValue, accessor, field, md);
        }
    }

    protected void processIdClass(Class pkClass, MetadataDescriptor metadataDescriptor) {
        block6: {
            if (pkClass == null) break block6;
            metadataDescriptor.setPKClass(pkClass);
            if (metadataDescriptor.ignoreIDAnnotations()) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_ID_CLASS, metadataDescriptor, pkClass);
            } else if (metadataDescriptor.usesPropertyAccess()) {
                Method[] methods = MetadataHelper.getDeclaredMethods(pkClass);
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    String methodName = method.getName();
                    if (!MetadataHelper.isValidPersistenceMethodName(methodName)) continue;
                    metadataDescriptor.addPKClassId(MetadataHelper.getAttributeNameFromMethodName(methodName), MetadataHelper.getReturnType(method));
                }
            } else {
                Field[] fields = MetadataHelper.getFields(pkClass);
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    metadataDescriptor.addPKClassId(field.getName(), MetadataHelper.getType(field));
                }
            }
        }
    }

    protected abstract void processInheritanceRoot(MetadataDescriptor var1);

    protected void processInheritanceSubclass(MetadataDescriptor md) {
        if (md.ignoreInheritanceAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_INHERITANCE, md);
        } else {
            if (md.hasInheritanceTag(md.getJavaClass())) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_INHERITANCE, md);
            }
            md.setParentClass();
            MetadataDescriptor rootDmd = md.getInheritanceRootDmd();
            if (rootDmd.usesSingleTableInheritanceStrategy()) {
                md.setSingleTableInheritanceStrategy();
            } else {
                List joinColumns = this.processPrimaryKeyJoinColumns(rootDmd.getPrimaryTableName(), md.getPrimaryTableName(), md.getJavaClass(), md);
                for (MetadataJoinColumn mjc : joinColumns) {
                    this.getLogger();
                    this.getLogger();
                    this.addMultipleTableKeyField(mjc, "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column", md);
                }
            }
            this.processDiscriminatorValue(md);
        }
    }

    protected MetadataJoinColumn processJoinColumn(MetadataAccessor accessor, String targetTable, MetadataDescriptor sourceMd, String fkFieldName, String pkFieldName, String columnDefinition, String table, boolean isUnique, boolean isNullable, boolean isInsertable, boolean isUpdatable) {
        if (sourceMd.hasCompositePrimaryKey() && (pkFieldName.equals("") || fkFieldName.equals(""))) {
            this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
        }
        MetadataJoinColumn mjc = new MetadataJoinColumn();
        DatabaseField pkField = new DatabaseField();
        pkField.setName(pkFieldName);
        pkField.setTableName(sourceMd.getPrimaryTableName());
        mjc.setPrimaryKeyField(pkField);
        DatabaseField fkField = new DatabaseField();
        fkField.setName(fkFieldName);
        mjc.setForeignKeyField(fkField);
        fkField.setUnique(isUnique);
        fkField.setNullable(isNullable);
        fkField.setInsertable(isInsertable);
        fkField.setUpdatable(isUpdatable);
        fkField.setColumnDefinition(columnDefinition);
        if (table.equals("")) {
            if (targetTable != null) {
                fkField.setTableName(targetTable);
            }
        } else {
            fkField.setTableName(table);
        }
        sourceMd.handlePotentialDefaultTableUsage(pkField);
        accessor.getMetadataDescriptor().handlePotentialDefaultTableUsage(fkField);
        return mjc;
    }

    protected abstract List processJoinColumns(MetadataAccessor var1);

    protected abstract void processJoinTable(MetadataAccessor var1, ManyToManyMapping var2);

    protected void processJoinTable(MetadataAccessor accessor, ManyToManyMapping mapping, List sourceKeys, List targetKeys) {
        Class sourceClass = accessor.getJavaClass();
        String defaultSourceFieldName = accessor.getReferenceMetadataDescriptor().hasManyToManyAccessorFor(sourceClass) ? accessor.getReferenceMetadataDescriptor().getManyToManyAccessor(sourceClass).getAttributeName() : Helper.getShortClassName(sourceClass.getName());
        String defaultTargetFieldName = accessor.getAttributeName();
        this.addManyToManyRelationKeyFields(sourceKeys, mapping, accessor, defaultSourceFieldName, accessor.getMetadataDescriptor(), true);
        this.addManyToManyRelationKeyFields(targetKeys, mapping, accessor, defaultTargetFieldName, accessor.getReferenceMetadataDescriptor(), false);
    }

    protected void processLob(MetadataAccessor accessor, DirectToFieldMapping mapping) {
        Class referenceClass = accessor.getReferenceClass();
        mapping.setConverter(new TypeConversionConverter(mapping));
        if (MetadataHelper.isValidClobType(referenceClass)) {
            mapping.setFieldClassification(Clob.class);
        } else if (MetadataHelper.isValidBlobType(referenceClass)) {
            mapping.setFieldClassification(Blob.class);
        } else {
            this.getValidator().throwInvalidTypeForLOBAttribute(accessor.getJavaClass(), mapping.getAttributeName(), referenceClass);
        }
    }

    protected abstract void processManyToMany(MetadataAccessor var1);

    protected void processManyToMany(MetadataAccessor accessor, Class targetEntity, Object[] cascadeTypes, boolean usesIndirection, String mappedBy) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        ManyToManyMapping mapping = new ManyToManyMapping();
        mapping.setIsPrivateOwned(false);
        mapping.setAttributeName(accessor.getAttributeName());
        this.setAccessorMethods(accessor, mapping);
        accessor.setReferenceClass(targetEntity, "metadata_default_many_to_many_reference_class");
        mapping.setReferenceClassName(accessor.getReferenceClassName());
        this.processOrderBy(accessor, mapping);
        String mapKey = this.processMapKey(accessor, mapping);
        MetadataHelper.setIndirectionPolicy(usesIndirection, mapping, accessor.getRawClass(), mapKey);
        this.processCascadeType(accessor, cascadeTypes, mapping);
        if (mappedBy.equals("")) {
            this.processJoinTable(accessor, mapping);
        } else {
            mapping.setIsReadOnly(true);
            ManyToManyMapping ownerMapping = (ManyToManyMapping)this.getOwningMapping(accessor, mappedBy);
            if (ownerMapping == null) {
                mapping.setRequiresCompletion(true);
                mapping.setMappedBy(mappedBy);
            } else {
                if (ownerMapping.requiresCompletion()) {
                    MetadataAccessor owningAccessor = accessor.getReferenceMetadataDescriptor().getAccessorFor(ownerMapping.getAttributeName());
                    this.processJoinTable(owningAccessor, ownerMapping);
                }
                mapping.setRelationTableName(ownerMapping.getRelationTableName());
                mapping.setSourceKeyFields(ownerMapping.getTargetKeyFields());
                mapping.setSourceRelationKeyFields(ownerMapping.getTargetRelationKeyFields());
                mapping.setTargetKeyFields(ownerMapping.getSourceKeyFields());
                mapping.setTargetRelationKeyFields(ownerMapping.getSourceRelationKeyFields());
            }
        }
        md.addMapping(mapping);
    }

    protected abstract void processManyToOne(MetadataAccessor var1);

    protected void processManyToOne(MetadataAccessor accessor, Class targetEntity, Object[] cascadeTypes, boolean usesIndirection, boolean isOptional) {
        accessor.setReferenceClass(targetEntity, "metadata_default_many_to_one_reference_class");
        OneToOneMapping mapping = this.initOneToOneMapping(accessor, usesIndirection, cascadeTypes, isOptional);
        this.processOwningMappingKeys(mapping, accessor);
        accessor.getMetadataDescriptor().addMapping(mapping);
    }

    protected abstract String processMapKey(MetadataAccessor var1, CollectionMapping var2);

    protected String processMapKey(MetadataAccessor accessor, CollectionMapping mapping, String name) {
        MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
        String mapKeyName = null;
        if (!name.equals("") || !referenceDmd.hasCompositePrimaryKey()) {
            String string = referenceDmd.getIdAttributeName();
            this.getLogger();
            String fieldOrPropertyName = this.getName(name, string, "metadata_default_map_key_attribute_name", (Object)accessor);
            MetadataAccessor referenceAccessor = referenceDmd.getAccessorFor(fieldOrPropertyName);
            if (referenceAccessor == null) {
                this.getValidator().throwCouldNotFindMapKey(fieldOrPropertyName, referenceDmd.getJavaClass(), mapping);
            }
            mapKeyName = referenceAccessor.getName();
        }
        return mapKeyName;
    }

    protected abstract void processOneToMany(MetadataAccessor var1);

    protected void processOneToMany(MetadataAccessor accessor, Object element, String mappedBy) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        if (element == null || mappedBy.equals("")) {
            if (accessor.hasJoinColumn() || accessor.hasJoinColumns()) {
                this.getValidator().throwUniDirectionalOneToManyHasJoinColumnSpecified(md.getJavaClass(), accessor.getAttributeName());
            }
            ManyToManyMapping mapping = new ManyToManyMapping();
            this.populateCollectionMapping(mapping, element, accessor);
            this.processJoinTable(accessor, mapping);
            md.addMapping(mapping);
        } else {
            OneToManyMapping mapping = new OneToManyMapping();
            this.populateCollectionMapping(mapping, element, accessor);
            OneToOneMapping ownerMapping = (OneToOneMapping)this.getOwningMapping(accessor, mappedBy);
            if (ownerMapping == null) {
                mapping.setRequiresCompletion(true);
                mapping.setMappedBy(mappedBy);
            } else {
                if (ownerMapping.requiresCompletion()) {
                    MetadataAccessor owningAccessor = accessor.getReferenceMetadataDescriptor().getAccessorFor(ownerMapping.getAttributeName());
                    this.processOwningMappingKeys(ownerMapping, owningAccessor);
                }
                Map keys = ownerMapping.getSourceToTargetKeyFields();
                for (DatabaseField fkField : keys.keySet()) {
                    mapping.addTargetForeignKeyField(fkField, (DatabaseField)keys.get(fkField));
                }
            }
            md.addMapping(mapping);
        }
    }

    protected abstract void processOneToOne(MetadataAccessor var1);

    protected void processOneToOne(MetadataAccessor accessor, Class targetEntity, Object[] cascadeTypes, boolean usesIndirection, boolean optional, String mappedBy) {
        accessor.setReferenceClass(targetEntity, "metadata_default_one_to_one_reference_class");
        OneToOneMapping mapping = this.initOneToOneMapping(accessor, usesIndirection, cascadeTypes, optional);
        if (mappedBy.equals("")) {
            this.processOwningMappingKeys(mapping, accessor);
        } else {
            OneToOneMapping ownerMapping = (OneToOneMapping)this.getOwningMapping(accessor, mappedBy);
            if (ownerMapping == null) {
                mapping.setRequiresCompletion(true);
                mapping.setMappedBy(mappedBy);
            } else {
                if (ownerMapping.requiresCompletion()) {
                    MetadataAccessor owningAccessor = accessor.getReferenceMetadataDescriptor().getAccessorFor(ownerMapping.getAttributeName());
                    this.processOwningMappingKeys(ownerMapping, owningAccessor);
                }
                mapping.setSourceToTargetKeyFields(ownerMapping.getTargetToSourceKeyFields());
                mapping.setTargetToSourceKeyFields(ownerMapping.getSourceToTargetKeyFields());
            }
        }
        accessor.getMetadataDescriptor().addMapping(mapping);
    }

    protected abstract void processOrderBy(MetadataAccessor var1, CollectionMapping var2);

    protected void processOrderBy(MetadataAccessor accessor, CollectionMapping mapping, String orderByValue) {
        MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
        if (orderByValue.equals("")) {
            List orderByAttributes = referenceDmd.getIdOrderByAttributeNames();
            if (referenceDmd.hasEmbeddedIdAttribute()) {
                String embeddedIdAttributeName = referenceDmd.getEmbeddedIdAttributeName();
                for (String orderByAttribute : orderByAttributes) {
                    mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                }
            } else {
                for (String orderByAttribute : orderByAttributes) {
                    mapping.addOrderBy(orderByAttribute, false);
                }
            }
        } else {
            StringTokenizer commaTokenizer = new StringTokenizer(orderByValue, ",");
            while (commaTokenizer.hasMoreTokens()) {
                String ordering;
                StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                String propertyOrFieldName = spaceTokenizer.nextToken();
                MetadataAccessor referenceAccessor = referenceDmd.getAccessorFor(propertyOrFieldName);
                if (referenceAccessor == null) {
                    this.getValidator().throwInvalidOrderByValue(accessor.getJavaClass(), propertyOrFieldName, referenceDmd.getJavaClass(), accessor.getName());
                }
                String attributeName = referenceAccessor.getAttributeName();
                String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : "ASC";
                if (referenceAccessor.isEmbedded()) {
                    for (String orderByAttributeName : referenceDmd.getOrderByAttributeNames()) {
                        mapping.addAggregateOrderBy(attributeName, orderByAttributeName, ordering.equals("DESC"));
                    }
                    continue;
                }
                mapping.addOrderBy(attributeName, ordering.equals("DESC"));
            }
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping, MetadataAccessor accessor) {
        List joinColumns;
        String defaultFKFieldName;
        String defaultPKFieldName;
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
        if (accessor.isOneToOnePrimaryKeyRelationship()) {
            defaultPKFieldName = referenceDmd.getPrimaryKeyFieldName();
            defaultFKFieldName = md.getPrimaryKeyFieldName();
            joinColumns = this.processPrimaryKeyJoinColumns(referenceDmd.getPrimaryTableName(), md.getPrimaryTableName(), accessor.getAnnotatedElement(), md);
        } else {
            defaultPKFieldName = referenceDmd.getPrimaryKeyFieldName();
            defaultFKFieldName = accessor.getUpperCaseAttributeName() + "_" + defaultPKFieldName;
            joinColumns = this.processJoinColumns(accessor);
        }
        if (!this.handlePotentialPartialOneToOneRelationshipMapping(mapping, joinColumns)) {
            for (MetadataJoinColumn mjc : joinColumns) {
                DatabaseField pkField = mjc.getPrimaryKeyField();
                if (mapping.requiresCompletion()) {
                    pkField.setName(mapping.getXMLPKNameAttribute());
                }
                pkField.setName(this.getName(pkField, defaultPKFieldName, "metadata_default_pk_column", accessor));
                DatabaseField fkField = mjc.getForeignKeyField();
                if (mapping.requiresCompletion()) {
                    fkField.setName(mapping.getXMLFKNameAttribute());
                }
                fkField.setName(this.getName(fkField, defaultFKFieldName, "metadata_default_fk_column", accessor));
                mapping.addForeignKeyField(fkField, pkField);
                if (!accessor.isOneToOnePrimaryKeyRelationship() && !fkField.isReadOnly()) continue;
                mapping.setIsReadOnly(true);
            }
        }
    }

    protected MetadataJoinColumn processPrimaryKeyJoinColumn(String name, String referencedColumnName, String columnDefinition, String sourceTableName, String targetTableName, MetadataDescriptor md) {
        MetadataJoinColumn mjc = new MetadataJoinColumn();
        String fkFieldName = name;
        String pkFieldName = referencedColumnName;
        if (md.hasCompositePrimaryKey() && (pkFieldName.equals("") || fkFieldName.equals(""))) {
            this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(md.getJavaClass());
        }
        DatabaseField pkField = new DatabaseField();
        pkField.setName(pkFieldName);
        pkField.setTableName(sourceTableName);
        mjc.setPrimaryKeyField(pkField);
        DatabaseField fkField = new DatabaseField();
        fkField.setName(name);
        fkField.setTableName(targetTableName);
        mjc.setForeignKeyField(fkField);
        fkField.setColumnDefinition(columnDefinition);
        md.handlePotentialDefaultTableUsage(fkField);
        return mjc;
    }

    protected abstract List processPrimaryKeyJoinColumns(Object[] var1, String var2, String var3, MetadataDescriptor var4);

    protected abstract List processPrimaryKeyJoinColumns(String var1, String var2, Object var3, MetadataDescriptor var4);

    protected void processRelationshipAccessor(MetadataAccessor accessor) {
        if (accessor.needsProcessing()) {
            if (accessor.getMetadataDescriptor().hasMappingForAccessor(accessor)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logWarningMessage(MetadataLogger.IGNORE_MAPPING, accessor);
            } else {
                if (accessor.hasColumn()) {
                    this.getValidator().throwRelationshipHasColumnSpecified(accessor.getJavaClass(), accessor.getAttributeName());
                }
                if (accessor.isManyToOne()) {
                    this.processManyToOne(accessor);
                } else if (accessor.isManyToMany()) {
                    this.processManyToMany(accessor);
                } else if (accessor.isOneToMany()) {
                    this.processOneToMany(accessor);
                } else if (accessor.isOneToOne()) {
                    this.processOneToOne(accessor);
                }
            }
            accessor.setNeedsProcessing(false);
        }
    }

    protected void processSecondaryTable(String name, String catalog, String schema, Object[] uniqueConstraints, Object[] pkJoinCols, MetadataDescriptor md) {
        DatabaseTable table = this.buildTable(name, catalog, schema, md);
        this.processUniqueConstraints(uniqueConstraints, table);
        md.addTable(table);
        String primaryTableName = md.getPrimaryTableName();
        String secondaryTableName = table.getQualifiedName();
        List metadataJoinColumns = this.processPrimaryKeyJoinColumns(pkJoinCols, primaryTableName, secondaryTableName, md);
        if (md.hasCompositePrimaryKey()) {
            if (metadataJoinColumns.size() != md.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(md.getJavaClass());
            }
        } else {
            this.addJoinColumnDefault(metadataJoinColumns, primaryTableName, secondaryTableName, md);
        }
        for (MetadataJoinColumn mjc : metadataJoinColumns) {
            this.addMultipleTableKeyField(mjc, "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column", md);
        }
    }

    protected void processSerialized(MetadataAccessor accessor, DirectToFieldMapping mapping) {
        Class referenceClass = accessor.getReferenceClass();
        if (Helper.classImplementsInterface(referenceClass, Serializable.class)) {
            mapping.setConverter(new SerializedObjectConverter(mapping));
        } else {
            this.getValidator().throwInvalidTypeForSerializedAttribute(accessor.getJavaClass(), mapping.getAttributeName(), referenceClass);
        }
    }

    protected void processTable(String name, String catalog, String schema, Object[] uniqueConstraints, MetadataDescriptor md) {
        DatabaseTable dbTable = this.buildTable(name, catalog, schema, md);
        if (uniqueConstraints != null) {
            this.processUniqueConstraints(uniqueConstraints, dbTable);
        }
        md.setPrimaryTable(dbTable);
    }

    protected abstract void processTemporal(MetadataAccessor var1, DirectToFieldMapping var2);

    protected void processTemporal(MetadataAccessor accessor, String temporalType, DirectToFieldMapping mapping) {
        Class entityClass = accessor.getJavaClass();
        Class referenceClass = accessor.getReferenceClass();
        String attributeName = accessor.getAttributeName();
        if (MetadataHelper.isValidTemporalType(referenceClass)) {
            mapping.setConverter(new TypeConversionConverter(mapping));
            mapping.setFieldClassification(MetadataHelper.getFieldClassification(temporalType));
        } else {
            this.getValidator().throwInvalidTypeForTemporalAttribute(entityClass, attributeName, referenceClass);
        }
    }

    protected abstract void processUniqueConstraints(Object[] var1, DatabaseTable var2);

    protected void setAccessorMethods(MetadataAccessor accessor, DatabaseMapping mapping) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        if (md.usesPropertyAccess()) {
            String getMethodName = accessor.getName();
            String setMethodName = md.getSetMethodName(getMethodName);
            mapping.setGetMethodName(getMethodName);
            mapping.setSetMethodName(setMethodName);
        }
    }

    protected void setCascadeType(String type, ForeignReferenceMapping mapping) {
        if (type.equals("cascade-all") || type.equals("ALL")) {
            mapping.setCascadeAll(true);
        } else if (type.equals("cascade-merge") || type.equals("MERGE")) {
            mapping.setCascadeMerge(true);
        } else if (type.equals("cascade-persist") || type.equals("PERSIST")) {
            mapping.setCascadePersist(true);
        } else if (type.equals("cascade-refresh") || type.equals("REFRESH")) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals("cascade-remove") || type.equals("REMOVE")) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    protected void setColumnDetails(DatabaseField dbField, String tableName, String fieldName, String attributeName, Object element) {
        if (tableName != null) {
            dbField.setTableName(tableName);
        }
        dbField.setName(this.getName(fieldName, attributeName.toUpperCase(), "metadata_default_column", element));
    }

    public void updateClassesInMetadata() {
        if (this.m_metadataDescriptors == null) {
            return;
        }
        HashMap<Class, MetadataDescriptor> newMetadataDescriptors = new HashMap<Class, MetadataDescriptor>(this.m_metadataDescriptors.size());
        for (MetadataDescriptor md : this.m_metadataDescriptors.values()) {
            Class newClass = md.getDescriptor().getJavaClass();
            md.setJavaClass(newClass);
            md.setInheritanceRootClass(null);
            newMetadataDescriptors.put(newClass, md);
        }
        this.m_metadataDescriptors = newMetadataDescriptors;
    }
}

