/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ConstantExpression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SubqueryNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class ExistsNode
extends Node {
    private boolean notIndicated = false;

    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            SubqueryNode subqueryNode = (SubqueryNode)this.getLeft();
            subqueryNode.validate(context);
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.getBooleanType());
        }
    }

    public Expression generateExpression(GenerationContext context) {
        SubqueryNode subqueryNode = (SubqueryNode)this.getLeft();
        ReportQuery reportQuery = subqueryNode.getReportQuery(context);
        reportQuery.clearItems();
        ConstantExpression one = new ConstantExpression(new Integer(1), new ExpressionBuilder());
        reportQuery.addItem("one", one);
        reportQuery.dontUseDistinct();
        Expression expr = context.getBaseExpression();
        return this.notIndicated() ? expr.notExists(reportQuery) : expr.exists(reportQuery);
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }
}

