/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;

public abstract class InterfaceContainerPolicy
extends ContainerPolicy {
    protected Class containerClass;
    protected String containerClassName;
    protected transient Method cloneMethod;

    public InterfaceContainerPolicy() {
    }

    public InterfaceContainerPolicy(Class containerClass) {
        this.setContainerClass(containerClass);
    }

    public InterfaceContainerPolicy(String containerClassName) {
        this.setContainerClassName(containerClassName);
    }

    public Object cloneFor(Object container) {
        if (container == null) {
            return null;
        }
        try {
            return this.invokeCloneMethodOn(this.getCloneMethod(), container);
        }
        catch (IllegalArgumentException ex) {
            return this.invokeCloneMethodOn(this.getCloneMethod(container.getClass()), container);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.containerClassName == null) {
            return;
        }
        Class containerClass = null;
        try {
            containerClass = PrivilegedAccessController.getClassForName(this.containerClassName, true, classLoader);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, exc);
        }
        this.setContainerClass(containerClass);
    }

    public Method getCloneMethod() {
        if (this.cloneMethod == null) {
            this.setCloneMethod(this.getCloneMethod(this.getContainerClass()));
        }
        return this.cloneMethod;
    }

    protected Method getCloneMethod(Class javaClass) {
        try {
            return PrivilegedAccessController.getMethod(javaClass, "clone", null, false);
        }
        catch (NoSuchMethodException ex) {
            throw QueryException.methodDoesNotExistInContainerClass("clone", javaClass);
        }
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    public abstract Class getInterfaceType();

    public boolean hasNext(Object iterator) {
        return ((Iterator)iterator).hasNext();
    }

    protected Object invokeCloneMethodOn(Method method, Object container) {
        try {
            return PrivilegedAccessController.invokeMethod(method, container, null);
        }
        catch (IllegalAccessException ex1) {
            throw QueryException.cannotAccessMethodOnObject(method, container);
        }
        catch (InvocationTargetException ex2) {
            throw QueryException.methodInvocationFailed(method, container, ex2);
        }
    }

    public boolean isValidContainerType(Class containerType) {
        return Helper.classImplementsInterface(containerType, this.getInterfaceType());
    }

    protected Object next(Object iterator) {
        return ((Iterator)iterator).next();
    }

    public void setCloneMethod(Method cloneMethod) {
        this.cloneMethod = cloneMethod;
    }

    public void setContainerClass(Class containerClass) {
        this.containerClass = containerClass;
        this.initializeConstructor();
    }

    public void setContainerClassName(String containerClassName) {
        this.containerClassName = containerClassName;
    }

    protected Object toStringInfo() {
        return this.getContainerClass();
    }
}

