/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.database.oracle;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.ExpressionOperator;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.essentials.internal.expressions.FunctionExpression;
import oracle.toplink.essentials.internal.expressions.RelationExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.platform.database.DatabasePlatform;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.queryframework.ValueReadQuery;

public class OraclePlatform
extends DatabasePlatform {
    public boolean allowsSizeInProcedureArguments() {
        return false;
    }

    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write(39);
            Helper.writeHexString(bytes, writer);
            writer.write(39);
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printDate(date));
            writer.write("','yyyy-mm-dd')");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTime(time));
            writer.write("','hh24:mi:ss')");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public ExpressionOperator atan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2");
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("NUMBER(1) default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("NUMBER", 10));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMBER", 19, 4));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMBER", 19, 4));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("NUMBER", 5));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("NUMBER", 3));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 38));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR2", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("LONG RAW", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("LONG", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("LONG RAW", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("LONG", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("LONG RAW", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("LONG", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("DATE", false));
        return fieldTypeMapping;
    }

    public DatabaseCall buildCallWithReturning(SQLCall sqlCall, Vector returnFields) {
        SQLCall call = new SQLCall();
        call.setParameters(sqlCall.getParameters());
        call.setParameterTypes(sqlCall.getParameterTypes());
        CharArrayWriter writer = new CharArrayWriter(200);
        try {
            DatabaseField field;
            int i;
            writer.write("BEGIN ");
            writer.write(sqlCall.getSQLString());
            writer.write(" RETURNING ");
            for (i = 0; i < returnFields.size(); ++i) {
                field = (DatabaseField)returnFields.elementAt(i);
                writer.write(field.getName());
                if (i + 1 >= returnFields.size()) continue;
                writer.write(", ");
            }
            writer.write(" INTO ");
            for (i = 0; i < returnFields.size(); ++i) {
                field = (DatabaseField)returnFields.elementAt(i);
                call.appendOut(writer, field);
                if (i + 1 >= returnFields.size()) continue;
                writer.write(", ");
            }
            writer.write("; END;");
            call.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    public boolean canBuildCallWithReturning() {
        return true;
    }

    public String getAssignmentString() {
        return ":= ";
    }

    public String getBatchBeginString() {
        return "BEGIN ";
    }

    public String getBatchEndString() {
        return "END;";
    }

    public int getMaxFieldNameSize() {
        return 30;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        String query = "SELECT * FROM ALL_TABLES WHERE OWNER NOT IN ('SYS', 'SYSTEM')";
        if (table != null) {
            query = table.indexOf(37) != -1 ? query + " AND TABLE_NAME LIKE " + table : query + " AND TABLE_NAME = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? query + " AND OWNER LIKE " + creator : query + " AND OWNER = " + creator;
        }
        return session.executeSelectingCall(new SQLCall(query));
    }

    public String getProcedureArgumentSetter() {
        return "=>";
    }

    public String getProcedureCallHeader() {
        return "BEGIN ";
    }

    public String getProcedureCallTail() {
        return "; END;";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getStoredProcedureParameterPrefix() {
        return "P_";
    }

    public String getStoredProcedureTerminationToken() {
        return "";
    }

    public ValueReadQuery getSystemChangeNumberQuery() {
        ValueReadQuery sCNQuery = new ValueReadQuery();
        sCNQuery.setSQLString("SELECT DBMS_FLASHBACK.GET_SYSTEM_CHANGE_NUMBER FROM DUAL");
        return sCNQuery;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
        }
        return this.timestampQuery;
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type) throws SQLException {
        if (type == 93 || type == 91) {
            return resultSet.getTimestamp(columnNumber);
        }
        return resultSet.getObject(columnNumber);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(this.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.todayOperator());
        this.addOperator(this.currentDateOperator());
        this.addOperator(ExpressionOperator.truncateDate());
        this.addOperator(ExpressionOperator.newTime());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(this.atan2Operator());
        this.addOperator(ExpressionOperator.oracleDateName());
        this.addOperator(this.operatorLocate());
        this.addOperator(this.operatorLocate2());
    }

    public boolean isOracle() {
        return true;
    }

    protected ExpressionOperator logOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(66);
        Vector<String> v = new Vector<String>(2);
        v.addElement("LOG(");
        v.addElement(", 10)");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(FunctionExpression.class);
        return result;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MAX_VALUE));
        values.put(Long.class, new Long(Long.MAX_VALUE));
        values.put(Double.class, new Double(9.9999E125));
        values.put(Short.class, new Short(Short.MAX_VALUE));
        values.put(Byte.class, new Byte(127));
        values.put(Float.class, new Float(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MIN_VALUE));
        values.put(Long.class, new Long(Long.MIN_VALUE));
        values.put(Double.class, new Double(-1.0E-129));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(Float.class, new Float(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence(String seqName, Integer size) {
        return new ValueReadQuery("SELECT " + this.getQualifiedSequenceName(seqName) + ".NEXTVAL FROM DUAL");
    }

    protected String getQualifiedSequenceName(String seqName) {
        if (this.getTableQualifier().equals("")) {
            return seqName;
        }
        return this.getTableQualifier() + "." + seqName;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(6);
        Vector<String> v = new Vector<String>(2);
        v.addElement(" (+) = ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected ExpressionOperator operatorLocate() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(112);
        Vector<String> v = new Vector<String>(3);
        v.addElement("INSTR(");
        v.addElement(", ");
        v.addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected ExpressionOperator operatorLocate2() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(113);
        Vector<String> v = new Vector<String>(4);
        v.addElement("INSTR(");
        v.addElement(", ");
        v.addElement(", ");
        v.addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public String serverTimestampString() {
        return "SYSDATE";
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return true;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return true;
    }

    public boolean supportsSelectForUpdateNoWait() {
        return true;
    }

    protected ExpressionOperator todayOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(54, "SYSDATE");
    }

    protected ExpressionOperator currentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "TO_DATE(CURRENT_DATE)");
    }
}

