/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.server;

import java.sql.Connection;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.Platform;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLog;
import oracle.toplink.essentials.platform.server.ServerLog;
import oracle.toplink.essentials.platform.server.ServerPlatform;
import oracle.toplink.essentials.sessions.ExternalTransactionController;

public abstract class ServerPlatformBase
implements ServerPlatform {
    private boolean isRuntimeServicesEnabled = true;
    private boolean isJTAEnabled = true;
    private boolean isCMP;
    private DatabaseSessionImpl databaseSession;

    public ServerPlatformBase(DatabaseSessionImpl newDatabaseSession) {
        this.databaseSession = newDatabaseSession;
        this.setIsCMP(false);
    }

    public DatabaseSessionImpl getDatabaseSession() {
        return this.databaseSession;
    }

    public String getServerNameAndVersion() {
        return ToStringLocalization.buildMessage("unknown");
    }

    public String getModuleName() {
        return "unknown";
    }

    public abstract Class getExternalTransactionControllerClass();

    public void initializeExternalTransactionController() {
        this.ensureNotLoggedIn();
        if (!this.isJTAEnabled() && !this.isCMP()) {
            return;
        }
        if (!this.isJTAEnabled() && this.isCMP()) {
            AbstractSessionLog.getLog().warning("jta_cannot_be_disabled_in_cmp");
        }
        try {
            if (this.getDatabaseSession().getExternalTransactionController() != null) {
                this.externalTransactionControllerNotNullWarning();
                return;
            }
            this.getDatabaseSession().setExternalTransactionController((ExternalTransactionController)PrivilegedAccessController.newInstanceFromClass(this.getExternalTransactionControllerClass()));
        }
        catch (InstantiationException instantiationException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
    }

    protected void externalTransactionControllerNotNullWarning() {
        this.getDatabaseSession().warning("External_transaction_controller_not_defined_by_server_platform", "ejb");
    }

    public boolean isJTAEnabled() {
        return this.isJTAEnabled;
    }

    public void disableJTA() {
        this.ensureNotLoggedIn();
        this.isJTAEnabled = false;
    }

    public boolean isRuntimeServicesEnabled() {
        return this.isRuntimeServicesEnabled;
    }

    public void disableRuntimeServices() {
        this.ensureNotLoggedIn();
        this.isRuntimeServicesEnabled = false;
    }

    public void registerMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificRegisterMBean();
    }

    public void serverSpecificRegisterMBean() {
    }

    public void unregisterMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificUnregisterMBean();
    }

    public Connection unwrapOracleConnection(Platform platform, Connection connection) {
        return connection;
    }

    public void serverSpecificUnregisterMBean() {
    }

    public void launchContainerRunnable(Runnable runnable) {
        new Thread(runnable).start();
    }

    protected void ensureNotLoggedIn() {
        if (this.getDatabaseSession() == null) {
            return;
        }
        if (this.getDatabaseSession().isConnected()) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(this.getClass().getName());
        }
    }

    public SessionLog getServerLog() {
        return new ServerLog();
    }

    public boolean isCMP() {
        return this.isCMP;
    }

    public void setIsCMP(boolean isThisCMP) {
        this.isCMP = isThisCMP;
    }
}

