/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.essentials.queryframework.ModifyQuery;
import oracle.toplink.essentials.sessions.IdentityMapAccessor;

public abstract class ModifyAllQuery
extends ModifyQuery {
    public static final int NO_CACHE = 0;
    public static final int INVALIDATE_CACHE = 1;
    private int m_cacheUsage = 1;
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient Integer result;
    private boolean shouldDeferExecutionInUOW = true;
    protected ExpressionBuilder defaultBuilder;
    protected boolean isPreparedUsingTempStorage;

    public ModifyAllQuery() {
    }

    public ModifyAllQuery(Class referenceClass) {
        this();
        this.setReferenceClass(referenceClass);
    }

    public ModifyAllQuery(Class referenceClass, Expression selectionCriteria) {
        this();
        this.setReferenceClass(referenceClass);
        this.setSelectionCriteria(selectionCriteria);
    }

    public boolean isModifyQuery() {
        return true;
    }

    public void setIsPreparedUsingTempStorage(boolean isPreparedUsingTempStorage) {
        this.isPreparedUsingTempStorage = isPreparedUsingTempStorage;
    }

    public boolean isPreparedUsingTempStorage() {
        return this.isPreparedUsingTempStorage;
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery query, AbstractSession session) {
        super.clonedQueryExecutionComplete(query, session);
        if (session.isUnitOfWork()) {
            ((UnitOfWorkImpl)session).storeModifyAllQuery(query);
        }
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (unitOfWork.isNestedUnitOfWork()) {
            throw ValidationException.nestedUOWNotSupportedForModifyAllQuery();
        }
        if (this.shouldDeferExecutionInUOW()) {
            unitOfWork.storeDeferredModifyAllQuery(this, translationRow);
            this.result = null;
        } else {
            if (!unitOfWork.isInTransaction()) {
                unitOfWork.beginEarlyTransaction();
            }
            unitOfWork.setWasNonObjectLevelModifyQueryExecuted(true);
            this.result = (Integer)super.executeInUnitOfWork(unitOfWork, translationRow);
        }
        return this.result;
    }

    public int getCacheUsage() {
        return this.m_cacheUsage;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    protected void invalidateCache() {
        IdentityMapAccessor identityMapAccessor = this.getSession().getIdentityMapAccessor();
        if (this.getSelectionCriteria() == null) {
            if (this.getDescriptor().isChildDescriptor()) {
                Vector collectionToInvalidate = identityMapAccessor.getAllFromIdentityMap(null, this.getReferenceClass(), this.getTranslationRow(), null);
                identityMapAccessor.invalidateObjects(collectionToInvalidate);
            } else {
                identityMapAccessor.invalidateClass(this.getReferenceClass());
            }
        } else {
            boolean noObjectsModifiedInDb = this.result != null && this.result == 0;
            try {
                InMemoryQueryIndirectionPolicy policy = new InMemoryQueryIndirectionPolicy();
                if (noObjectsModifiedInDb) {
                    policy.ignoreIndirectionExceptionReturnNotConformed();
                } else {
                    policy.ignoreIndirectionExceptionReturnConformed();
                }
                Vector collectionToInvalidate = identityMapAccessor.getAllFromIdentityMap(this.getSelectionCriteria(), this.getReferenceClass(), this.getTranslationRow(), policy);
                identityMapAccessor.invalidateObjects(collectionToInvalidate);
            }
            catch (QueryException ex) {
                if (ex.getErrorCode() == 6074) {
                    if (!noObjectsModifiedInDb) {
                        identityMapAccessor.invalidateClass(this.getReferenceClass());
                    }
                }
                throw ex;
            }
        }
    }

    public void mergeChangesIntoSharedCache() {
        if (this.shouldInvalidateCache()) {
            this.invalidateCache();
        }
    }

    public void setCacheUsage(int cacheUsage) {
        this.m_cacheUsage = cacheUsage;
    }

    public void setReferenceClass(Class referenceClass) {
        if (this.referenceClass != referenceClass) {
            this.setIsPrepared(false);
        }
        this.referenceClass = referenceClass;
    }

    public void setReferenceClassName(String className) {
        this.referenceClassName = className;
    }

    public void setShouldDeferExecutionInUOW(boolean shouldDeferExecutionInUOW) {
        this.shouldDeferExecutionInUOW = shouldDeferExecutionInUOW;
    }

    public boolean shouldDeferExecutionInUOW() {
        return this.shouldDeferExecutionInUOW;
    }

    protected boolean shouldInvalidateCache() {
        return this.m_cacheUsage == 1;
    }

    protected void initializeDefaultBuilder() {
        this.initializeQuerySpecificDefaultBuilder();
        if (this.defaultBuilder == null) {
            this.defaultBuilder = new ExpressionBuilder();
        }
    }

    protected void initializeQuerySpecificDefaultBuilder() {
        DatabaseQueryMechanism mech = this.getQueryMechanism();
        if (mech.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)mech).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)mech).getExpressionBuilder();
        }
    }
}

