/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.type.MutableType;

public class BinaryType
extends MutableType {
    static /* synthetic */ Class array$B;

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            st.setBinaryStream(index, (InputStream)new ByteArrayInputStream((byte[])value), ((byte[])value).length);
        } else {
            st.setBytes(index, (byte[])value);
        }
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            InputStream inputStream = rs.getBinaryStream(name);
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[2048];
            try {
                int amountRead;
                while ((amountRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, amountRead);
                }
                inputStream.close();
                outputStream.close();
            }
            catch (IOException ioe) {
                throw new HibernateException("IOException occurred reading a binary value", ioe);
            }
            return outputStream.toByteArray();
        }
        return rs.getBytes(name);
    }

    public int sqlType() {
        return -3;
    }

    public Class getReturnedClass() {
        return array$B == null ? (array$B = BinaryType.class$("[B")) : array$B;
    }

    public boolean isEqual(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        byte[] bytes = (byte[])x;
        int hashCode = 1;
        for (int j = 0; j < bytes.length; ++j) {
            hashCode = 31 * hashCode + bytes[j];
        }
        return hashCode;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        byte[] xbytes = (byte[])x;
        byte[] ybytes = (byte[])y;
        if (xbytes.length < ybytes.length) {
            return -1;
        }
        if (xbytes.length > ybytes.length) {
            return 1;
        }
        for (int i = 0; i < xbytes.length; ++i) {
            if (xbytes[i] < ybytes[i]) {
                return -1;
            }
            if (xbytes[i] <= ybytes[i]) continue;
            return 1;
        }
        return 0;
    }

    public String getName() {
        return "binary";
    }

    public String toString(Object val) {
        byte[] bytes = (byte[])val;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = Integer.toHexString(bytes[i] - -128);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
        }
        return buf.toString();
    }

    public Object deepCopyNotNull(Object value) {
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public Object fromStringValue(String xml) throws HibernateException {
        if (xml == null) {
            return null;
        }
        if (xml.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid xml representation of a binary content.");
        }
        byte[] bytes = new byte[xml.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = xml.substring(i * 2, (i + 1) * 2);
            bytes[i] = (byte)(Integer.parseInt(hexStr, 16) + -128);
        }
        return bytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

