/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatReceiver;
import net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatSender;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MulticastRMICacheManagerPeerProvider
extends RMICacheManagerPeerProvider
implements CacheManagerPeerProvider {
    public static final int STALE_PEER_TIME_MS = 11000;
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$MulticastRMICacheManagerPeerProvider == null ? (class$net$sf$ehcache$distribution$MulticastRMICacheManagerPeerProvider = MulticastRMICacheManagerPeerProvider.class$("net.sf.ehcache.distribution.MulticastRMICacheManagerPeerProvider")) : class$net$sf$ehcache$distribution$MulticastRMICacheManagerPeerProvider).getName());
    private final MulticastKeepaliveHeartbeatReceiver heartBeatReceiver;
    private final MulticastKeepaliveHeartbeatSender heartBeatSender;
    static /* synthetic */ Class class$net$sf$ehcache$distribution$MulticastRMICacheManagerPeerProvider;

    public MulticastRMICacheManagerPeerProvider(CacheManager cacheManager, InetAddress groupMulticastAddress, Integer groupMulticastPort) {
        super(cacheManager);
        this.heartBeatReceiver = new MulticastKeepaliveHeartbeatReceiver(this, groupMulticastAddress, groupMulticastPort);
        this.heartBeatSender = new MulticastKeepaliveHeartbeatSender(cacheManager, groupMulticastAddress, groupMulticastPort);
    }

    public final void init() throws CacheException {
        try {
            this.heartBeatReceiver.init();
            this.heartBeatSender.init();
        }
        catch (IOException exception) {
            LOG.error((Object)("Error starting heartbeat. Error was: " + exception.getMessage()), (Throwable)exception);
            throw new CacheException(exception.getMessage());
        }
    }

    public final synchronized void registerPeer(String rmiUrl) {
        try {
            CachePeer cachePeer = MulticastRMICacheManagerPeerProvider.lookupRemoteCachePeer(rmiUrl);
            CachePeerEntry cachePeerEntry = new CachePeerEntry(cachePeer, new Date());
            this.peerUrls.put(rmiUrl, cachePeerEntry);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to lookup remote cache peer for " + rmiUrl + ". Removing from peer list. Cause was: " + e.getMessage()));
            }
            this.peerUrls.remove(rmiUrl);
        }
        catch (NotBoundException e) {
            this.peerUrls.remove(rmiUrl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to lookup remote cache peer for " + rmiUrl + ". Removing from peer list. Cause was: " + e.getMessage()));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Unable to lookup remote cache peer for " + rmiUrl + ". Cause was not due to an IOException or NotBoundException which will occur in normal operation:" + " " + t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List listRemoteCachePeers(Cache cache) throws CacheException {
        ArrayList<CachePeer> remoteCachePeers = new ArrayList<CachePeer>();
        ArrayList<String> staleList = new ArrayList<String>();
        Map map = this.peerUrls;
        synchronized (map) {
            String rmiUrl;
            Iterator iterator = this.peerUrls.keySet().iterator();
            while (iterator.hasNext()) {
                rmiUrl = (String)iterator.next();
                String rmiUrlCacheName = MulticastRMICacheManagerPeerProvider.extractCacheName(rmiUrl);
                try {
                    if (!rmiUrlCacheName.equals(cache.getName())) continue;
                    CachePeerEntry cachePeerEntry = (CachePeerEntry)this.peerUrls.get(rmiUrl);
                    Date date = cachePeerEntry.date;
                    if (!this.stale(date)) {
                        CachePeer cachePeer = cachePeerEntry.cachePeer;
                        remoteCachePeers.add(cachePeer);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("rmiUrl " + rmiUrl + " is stale. Either the remote peer is shutdown or the " + "network connectivity has been interrupted. Will be removed from list of remote cache peers"));
                    }
                    staleList.add(rmiUrl);
                }
                catch (Exception exception) {
                    LOG.error((Object)exception.getMessage(), (Throwable)exception);
                    throw new CacheException("Unable to list remote cache peers. Error was " + exception.getMessage());
                }
            }
            for (int i = 0; i < staleList.size(); ++i) {
                rmiUrl = (String)staleList.get(i);
                this.peerUrls.remove(rmiUrl);
            }
        }
        return remoteCachePeers;
    }

    public final void dispose() {
        this.heartBeatSender.dispose();
        this.heartBeatReceiver.dispose();
    }

    protected final boolean stale(Date date) {
        long now = System.currentTimeMillis();
        return date.getTime() < now - 11000L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class CachePeerEntry {
        private final CachePeer cachePeer;
        private final Date date;

        public CachePeerEntry(CachePeer cachePeer, Date date) {
            this.cachePeer = cachePeer;
            this.date = date;
        }

        public final CachePeer getCachePeer() {
            return this.cachePeer;
        }

        public final Date getDate() {
            return this.date;
        }
    }
}

