/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.events;

import com.lowagie.text.Document;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BasicPdfWriter;
import com.lowagie.text.pdf.PdfPageEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfPageEventForwarder
implements PdfPageEvent {
    protected ArrayList events = new ArrayList();

    public void addPageEvent(PdfPageEvent pdfPageEvent) {
        this.events.add(pdfPageEvent);
    }

    public void onOpenDocument(BasicPdfWriter basicPdfWriter, Document document) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onOpenDocument(basicPdfWriter, document);
        }
    }

    public void onStartPage(BasicPdfWriter basicPdfWriter, Document document) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onStartPage(basicPdfWriter, document);
        }
    }

    public void onEndPage(BasicPdfWriter basicPdfWriter, Document document) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onEndPage(basicPdfWriter, document);
        }
    }

    public void onCloseDocument(BasicPdfWriter basicPdfWriter, Document document) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onCloseDocument(basicPdfWriter, document);
        }
    }

    public void onParagraph(BasicPdfWriter basicPdfWriter, Document document, float f) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onParagraph(basicPdfWriter, document, f);
        }
    }

    public void onParagraphEnd(BasicPdfWriter basicPdfWriter, Document document, float f) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onParagraphEnd(basicPdfWriter, document, f);
        }
    }

    public void onChapter(BasicPdfWriter basicPdfWriter, Document document, float f, Paragraph paragraph) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onChapter(basicPdfWriter, document, f, paragraph);
        }
    }

    public void onChapterEnd(BasicPdfWriter basicPdfWriter, Document document, float f) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onChapterEnd(basicPdfWriter, document, f);
        }
    }

    public void onSection(BasicPdfWriter basicPdfWriter, Document document, float f, int n, Paragraph paragraph) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onSection(basicPdfWriter, document, f, n, paragraph);
        }
    }

    public void onSectionEnd(BasicPdfWriter basicPdfWriter, Document document, float f) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onSectionEnd(basicPdfWriter, document, f);
        }
    }

    public void onGenericTag(BasicPdfWriter basicPdfWriter, Document document, Rectangle rectangle, String string) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            PdfPageEvent pdfPageEvent = (PdfPageEvent)iterator.next();
            pdfPageEvent.onGenericTag(basicPdfWriter, document, rectangle, string);
        }
    }
}

