/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.EmptyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescendantsFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Descendants", "Descendants(<Member>[, <Level>[, <Desc_flag>]])", "Returns the set of descendants of a member at a specified level, optionally including or excluding descendants in other levels.", new String[]{"fxm", "fxml", "fxmly", "fxmn", "fxmny", "fxmey"}, DescendantsFunDef.class, Flag.getNames());
    static final ReflectiveMultiResolver Resolver2 = new ReflectiveMultiResolver("Descendants", "Descendants(<Set>[, <Level>[, <Desc_flag>]])", "Returns the set of descendants of a set of members at a specified level, optionally including or excluding descendants in other levels.", new String[]{"fxx", "fxxl", "fxxly", "fxxn", "fxxny", "fxxey"}, DescendantsFunDef.class, Flag.getNames());

    public DescendantsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        boolean depthEmpty;
        Type type0 = call.getArg(0).getType();
        if (type0 instanceof SetType) {
            SetType setType = (SetType)type0;
            if (setType.getElementType() instanceof TupleType) {
                throw MondrianResource.instance().DescendantsAppliedToSetOfTuples.ex();
            }
            MemberType memberType = (MemberType)setType.getElementType();
            Dimension dimension = memberType.getDimension();
            if (dimension == null) {
                throw MondrianResource.instance().CannotDeduceTypeOfSet.ex();
            }
            Exp[] descendantsArgs = (Exp[])call.getArgs().clone();
            descendantsArgs[0] = new UnresolvedFunCall("CurrentMember", Syntax.Property, new Exp[]{new DimensionExpr(dimension)});
            ResolvedFunCall generateCall = (ResolvedFunCall)compiler.getValidator().validate(new UnresolvedFunCall("Generate", new Exp[]{call.getArg(0), new UnresolvedFunCall("Descendants", descendantsArgs)}), false);
            return generateCall.accept(compiler);
        }
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        Flag flag = Flag.SELF;
        if (call.getArgCount() == 1) {
            flag = Flag.SELF_BEFORE_AFTER;
        }
        boolean depthSpecified = call.getArgCount() >= 2 && call.getArg(1).getType() instanceof NumericType;
        boolean bl = depthEmpty = call.getArgCount() >= 2 && call.getArg(1).getType() instanceof EmptyType;
        if (call.getArgCount() >= 3) {
            flag = FunUtil.getLiteralArg(call, 2, Flag.SELF, Flag.class);
        }
        if (call.getArgCount() >= 2 && depthEmpty && flag != Flag.LEAVES) {
            throw Util.newError("depth must be specified unless DESC_FLAG is LEAVES");
        }
        if ((depthSpecified || depthEmpty) && flag.leaves) {
            final IntegerCalc depthCalc = depthSpecified ? compiler.compileInteger(call.getArg(1)) : null;
            return new AbstractMemberListCalc(call, new Calc[]{memberCalc, depthCalc}){

                @Override
                public List<Member> evaluateMemberList(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    ArrayList<Member> result = new ArrayList<Member>();
                    int depth = -1;
                    if (depthCalc != null && (depth = depthCalc.evaluateInteger(evaluator)) < 0) {
                        depth = -1;
                    }
                    SchemaReader schemaReader = evaluator.getSchemaReader();
                    DescendantsFunDef.descendantsLeavesByDepth(member, result, schemaReader, depth);
                    FunUtil.hierarchizeMemberList(result, false);
                    return result;
                }
            };
        }
        if (depthSpecified) {
            final IntegerCalc depthCalc = call.getArgCount() > 1 ? compiler.compileInteger(call.getArg(1)) : null;
            final Flag flag1 = flag;
            return new AbstractMemberListCalc(call, new Calc[]{memberCalc, depthCalc}){

                @Override
                public List<Member> evaluateMemberList(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    ArrayList<Member> result = new ArrayList<Member>();
                    int depth = depthCalc.evaluateInteger(evaluator);
                    SchemaReader schemaReader = evaluator.getSchemaReader();
                    DescendantsFunDef.descendantsByDepth(member, result, schemaReader, depth, flag1.before, flag1.self, flag1.after, evaluator);
                    FunUtil.hierarchizeMemberList(result, false);
                    return result;
                }
            };
        }
        final LevelCalc levelCalc = call.getArgCount() > 1 ? compiler.compileLevel(call.getArg(1)) : null;
        final Flag flag2 = flag;
        return new AbstractMemberListCalc(call, new Calc[]{memberCalc, levelCalc}){

            @Override
            public List<Member> evaluateMemberList(Evaluator evaluator) {
                Evaluator context = evaluator.isNonEmpty() ? evaluator : null;
                Member member = memberCalc.evaluateMember(evaluator);
                ArrayList<Member> result = new ArrayList<Member>();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                Level level = levelCalc != null ? levelCalc.evaluateLevel(evaluator) : member.getLevel();
                DescendantsFunDef.descendantsByLevel(schemaReader, member, level, result, flag2.before, flag2.self, flag2.after, flag2.leaves, context);
                FunUtil.hierarchizeMemberList(result, false);
                return result;
            }
        };
    }

    private static void descendantsByDepth(Member member, List<Member> result, SchemaReader schemaReader, int depthLimitFinal, boolean before, boolean self, boolean after, Evaluator context) {
        List<Member> children = new ArrayList<Member>();
        children.add(member);
        int depth = 0;
        while (true) {
            if (depth == depthLimitFinal) {
                if (self) {
                    result.addAll(children);
                }
                if (!after) {
                    break;
                }
            } else if (depth < depthLimitFinal) {
                if (before) {
                    result.addAll(children);
                }
            } else {
                if (!after) break;
                result.addAll(children);
            }
            if ((children = schemaReader.getMemberChildren(children, context)).size() == 0) break;
            ++depth;
        }
    }

    private static void descendantsLeavesByDepth(Member member, List<Member> result, SchemaReader schemaReader, int depthLimit) {
        if (!schemaReader.isDrillable(member)) {
            if (depthLimit >= 0) {
                result.add(member);
            }
            return;
        }
        List<Member> children = new ArrayList<Member>();
        children.add(member);
        for (int depth = 0; depthLimit == -1 || depth <= depthLimit; ++depth) {
            if ((children = schemaReader.getMemberChildren(children)).size() == 0) {
                throw Util.newInternal("drillable member must have children");
            }
            ArrayList<Member> nextChildren = new ArrayList<Member>();
            for (Member child : children) {
                if (schemaReader.isDrillable(child)) {
                    nextChildren.add(child);
                    continue;
                }
                result.add(child);
            }
            if (nextChildren.isEmpty()) {
                return;
            }
            children = nextChildren;
        }
    }

    static void descendantsByLevel(SchemaReader schemaReader, Member ancestor, Level level, List<Member> result, boolean before, boolean self, boolean after, boolean leaves, Evaluator context) {
        int levelDepth = level.getDepth();
        List<Member> members = Collections.singletonList(ancestor);
        if (leaves) {
            ArrayList<Member> nextMembers;
            assert (!(before || self || after));
            do {
                nextMembers = new ArrayList<Member>();
                for (Member member : members) {
                    int currentDepth = member.getLevel().getDepth();
                    List<Member> childMembers = schemaReader.getMemberChildren(member, context);
                    if (childMembers.size() == 0) {
                        if (currentDepth != levelDepth) continue;
                        result.add(member);
                        continue;
                    }
                    if (currentDepth > levelDepth) continue;
                    nextMembers.addAll(childMembers);
                }
            } while ((members = nextMembers).size() > 0);
        } else {
            ArrayList<Member> fertileMembers = new ArrayList<Member>();
            do {
                fertileMembers.clear();
                for (Member member : members) {
                    int currentDepth = member.getLevel().getDepth();
                    if (currentDepth == levelDepth) {
                        if (self) {
                            result.add(member);
                        }
                        if (!after) continue;
                        fertileMembers.add(member);
                        continue;
                    }
                    if (currentDepth < levelDepth) {
                        if (before) {
                            result.add(member);
                        }
                        fertileMembers.add(member);
                        continue;
                    }
                    if (!after) continue;
                    result.add(member);
                    fertileMembers.add(member);
                }
            } while ((members = schemaReader.getMemberChildren(fertileMembers, context)).size() > 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Flag {
        SELF(true, false, false, false),
        AFTER(false, true, false, false),
        BEFORE(false, false, true, false),
        BEFORE_AND_AFTER(false, true, true, false),
        SELF_AND_AFTER(true, true, false, false),
        SELF_AND_BEFORE(true, false, true, false),
        SELF_BEFORE_AFTER(true, true, true, false),
        LEAVES(false, false, false, true);

        private final boolean self;
        private final boolean after;
        private final boolean before;
        private final boolean leaves;

        private Flag(boolean self, boolean after, boolean before, boolean leaves) {
            this.self = self;
            this.after = after;
            this.before = before;
            this.leaves = leaves;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (Flag flags : (Flag[])Flag.class.getEnumConstants()) {
                names.add(flags.name());
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

