/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.persistence.spi.ClassTransformer;
import oracle.toplink.essentials.PersistenceProvider;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitInfo;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.threetier.ServerSession;

public class JavaSECMPInitializer {
    protected HashMap<String, Set> classMap = null;
    public static Instrumentation globalInstrumentation;
    protected boolean shouldCreateInternalLoader = true;
    protected static JavaSECMPInitializer javaSECMPInitializer;
    protected HashMap<String, EntityManagerSetupImpl> emSetupImpls = new HashMap();
    protected HashMap<String, PersistenceUnitInfo> emSetupPersistenceUnitInfos = new HashMap();
    protected ClassLoader sessionClassLoader = null;

    public static JavaSECMPInitializer getJavaSECMPInitializer(Map properties) {
        if (javaSECMPInitializer == null) {
            JavaSECMPInitializer.initializeFromMain(properties);
        }
        return javaSECMPInitializer;
    }

    public static boolean isSingletonInitialized() {
        return javaSECMPInitializer != null;
    }

    public static int getTopLinkLoggingLevel() {
        String logLevel = System.getProperty("toplink.logging.level");
        return AbstractSessionLog.translateStringToLoggingLevel(logLevel);
    }

    protected JavaSECMPInitializer() {
        this.classMap = new HashMap();
    }

    protected boolean callPredeploy(PersistenceUnitInfo persistenceUnitInfo, Map m) {
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        if (providerClassName == null || providerClassName.equals("") || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName())) {
            ClassTransformer transformer;
            Set<String> tempLoaderSet = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo);
            ClassLoader tempLoader = this.createTempLoader(tempLoaderSet);
            Set<String> classSet = PersistenceUnitProcessor.buildPersistentClassSet(persistenceUnitInfo, tempLoader);
            EntityManagerSetupImpl emSetupImpl = new EntityManagerSetupImpl();
            this.emSetupImpls.put(persistenceUnitInfo.getPersistenceUnitName(), emSetupImpl);
            this.emSetupPersistenceUnitInfos.put(persistenceUnitInfo.getPersistenceUnitName(), persistenceUnitInfo);
            classSet.addAll(emSetupImpl.buildPersistentClassSet(tempLoader, persistenceUnitInfo));
            AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", persistenceUnitInfo.getPersistenceUnitName());
            this.classMap.put(persistenceUnitInfo.getPersistenceUnitName(), classSet);
            Set entityClasses = this.loadEntityClasses(classSet, tempLoader);
            if (globalInstrumentation == null) {
                m.put("toplink.weaving", "false");
            }
            if ((transformer = emSetupImpl.predeploy(entityClasses, tempLoader, persistenceUnitInfo, null)) != null && globalInstrumentation != null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", persistenceUnitInfo.getPersistenceUnitName());
                globalInstrumentation.addTransformer(new ClassFileTransformer(){

                    @Override
                    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                        return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                    }
                });
            } else if (transformer == null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
            } else if (globalInstrumentation == null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_globalInstrumentation_is_null");
            }
            return true;
        }
        return false;
    }

    protected ServerSession callDeploy(String emName) {
        AbstractSessionLog.getLog().log(2, "cmp_init_invoke_deploy", emName);
        ClassLoader loader = this.getMainLoader();
        Set entityClasses = this.loadEntityClasses(this.getClassSet(emName), loader);
        ServerSession ss = this.getEntityManagerSetupImpl(emName).deploy(entityClasses, loader);
        AbstractSessionLog.getLog().log(2, "cmp_init_completed_deploy", emName);
        return ss;
    }

    protected ClassLoader createTempLoader(String persistenceUnitName) {
        return this.createTempLoader(this.getClassSet(persistenceUnitName));
    }

    protected ClassLoader createTempLoader(Collection col) {
        return this.createTempLoader(col, true);
    }

    protected ClassLoader createTempLoader(Collection col, boolean shouldOverrideLoadClassForCollectionMembers) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof URLClassLoader)) {
            throw ValidationException.currentLoaderNotValid(currentLoader);
        }
        URL[] urlPath = ((URLClassLoader)currentLoader).getURLs();
        TempEntityLoader tempLoader = new TempEntityLoader(urlPath, currentLoader, col, shouldOverrideLoadClassForCollectionMembers);
        AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", tempLoader);
        AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", new Boolean(shouldOverrideLoadClassForCollectionMembers));
        return tempLoader;
    }

    private Set getClassSet(String persistenceUnitName) {
        if (this.classMap.containsKey(persistenceUnitName)) {
            return (HashSet)this.classMap.get(persistenceUnitName);
        }
        return new HashSet();
    }

    public EntityManagerSetupImpl getEntityManagerSetupImpl(String emName) {
        if (emName == null) {
            return this.emSetupImpls.get("");
        }
        return this.emSetupImpls.get(emName);
    }

    protected ClassLoader getMainLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public ServerSession getServerSession(String emName, Map m) {
        PersistenceUnitInfo persistenceInfo = this.emSetupPersistenceUnitInfos.get(emName);
        if (persistenceInfo == null) {
            return null;
        }
        HashMap<Object, Object> configMap = new HashMap<Object, Object>();
        Object key2 = null;
        if (m != null) {
            for (Object key2 : m.keySet()) {
                configMap.put(key2, m.get(key2));
            }
        }
        if (persistenceInfo.getProperties() != null) {
            for (Object key2 : persistenceInfo.getProperties().keySet()) {
                if (configMap.get(key2) != null) continue;
                configMap.put(key2, persistenceInfo.getProperties().get(key2));
            }
        }
        return this.getEntityManagerSetupImpl(emName).getServerSession(configMap, this.sessionClassLoader);
    }

    protected void initPersistenceUnits(URL url, Map m) {
        Vector<String> predeployedPersistenceUnits = new Vector<String>();
        for (PersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(url, this.sessionClassLoader)) {
            boolean predeployed = this.callPredeploy(persistenceUnitInfo, m);
            if (!predeployed) continue;
            predeployedPersistenceUnits.add(persistenceUnitInfo.getPersistenceUnitName());
        }
        Iterator predeployed = predeployedPersistenceUnits.iterator();
        while (predeployed.hasNext()) {
            this.callDeploy((String)predeployed.next());
        }
    }

    public void initialize(Map m) {
        this.sessionClassLoader = this.getMainLoader();
        for (URL url : PersistenceUnitProcessor.findPersistenceArchives()) {
            AbstractSessionLog.getLog().log(2, "cmp_init_initialize", url);
            this.initPersistenceUnits(url, m);
        }
    }

    protected static void initializeFromAgent(Instrumentation instrumentation) throws Exception {
        AbstractSessionLog.getLog().setLevel(JavaSECMPInitializer.getTopLinkLoggingLevel());
        globalInstrumentation = instrumentation;
        javaSECMPInitializer = new JavaSECMPInitializer();
        javaSECMPInitializer.initialize(new HashMap());
    }

    public static void initializeFromMain(Map m) {
        if (javaSECMPInitializer != null) {
            return;
        }
        javaSECMPInitializer = new JavaSECMPInitializer();
        AbstractSessionLog.getLog().setLevel(JavaSECMPInitializer.getTopLinkLoggingLevel());
        AbstractSessionLog.getLog().log(2, "cmp_init_initialize_from_main");
        javaSECMPInitializer.initialize(m);
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound(entityClassName, classLoader, cnfEx);
            }
        }
        return entityClasses;
    }

    public Properties getPersistenceUnitProperties(String emName) {
        return this.emSetupPersistenceUnitInfos.get(emName).getProperties();
    }

    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            super(urls, parent);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames) {
            this(urls, parent, classNames, true);
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

