/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.EntityMappingsXMLProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLDescriptorMetadata;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XPathEngine;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLAccessor
extends MetadataAccessor {
    private Node m_node;
    private String m_name;
    private XMLHelper m_helper;
    private Class m_relationType;
    private XPathEngine m_xPathEngine;

    private XMLAccessor(EntityMappingsXMLProcessor processor, XMLDescriptorMetadata xmlDmd, Node node) {
        this.setNeedsProcessing(true);
        this.m_node = node;
        this.m_metadataProcessor = processor;
        this.m_metadataDescriptor = xmlDmd;
        this.m_helper = ((EntityMappingsXMLProcessor)this.m_metadataProcessor).getHelper();
        this.m_isRelationship = null;
        this.m_xPathEngine = XPathEngine.getInstance();
    }

    public XMLAccessor(String attributeName, EntityMappingsXMLProcessor processor, XMLDescriptorMetadata dmd, Node node) {
        this(processor, dmd, node);
        this.m_attributeName = attributeName;
    }

    public String getAnnotatedElement() {
        return this.getAttributeName();
    }

    public String getAttributeName() {
        if (this.m_attributeName == null) {
            Node nameNode = this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"@name"});
            this.m_attributeName = nameNode != null && nameNode.getNodeValue() != null ? nameNode.getNodeValue() : "";
        }
        return this.m_attributeName;
    }

    public Node getAttributeNode() {
        return this.m_node;
    }

    public NodeList getAttributeOverrideNodes() {
        return this.m_xPathEngine.selectNodes(this.m_node, new String[]{"attribute-override"});
    }

    public NodeList getCascade() {
        return this.m_xPathEngine.selectNodes(this.m_node, new String[]{"cascade", "child::*"});
    }

    public Node getColumnNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"column"});
    }

    public Node getEnumeratedNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"enumerated", "text()"});
    }

    public String getFetchType() {
        String fetchVal = this.isManyToOne() || this.isOneToOne() || this.isBasic() ? "EAGER" : "LAZY";
        Node fetchNode = this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"@fetch"});
        if (fetchNode != null) {
            fetchVal = fetchNode.getNodeValue();
        }
        return fetchVal;
    }

    public Node getFetchNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"@fetch"});
    }

    public Node getGeneratedValueNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"generated-value"});
    }

    public Class getJavaClass() {
        return this.getMetadataDescriptor().getJavaClass();
    }

    public Node getJoinTableNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"join-table"});
    }

    public Node getLobNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"lob", "text()"});
    }

    public Node getMapKeyNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"map-key"});
    }

    public String getMappedBy() {
        if (!this.hasMappedBy()) {
            return "";
        }
        return this.getMappedByNode().getNodeValue();
    }

    public Node getMappedByNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"@mapped-by"});
    }

    public XMLDescriptorMetadata getMetadataDescriptor() {
        return (XMLDescriptorMetadata)this.m_metadataDescriptor;
    }

    public String getMapKey() {
        Node mapKeyNode = this.getMapKeyNode();
        String mapKey = "";
        if (mapKeyNode.getNodeValue() != null) {
            mapKey = mapKeyNode.getNodeValue();
        }
        return mapKey;
    }

    public String getName() {
        if (this.m_name == null) {
            if (this.getMetadataDescriptor().usesPropertyAccess()) {
                String[] methodNames = MetadataHelper.getMethodNamesForField(this.getAttributeName(), this.getRelationType());
                this.m_name = methodNames[0];
                this.getMetadataDescriptor().addSetMethodName(this.m_name, methodNames[1]);
            } else {
                this.m_name = this.getAttributeName();
            }
        }
        return this.m_name;
    }

    public Node getOrderByNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"order-by", "text()"});
    }

    public Class getRawClass() {
        return this.getRelationType();
    }

    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getRelationType();
        }
        return this.m_referenceClass;
    }

    public Class getRelationType() {
        if (this.m_relationType == null) {
            this.m_relationType = MetadataHelper.getClassForAttribute(this.m_attributeName, this.getMetadataDescriptor());
        }
        return this.m_relationType;
    }

    public Node getSequenceGeneratorNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"sequence-generator"});
    }

    public Node getTableGeneratorNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"table-generator"});
    }

    public Class getTargetEntity() {
        Node tgtNode = this.getTargetEntityNode();
        if (tgtNode != null) {
            return this.m_helper.getClassForName(tgtNode.getNodeValue());
        }
        if (MetadataHelper.isSupportedCollectionClass(this.getReferenceClass())) {
            Type fldType;
            Field fld = MetadataHelper.getFieldForAttribute(this.getAttributeName(), this.getJavaClass());
            if (fld != null && MetadataHelper.isGenericCollectionType(fldType = MetadataHelper.getGenericType(fld))) {
                return MetadataHelper.getReturnTypeFromGeneric(fldType);
            }
            return Void.TYPE;
        }
        return this.getReferenceClass();
    }

    public Node getTargetEntityNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"@target-entity"});
    }

    public Node getTemporalNode() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"temporal", "text()"});
    }

    public boolean hasAttributeOverrides() {
        return this.getAttributeOverrideNodes() != null;
    }

    public boolean hasCascade() {
        return this.getCascade() != null && this.getCascade().getLength() > 0;
    }

    public boolean hasColumn() {
        return this.getColumnNode() != null;
    }

    public boolean hasEnumerated() {
        return this.getEnumeratedNode() != null;
    }

    public boolean hasFetch() {
        return this.getFetchNode() != null;
    }

    public boolean hasJoinColumn() {
        NodeList joinColumnNodes = this.m_xPathEngine.selectNodes(this.m_node, new String[]{"join-column"});
        return joinColumnNodes != null && joinColumnNodes.getLength() == 1;
    }

    public boolean hasJoinColumns() {
        NodeList joinColumnNodes = this.m_xPathEngine.selectNodes(this.m_node, new String[]{"join-column"});
        return joinColumnNodes != null && joinColumnNodes.getLength() > 1;
    }

    public boolean hasMapKey() {
        return this.getMapKeyNode() != null;
    }

    public boolean hasMappedBy() {
        return this.getMappedByNode() != null;
    }

    public boolean hasOrderBy() {
        Node orderByNode = this.getOrderByNode();
        return orderByNode != null && orderByNode.getNodeValue() != null;
    }

    public boolean hasPrimaryKeyJoinColumn() {
        NodeList joinColumnNodes = this.m_xPathEngine.selectNodes(this.m_node, new String[]{"primary-key-join-column"});
        return joinColumnNodes != null && joinColumnNodes.getLength() == 1;
    }

    public boolean hasPrimaryKeyJoinColumns() {
        NodeList joinColumnNodes = this.m_xPathEngine.selectNodes(this.m_node, new String[]{"primary-key-join-column"});
        return joinColumnNodes != null && joinColumnNodes.getLength() > 1;
    }

    public boolean hasSequenceGenerator() {
        return this.getSequenceGeneratorNode() != null;
    }

    public boolean hasSqlResultSetMapping() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"sql-result-set-mapping"}) != null;
    }

    public boolean hasTableGenerator() {
        return this.getTableGeneratorNode() != null;
    }

    public boolean hasTemporal() {
        return this.getTemporalNode() != null;
    }

    public boolean isBasic() {
        return this.m_node.getLocalName().equals("basic");
    }

    public boolean isEmbedded() {
        Node embeddedNode = this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"embedded"});
        Node embeddedIdNode = this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"embedded-id"});
        Node referenceClassNode = this.m_helper.locateNode(this.getReferenceClass(), "embeddable");
        return embeddedNode != null || referenceClassNode != null && embeddedIdNode == null;
    }

    public boolean isEmbeddedId() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"embedded-id"}) != null;
    }

    public boolean isId() {
        return this.m_node.getLocalName().equals("id");
    }

    public boolean isLob() {
        return this.getLobNode() != null;
    }

    public boolean isManyToMany() {
        if (this.m_node.getLocalName().equals("many-to-many")) {
            if (MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(this.getRawClass(), this.m_attributeName);
        }
        return false;
    }

    public boolean isManyToOne() {
        return this.m_node.getLocalName().equals("many-to-one");
    }

    public boolean isOneToMany() {
        if (this.m_node.getLocalName().equals("one-to-many")) {
            if (MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(this.getRawClass(), this.m_attributeName);
        }
        return false;
    }

    public boolean isOneToOne() {
        return this.m_node.getLocalName().equals("one-to-one");
    }

    public boolean isOptional() {
        boolean optional = true;
        Node optionalNode = this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"@optional"});
        if (optionalNode != null) {
            optional = Boolean.getBoolean(optionalNode.getNodeValue());
        }
        return optional;
    }

    public boolean isTargetEntityDefinedInDocument() {
        return this.m_helper.locateNode(this.getTargetEntity()) != null;
    }

    public boolean isVersion() {
        return this.m_xPathEngine.selectSingleNode(this.m_node, new String[]{"version"}) != null;
    }

    public void setReferenceClass(Class potentialReferenceClass, String context) {
        this.m_referenceClass = MetadataHelper.getReferenceClass(this.getRelationType(), potentialReferenceClass);
        if (this.m_referenceClass == this.getRelationType()) {
            this.m_metadataProcessor.getLogger().logConfigMessage(context, this.m_attributeName, (Object)this.m_referenceClass);
        }
    }

    public void store() {
        this.getMetadataDescriptor().addAccessor(this);
    }

    public boolean usesIndirection() {
        return this.getFetchType().equals("LAZY");
    }
}

