/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.parsing.AttributeNode;
import oracle.toplink.essentials.internal.parsing.BinaryOperatorNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.internal.parsing.VariableNode;

public class MemberOfNode
extends BinaryOperatorNode {
    private boolean notIndicated = false;
    private Expression leftExpression = null;

    public void makeNodeOneToMany(Node theNode) {
        Node currentNode = theNode;
        while (true) {
            if (!currentNode.hasRight()) {
                ((AttributeNode)currentNode).setRequiresCollectionAttribute(true);
                return;
            }
            currentNode = currentNode.getRight();
        }
    }

    public void validate(ParseTreeContext context) {
        super.validate(context);
        Node left = this.getLeft();
        if (left.isVariableNode() && ((VariableNode)left).isAlias(context)) {
            context.usedVariable(((VariableNode)left).getCanonicalVariableName());
        }
        TypeHelper typeHelper = context.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        if (this.getLeft().isVariableNode() && ((VariableNode)this.getLeft()).isAlias(context)) {
            VariableNode leftVariableNode = (VariableNode)this.getLeft();
            this.makeNodeOneToMany(this.getRight());
            return this.getRight().generateExpression(context).equal(new ExpressionBuilder(leftVariableNode.resolveClass(context)));
        }
        if (this.getRight().isParameterNode()) {
            this.makeNodeOneToMany(this.getLeft());
        } else {
            this.makeNodeOneToMany(this.getRight());
        }
        if (this.notIndicated()) {
            Expression resultFromRight = null;
            context.setMemberOfNode(this);
            this.setLeftExpression(this.getLeft().generateExpression(context));
            resultFromRight = this.getRight().generateExpression(context);
            context.setMemberOfNode(null);
            this.setLeftExpression(null);
            return resultFromRight;
        }
        return this.getRight().generateExpression(context).equal(this.getLeft().generateExpression(context));
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }

    public void setLeftExpression(Expression newLeftExpression) {
        this.leftExpression = newLeftExpression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }
}

