/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.SQLResult;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public class ResultSetMappingQuery
extends ObjectBuildingQuery {
    protected String resultSetMappingName;
    protected SQLResultSetMapping resultSetMapping;

    public ResultSetMappingQuery() {
    }

    public ResultSetMappingQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ResultSetMappingQuery(Call call, String sqlResultSetMappingName) {
        this();
        this.setCall(call);
        this.resultSetMappingName = sqlResultSetMappingName;
    }

    public Object clone() {
        ResultSetMappingQuery cloneQuery = (ResultSetMappingQuery)super.clone();
        cloneQuery.resultSetMapping = this.resultSetMapping;
        cloneQuery.resultSetMappingName = this.resultSetMappingName;
        return cloneQuery;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        this.resultSetMapping.convertClassNamesToClasses(classLoader);
    }

    public void setSQLResultSetMapping(SQLResultSetMapping resultSetMapping) {
        this.resultSetMapping = resultSetMapping;
        this.resultSetMappingName = resultSetMapping.getName();
    }

    public void setSQLResultSetMappingName(String name) {
        if (name == null && this.resultSetMapping == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_sqlresultsetmapping_in_query"));
        }
        this.resultSetMappingName = name;
    }

    protected List buildObjectsFromRecords(List databaseRecords) {
        ArrayList<Object> results = new ArrayList<Object>(databaseRecords.size());
        SQLResultSetMapping mapping = this.getSQLResultSetMapping();
        Iterator iterator = databaseRecords.iterator();
        while (iterator.hasNext()) {
            if (mapping.getResults().size() > 1) {
                Object[] resultElement = new Object[mapping.getResults().size()];
                DatabaseRecord record = (DatabaseRecord)iterator.next();
                for (int i = 0; i < mapping.getResults().size(); ++i) {
                    resultElement[i] = ((SQLResult)mapping.getResults().get(i)).getValueFromRecord(record, this);
                }
                results.add(resultElement);
                continue;
            }
            if (mapping.getResults().size() == 1) {
                DatabaseRecord record = (DatabaseRecord)iterator.next();
                results.add(((SQLResult)mapping.getResults().get(0)).getValueFromRecord(record, this));
                continue;
            }
            return results;
        }
        return results;
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
            if (unitOfWork.isNestedUnitOfWork()) {
                UnitOfWorkImpl nestedUnitOfWork = (UnitOfWorkImpl)this.getSession();
                this.setSession(nestedUnitOfWork.getParent());
                Object result = this.executeDatabaseQuery();
                this.setSession(nestedUnitOfWork);
                Object clone = this.registerIndividualResult(result, unitOfWork, false);
                if (this.shouldUseWrapperPolicy()) {
                    clone = this.getDescriptor().getObjectBuilder().wrapObject(clone, unitOfWork);
                }
                return clone;
            }
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        Vector rows = this.getQueryMechanism().executeSelect();
        this.setExecutionTime(System.currentTimeMillis());
        return this.buildObjectsFromRecords(rows);
    }

    protected void prepare() {
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        this.getQueryMechanism().prepare();
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public SQLResultSetMapping getSQLResultSetMapping() {
        if (this.resultSetMapping == null && this.resultSetMappingName != null) {
            this.resultSetMapping = this.getSession().getProject().getSQLResultSetMapping(this.resultSetMappingName);
        }
        return this.resultSetMapping;
    }

    public String getSQLResultSetMappingName() {
        return this.resultSetMappingName;
    }
}

