/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mondrian.util.UnsupportedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraversalList<T>
extends UnsupportedList<T[]> {
    private boolean asInternalArray = false;
    private T[][] internalArray = null;
    private final List<T>[] lists;
    private final Class<T> clazz;

    public TraversalList(List<T>[] lists, Class<T> clazz) {
        this.lists = lists;
        this.clazz = clazz;
    }

    @Override
    public T[] get(int index) {
        if (this.asInternalArray) {
            return this.internalArray[index];
        }
        Object[] tuples = (Object[])Array.newInstance(this.clazz, this.lists.length);
        for (int i = 0; i < this.lists.length; ++i) {
            tuples[i] = this.lists[i].get(index);
        }
        return tuples;
    }

    @Override
    public Iterator<T[]> iterator() {
        return new Iterator<T[]>(){
            private int currentIndex = 0;
            private T[] precalculated;

            @Override
            public T[] next() {
                if (this.precalculated != null) {
                    T[] t = this.precalculated;
                    this.precalculated = null;
                    ++this.currentIndex;
                    return t;
                }
                return TraversalList.this.get(this.currentIndex++);
            }

            @Override
            public boolean hasNext() {
                try {
                    this.precalculated = TraversalList.this.get(this.currentIndex);
                    return true;
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ListIterator<T[]> listIterator(int index) {
        return new UnsupportedList.ListItr(index){

            @Override
            public void set(T[] l) {
                TraversalList.this.set(this.cursor - 1, l);
            }
        };
    }

    @Override
    public ListIterator<T[]> listIterator() {
        return new UnsupportedList.ListItr(0){

            @Override
            public void set(T[] l) {
                TraversalList.this.set(this.cursor - 1, l);
            }
        };
    }

    @Override
    public int size() {
        return this.lists[0].size();
    }

    @Override
    public List<T[]> subList(final int first, final int last) {
        return new AbstractList<T[]>(){

            @Override
            public T[] get(int index) {
                return TraversalList.this.get(index + first);
            }

            @Override
            public int size() {
                return last - first;
            }
        };
    }

    private T[][] materialize(Object[][] a) {
        Object[][] array = a != null && a.length == this.size() && a.getClass().getComponentType() == this.clazz ? a : (Object[][])new Object[this.size()][];
        int k = 0;
        for (T[] x : this) {
            array[k++] = x;
        }
        this.asInternalArray = true;
        this.internalArray = array;
        return array;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return (Object[])this.materialize((Object[][])a);
    }

    @Override
    public Object[] toArray() {
        return this.materialize(null);
    }

    @Override
    public T[] set(int index, T[] l) {
        if (this.asInternalArray) {
            T[] previous = this.internalArray[index];
            this.internalArray[index] = l;
            return previous;
        }
        throw new UnsupportedOperationException();
    }
}

