/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class ProjectClassPathModifierImplementation {
    protected ProjectClassPathModifierImplementation() {
    }

    protected abstract SourceGroup[] getExtensibleSourceGroups();

    protected abstract String[] getExtensibleClassPathTypes(SourceGroup var1);

    protected abstract boolean addLibraries(Library[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected abstract boolean removeLibraries(Library[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected abstract boolean addRoots(URL[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected boolean addRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.addRoots(ProjectClassPathModifierImplementation.convertURIsToURLs(uRIArray), sourceGroup, string);
    }

    private static URL[] convertURIsToURLs(URI[] uRIArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URI uRI : uRIArray) {
            if (!uRI.isAbsolute()) {
                throw new UnsupportedOperationException("default modifier handles only absolute URIs - " + uRI);
            }
            try {
                arrayList.add(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    protected static URI[] convertURLsToURIs(URL[] uRLArray) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (URL uRL : uRLArray) {
            arrayList.add(URI.create(uRL.toExternalForm()));
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    protected abstract boolean removeRoots(URL[] var1, SourceGroup var2, String var3) throws IOException, UnsupportedOperationException;

    protected boolean removeRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.removeRoots(ProjectClassPathModifierImplementation.convertURIsToURLs(uRIArray), sourceGroup, string);
    }

    protected abstract boolean addAntArtifacts(AntArtifact[] var1, URI[] var2, SourceGroup var3, String var4) throws IOException, UnsupportedOperationException;

    protected abstract boolean removeAntArtifacts(AntArtifact[] var1, URI[] var2, SourceGroup var3, String var4) throws IOException, UnsupportedOperationException;

    protected final String performSharabilityHeuristics(URI uRI, AntProjectHelper antProjectHelper) throws URISyntaxException, IOException {
        String string;
        File file;
        File file2;
        assert (uRI != null);
        assert (uRI.toString().endsWith("/")) : "Folder URI must end with '/'. Was: " + uRI;
        URI uRI2 = LibrariesSupport.getArchiveFile((URI)uRI);
        if (uRI2 == null) {
            uRI2 = uRI;
        }
        if (CollocationQuery.areCollocated((File)(file2 = PropertyUtils.resolveFile((File)(file = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory())), (String)LibrariesSupport.convertURIToFilePath((URI)uRI2))), (File)file)) {
            string = PropertyUtils.relativizeFile((File)file, (File)file2);
        } else if (antProjectHelper.isSharableProject()) {
            File file3 = PropertyUtils.resolveFile((File)file, (String)antProjectHelper.getLibrariesLocation());
            boolean bl = CollocationQuery.areCollocated((File)file3.getParentFile(), (File)file2);
            boolean bl2 = LibrariesSupport.convertFilePathToURI((String)antProjectHelper.getLibrariesLocation()).isAbsolute();
            if (bl2 && bl) {
                string = file2.getAbsolutePath();
            } else if (bl2 && !bl) {
                File file4 = this.copyFile(file2, FileUtil.toFileObject((File)file3.getParentFile()));
                string = file4.getAbsolutePath();
            } else if (!bl2 && bl) {
                string = PropertyUtils.relativizeFile((File)file, (File)file2);
            } else {
                File file5 = this.copyFile(file2, FileUtil.toFileObject((File)file3.getParentFile()));
                string = PropertyUtils.relativizeFile((File)file, (File)file5);
            }
        } else {
            string = file2.getAbsolutePath();
        }
        return string;
    }

    private File copyFile(File file, FileObject fileObject) throws IOException {
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        if (fileObject2.isFolder()) {
            return FileUtil.toFile((FileObject)this.copyFolderRecursively(fileObject2, fileObject));
        }
        FileObject fileObject3 = fileObject.getFileObject(fileObject2.getName(), fileObject2.getExt());
        if (fileObject3 != null) {
            fileObject3.delete();
        }
        return FileUtil.toFile((FileObject)FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)fileObject2.getName(), (String)fileObject2.getExt()));
    }

    private FileObject copyFolderRecursively(FileObject fileObject, FileObject fileObject2) throws IOException {
        assert (fileObject.isFolder()) : fileObject;
        assert (fileObject2.isFolder()) : fileObject2;
        FileObject fileObject3 = fileObject2.getFileObject(fileObject.getName());
        if (fileObject3 == null) {
            fileObject3 = fileObject2.createFolder(fileObject.getName());
        }
        for (FileObject fileObject4 : fileObject.getChildren()) {
            if (fileObject4.isFolder()) {
                this.copyFolderRecursively(fileObject4, fileObject3);
                continue;
            }
            FileObject fileObject5 = fileObject3.getFileObject(fileObject4.getName(), fileObject4.getExt());
            if (fileObject5 != null) {
                fileObject5.delete();
            }
            FileUtil.copyFile((FileObject)fileObject4, (FileObject)fileObject3, (String)fileObject4.getName(), (String)fileObject4.getExt());
        }
        return fileObject3;
    }

    static {
        ProjectClassPathModifierAccessor.INSTANCE = new Accessor();
    }

    private static class Accessor
    extends ProjectClassPathModifierAccessor {
        private Accessor() {
        }

        public SourceGroup[] getExtensibleSourceGroups(ProjectClassPathModifierImplementation projectClassPathModifierImplementation) {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.getExtensibleSourceGroups();
        }

        public String[] getExtensibleClassPathTypes(ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup) {
            assert (projectClassPathModifierImplementation != null);
            assert (sourceGroup != null);
            return projectClassPathModifierImplementation.getExtensibleClassPathTypes(sourceGroup);
        }

        public boolean removeLibraries(Library[] libraryArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.removeLibraries(libraryArray, sourceGroup, string);
        }

        public boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.removeAntArtifacts(antArtifactArray, uRIArray, sourceGroup, string);
        }

        public boolean addLibraries(Library[] libraryArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.addLibraries(libraryArray, sourceGroup, string);
        }

        public boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.addAntArtifacts(antArtifactArray, uRIArray, sourceGroup, string);
        }

        public boolean removeRoots(URL[] uRLArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.removeRoots(uRLArray, sourceGroup, string);
        }

        public boolean removeRoots(URI[] uRIArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.removeRoots(uRIArray, sourceGroup, string);
        }

        public boolean addRoots(URL[] uRLArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.addRoots(uRLArray, sourceGroup, string);
        }

        public boolean addRoots(URI[] uRIArray, ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            assert (projectClassPathModifierImplementation != null);
            return projectClassPathModifierImplementation.addRoots(uRIArray, sourceGroup, string);
        }
    }
}

