/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultWindow;
import org.netbeans.modules.junit.output.TaskType;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

final class Manager {
    private static Reference<Manager> instanceRef;
    private final Map<AntSession, TaskType> junitSessions = new WeakHashMap<AntSession, TaskType>(5);
    private final boolean lateWindowPromotion;
    private Map<AntSession, ResultDisplayHandler> displayHandlers;
    private Map<AntSession, Boolean> displaysMap;

    static Manager getInstance() {
        Manager manager;
        Manager manager2 = manager = instanceRef != null ? instanceRef.get() : null;
        if (manager == null) {
            manager = new Manager();
            instanceRef = new WeakReference<Manager>(manager);
        }
        return manager;
    }

    private Manager() {
        this.lateWindowPromotion = true;
    }

    void testStarted(AntSession antSession, TaskType taskType) {
        this.displayMessage(antSession, taskType, NbBundle.getMessage(this.getClass(), (String)"LBL_RunningTests"));
    }

    void sessionFinished(AntSession antSession, TaskType taskType) {
        TaskType taskType2 = this.junitSessions.get(antSession);
        if (taskType2 == null) {
            return;
        }
        this.displayMessage(antSession, taskType, null, true);
        this.junitSessions.remove(antSession);
    }

    void displayOutput(AntSession antSession, TaskType taskType, String string, boolean bl) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displayOutput(string, bl);
        this.displayInWindow(antSession, taskType, resultDisplayHandler);
    }

    void displaySuiteRunning(AntSession antSession, TaskType taskType, String string) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displaySuiteRunning(string);
        this.displayInWindow(antSession, taskType, resultDisplayHandler);
    }

    void displayReport(AntSession antSession, TaskType taskType, Report report) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displayReport(report);
        this.displayInWindow(antSession, taskType, resultDisplayHandler);
    }

    private void displayMessage(AntSession antSession, TaskType taskType, String string) {
        this.displayMessage(antSession, taskType, string, false);
    }

    private void displayMessage(AntSession antSession, TaskType taskType, String string, boolean bl) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        if (!bl) {
            resultDisplayHandler.displayMessage(string);
        } else {
            resultDisplayHandler.displayMessageSessionFinished(string);
        }
        this.displayInWindow(antSession, taskType, resultDisplayHandler, bl);
    }

    private void displayInWindow(AntSession antSession, TaskType taskType, ResultDisplayHandler resultDisplayHandler) {
        this.displayInWindow(antSession, taskType, resultDisplayHandler, false);
    }

    private void displayInWindow(AntSession antSession, TaskType taskType, ResultDisplayHandler resultDisplayHandler, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.junitSessions.put(antSession, taskType) == null;
        boolean bl4 = this.lateWindowPromotion ? bl : bl2 && taskType == TaskType.TEST_TASK;
        int n = this.getDisplayIndex(antSession);
        if (n == -1) {
            this.addDisplay(antSession);
            Mutex.EVENT.writeAccess((Runnable)new Displayer(resultDisplayHandler, bl4));
        } else if (bl4) {
            Mutex.EVENT.writeAccess((Runnable)new Displayer(null, bl4));
        }
    }

    private ResultDisplayHandler getDisplayHandler(AntSession antSession) {
        ResultDisplayHandler resultDisplayHandler;
        ResultDisplayHandler resultDisplayHandler2 = resultDisplayHandler = this.displayHandlers != null ? this.displayHandlers.get(antSession) : null;
        if (resultDisplayHandler == null) {
            if (this.displayHandlers == null) {
                this.displayHandlers = new WeakHashMap<AntSession, ResultDisplayHandler>(7);
            }
            resultDisplayHandler = new ResultDisplayHandler();
            this.displayHandlers.put(antSession, resultDisplayHandler);
        }
        return resultDisplayHandler;
    }

    private int getDisplayIndex(AntSession antSession) {
        if (this.displaysMap == null) {
            return -1;
        }
        Boolean bl = this.displaysMap.get(antSession);
        return bl != null ? 0 : -1;
    }

    private void addDisplay(AntSession antSession) {
        if (this.displaysMap == null) {
            this.displaysMap = new WeakHashMap<AntSession, Boolean>(4);
        }
        this.displaysMap.put(antSession, Boolean.TRUE);
    }

    private class Displayer
    implements Runnable {
        private final ResultDisplayHandler displayHandler;
        private final boolean promote;

        Displayer(ResultDisplayHandler resultDisplayHandler, boolean bl) {
            this.displayHandler = resultDisplayHandler;
            this.promote = bl;
        }

        public void run() {
            ResultWindow resultWindow = ResultWindow.getInstance();
            if (this.displayHandler != null) {
                resultWindow.addDisplayComponent(this.displayHandler.getDisplayComponent());
            }
            if (this.promote) {
                resultWindow.promote();
            }
        }
    }
}

