/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.util.Collection;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.RootNodeChildren;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RootNode
extends AbstractNode {
    static final String name = "JUnit results root node";
    static final int ALL_PASSED_ABSENT = 0;
    static final int SOME_PASSED_ABSENT = 1;
    static final int ALL_PASSED_DISPLAYED = 2;
    private final RootNodeChildren children;
    private volatile boolean filtered;
    private volatile String message;
    private volatile int totalTests = 0;
    private volatile int failures = 0;
    private volatile int errors = 0;
    private volatile int interruptedTests = 0;
    private volatile int elapsedTimeMillis = 0;
    private volatile int detectedPassedTests = 0;
    private boolean sessionFinished;

    public RootNode(boolean bl) {
        super((Children)new RootNodeChildren(bl));
        this.filtered = bl;
        this.children = (RootNodeChildren)this.getChildren();
        this.setName(name);
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/empty.gif");
    }

    void displayMessage(String string) {
        assert (EventQueue.isDispatchThread());
        this.message = string;
        this.updateDisplayName();
    }

    void displayMessageSessionFinished(String string) {
        this.sessionFinished = true;
        this.displayMessage(string);
    }

    void displaySuiteRunning(String string) {
        assert (EventQueue.isDispatchThread());
        this.children.displaySuiteRunning(string);
    }

    TestsuiteNode displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        this.updateStatistics(report);
        this.updateDisplayName();
        return this.children.displayReport(report);
    }

    void displayReports(Collection<Report> collection) {
        assert (EventQueue.isDispatchThread());
        for (Report report : collection) {
            this.updateStatistics(report);
        }
        this.updateDisplayName();
        this.children.displayReports(collection);
    }

    private void updateStatistics(Report report) {
        this.totalTests += report.totalTests;
        this.failures += report.failures;
        this.errors += report.errors;
        this.detectedPassedTests += report.detectedPassedTests;
        this.interruptedTests += report.interruptedTests;
        this.elapsedTimeMillis += report.elapsedTimeMillis;
    }

    void setFiltered(boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((RootNodeChildren)children).setFiltered(bl);
        }
    }

    private void updateDisplayName() {
        String string;
        assert (EventQueue.isDispatchThread());
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (this.totalTests == 0) {
            string = this.sessionFinished ? NbBundle.getMessage(clazz, (String)"MSG_TestsInfoNoTests") : null;
        } else if (this.failures == 0 && this.errors == 0 && this.interruptedTests == 0) {
            string = NbBundle.getMessage(clazz, (String)"MSG_TestsInfoAllOK", (Object)this.totalTests);
        } else {
            StringBuilder stringBuilder = new StringBuilder(40);
            stringBuilder.append(NbBundle.getMessage(clazz, (String)"MSG_PassedTestsInfo", (Object)(this.totalTests - this.failures - this.errors - this.interruptedTests)));
            if (this.failures != 0 || this.errors != 0) {
                stringBuilder.append(", ");
                stringBuilder.append(NbBundle.getMessage(clazz, (String)"MSG_FailedTestsInfo", (Object)this.failures));
            }
            if (this.errors != 0) {
                stringBuilder.append(", ");
                stringBuilder.append(NbBundle.getMessage(clazz, (String)"MSG_ErrorTestsInfo", (Object)this.errors));
            }
            if (this.interruptedTests != 0) {
                stringBuilder.append(", ");
                stringBuilder.append(NbBundle.getMessage(clazz, (String)"MSG_InterruptedTestsInfo", (Object)this.interruptedTests));
            }
            stringBuilder.append('.');
            string = stringBuilder.toString();
        }
        if (this.totalTests != 0) {
            assert (string != null);
            int n = this.getSuccessDisplayedLevel();
            switch (n) {
                case 1: {
                    string = string + ' ';
                    string = string + NbBundle.getMessage(clazz, (String)"MSG_SomePassedNotDisplayed");
                    break;
                }
                case 0: {
                    string = string + ' ';
                    string = string + NbBundle.getMessage(clazz, (String)"MSG_PassedNotDisplayed");
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.message != null) {
            string = string == null ? this.message : string + ' ' + this.message;
        }
        this.setDisplayName(string);
    }

    int getSuccessDisplayedLevel() {
        int n = this.totalTests - this.failures - this.errors - this.interruptedTests;
        if (this.detectedPassedTests >= n) {
            return 2;
        }
        if (this.detectedPassedTests == 0) {
            return 0;
        }
        return 1;
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }
}

