/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import org.netbeans.modules.junit.output.HtmlMarkupUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.TestsuiteNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class TestsuiteNode
extends AbstractNode {
    private String suiteName;
    private Report report;
    private boolean filtered;

    TestsuiteNode(String string, boolean bl) {
        this(null, string, bl);
    }

    TestsuiteNode(Report report, boolean bl) {
        this(report, null, bl);
    }

    private TestsuiteNode(Report report, String string, boolean bl) {
        super((Children)(report != null ? new TestsuiteNodeChildren(report, bl) : Children.LEAF));
        this.report = report;
        this.suiteName = report != null ? report.suiteClassName : string;
        this.filtered = bl;
        assert (this.suiteName != null);
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/class.gif");
    }

    void displayReport(Report report) {
        assert (this.report == null && report != null);
        assert (report.suiteClassName.equals(this.suiteName) || this.suiteName == ResultDisplayHandler.ANONYMOUS_SUITE);
        this.report = report;
        this.suiteName = report.suiteClassName;
        this.setDisplayName();
        this.setChildren((Children)new TestsuiteNodeChildren(report, this.filtered));
    }

    Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        String string;
        String string2;
        boolean bl = true;
        if (this.report != null) {
            boolean bl2 = this.containsFailed();
            boolean bl3 = this.report.isSuiteInterrupted();
            string2 = bl3 ? (bl2 ? "MSG_TestsuiteFailedInterrupted" : "MSG_TestsuiteInterrupted") : (bl2 ? "MSG_TestsuiteFailed" : null);
        } else if (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE) {
            string2 = "MSG_TestsuiteRunning";
        } else {
            string2 = "MSG_TestsuiteRunningNoname";
            bl = false;
        }
        if (string2 == null) {
            assert (this.suiteName != null);
            string = this.suiteName;
        } else {
            string = bl ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string2, (Object)this.suiteName) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string2);
        }
        this.setDisplayName(string);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuilder stringBuilder = new StringBuilder(60);
        if (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE) {
            stringBuilder.append(this.suiteName);
        } else {
            stringBuilder.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteNoname"));
        }
        if (this.report != null) {
            boolean bl = this.containsFailed();
            boolean bl2 = this.report.isSuiteInterrupted();
            if (bl) {
                stringBuilder.append("&nbsp;&nbsp;");
                HtmlMarkupUtils.appendColourText(stringBuilder, "FF0000", "MSG_TestsuiteFailed_HTML");
            }
            if (bl2) {
                stringBuilder.append("&nbsp;&nbsp;");
                HtmlMarkupUtils.appendColourText(stringBuilder, "CE7B00", "MSG_TestsuiteInterrupted_HTML");
            }
            if (!bl && !bl2) {
                stringBuilder.append("&nbsp;&nbsp;");
                HtmlMarkupUtils.appendColourText(stringBuilder, "00CC00", "MSG_TestsuitePassed_HTML");
            }
        } else {
            stringBuilder.append("&nbsp;&nbsp;");
            stringBuilder.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning_HTML"));
        }
        return stringBuilder.toString();
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((TestsuiteNodeChildren)children).setFiltered(bl);
        }
    }

    private boolean containsFailed() {
        return this.report != null && this.report.failures + this.report.errors != 0;
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }
}

