/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output.antutils;

import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.netbeans.modules.junit.output.antutils.BatchTest;

public final class TestCounter {
    private final AntEvent event;

    public static int getTestClassCount(AntEvent antEvent) {
        TestCounter testCounter = new TestCounter(antEvent);
        return testCounter.countTestClasses();
    }

    private TestCounter(AntEvent antEvent) {
        this.event = antEvent;
    }

    private int countTestClasses() {
        String string = this.event.getTaskName();
        if (string.equals("junit")) {
            return this.countTestClassesInJUnitTask();
        }
        if (string.equals("java")) {
            return this.countTestClassesInJavaTask();
        }
        assert (false) : "Unhandled task name";
        return -1;
    }

    private int countTestClassesInJUnitTask() {
        int n = 0;
        TaskStructure taskStructure = this.event.getTaskStructure();
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string = taskStructure2.getName();
            if (string.equals("test")) {
                if (!this.conditionsMet(taskStructure2)) continue;
                ++n;
                continue;
            }
            if (!string.equals("batchtest") || !this.conditionsMet(taskStructure2)) continue;
            AntProject antProject = new AntProject(this.event);
            BatchTest batchTest = new BatchTest(antProject);
            batchTest.handleChildrenAndAttrs(taskStructure2);
            int n2 = batchTest.countTestClasses();
            if (n2 <= 0) continue;
            n += n2;
        }
        return n;
    }

    private boolean conditionsMet(TaskStructure taskStructure) {
        String string = taskStructure.getAttribute("if");
        String string2 = taskStructure.getAttribute("unless");
        if (string != null && this.event.getProperty(string) == null) {
            return false;
        }
        return string2 == null || this.event.getProperty(string2) == null;
    }

    private int countTestClassesInJavaTask() {
        return 1;
    }
}

