/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPool {
    private static final byte TAG_UTF8 = 1;
    private static final byte TAG_INTEGER = 3;
    private static final byte TAG_FLOAT = 4;
    private static final byte TAG_LONG = 5;
    private static final byte TAG_DOUBLE = 6;
    private static final byte TAG_CLASS = 7;
    private static final byte TAG_STRING = 8;
    private static final byte TAG_FIELDREF = 9;
    private static final byte TAG_METHODREF = 10;
    private static final byte TAG_INTERFACEREF = 11;
    private static final byte TAG_NAMETYPE = 12;
    private final List<Entry> entries;

    private ConstantPool(List<Entry> list) {
        this.entries = list;
    }

    public Entry getEntry(int n) {
        return this.entries.get(n);
    }

    public String getMethodName(int n) {
        EntryFieldMethodRef entryFieldMethodRef = (EntryFieldMethodRef)this.entries.get(n);
        return ((EntryUTF8)this.entries.get(((EntryNameType)this.entries.get(entryFieldMethodRef.nameAndTypeIndex)).getNameIndex())).getUTF8();
    }

    public static ConstantPool parse(byte[] byArray) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        arrayList.add(new EntryNULL());
        try {
            while (true) {
                Entry entry;
                byte by;
                try {
                    by = dataInputStream.readByte();
                }
                catch (EOFException eOFException) {
                    break;
                }
                switch (by) {
                    case 1: {
                        entry = new EntryUTF8(dataInputStream.readUTF());
                        break;
                    }
                    case 3: {
                        entry = new EntryInteger(dataInputStream.readInt());
                        break;
                    }
                    case 5: {
                        entry = new EntryLong(dataInputStream.readLong());
                        arrayList.add(entry);
                        entry = new EntryNULL();
                        break;
                    }
                    case 4: {
                        entry = new EntryFloat(dataInputStream.readFloat());
                        break;
                    }
                    case 6: {
                        entry = new EntryDouble(dataInputStream.readDouble());
                        arrayList.add(entry);
                        entry = new EntryNULL();
                        break;
                    }
                    case 7: {
                        entry = new EntryClass(dataInputStream.readShort());
                        break;
                    }
                    case 8: {
                        entry = new EntryString(dataInputStream.readShort());
                        break;
                    }
                    case 12: {
                        entry = new EntryNameType(dataInputStream.readShort(), dataInputStream.readShort());
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        entry = new EntryFieldMethodRef(by, dataInputStream.readShort(), dataInputStream.readShort());
                        break;
                    }
                    default: {
                        Logger.getLogger(ConstantPool.class.getName()).warning("Unknown tag byte: " + by);
                        entry = new EntryNULL();
                    }
                }
                arrayList.add(entry);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new ConstantPool(arrayList);
    }

    public static class EntryFieldMethodRef
    extends Entry {
        private short classIndex;
        private short nameAndTypeIndex;

        public EntryFieldMethodRef(byte by, short s, short s2) {
            super(by);
            this.classIndex = s;
            this.nameAndTypeIndex = s2;
        }
    }

    public static class EntryNameType
    extends Entry {
        private short nameIndex;
        private short descriptorIndex;

        public EntryNameType(short s, short s2) {
            super((byte)12);
            this.nameIndex = s;
            this.descriptorIndex = s2;
        }

        public short getNameIndex() {
            return this.nameIndex;
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }
    }

    public static class EntryString
    extends Entry {
        private short stringRef;

        public EntryString(short s) {
            super((byte)8);
            this.stringRef = s;
        }

        public short getStringRef() {
            return this.stringRef;
        }
    }

    public static class EntryClass
    extends Entry {
        private short classRef;

        public EntryClass(short s) {
            super((byte)7);
            this.classRef = s;
        }

        public short getClassRef() {
            return this.classRef;
        }
    }

    public static class EntryDouble
    extends Entry {
        private double d;

        public EntryDouble(double d) {
            super((byte)6);
            this.d = d;
        }

        public double getDouble() {
            return this.d;
        }
    }

    public static class EntryFloat
    extends Entry {
        private float f;

        public EntryFloat(float f) {
            super((byte)4);
            this.f = f;
        }

        public float getFloat() {
            return this.f;
        }
    }

    public static class EntryLong
    extends Entry {
        private long l;

        public EntryLong(long l) {
            super((byte)5);
            this.l = l;
        }

        public long getLong() {
            return this.l;
        }
    }

    public static class EntryInteger
    extends Entry {
        private int i;

        public EntryInteger(int n) {
            super((byte)3);
            this.i = n;
        }

        public int getInteger() {
            return this.i;
        }
    }

    public static class EntryUTF8
    extends Entry {
        private String utf8;

        public EntryUTF8(String string) {
            super((byte)1);
            this.utf8 = string;
        }

        public String getUTF8() {
            return this.utf8;
        }
    }

    public static class EntryNULL
    extends Entry {
        public EntryNULL() {
            super((byte)0);
        }
    }

    public static abstract class Entry {
        private final byte tag;

        protected Entry(byte by) {
            this.tag = by;
        }

        public final byte getTag() {
            return this.tag;
        }
    }
}

