/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DebuggerBreakpointAnnotation
extends BreakpointAnnotation {
    private Line line;
    private String type;
    private JPDABreakpoint breakpoint;

    DebuggerBreakpointAnnotation(String string, Line line, JPDABreakpoint jPDABreakpoint) {
        this.type = string;
        this.line = line;
        this.breakpoint = jPDABreakpoint;
        this.attach((Annotatable)line);
    }

    public String getAnnotationType() {
        return this.type;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        if (this.type.endsWith("_broken")) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_BREAKPOINT_BROKEN");
        }
        if (this.type == "Breakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_BREAKPOINT");
        }
        if (this.type == "DisabledBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_BREAKPOINT");
        }
        if (this.type == "CondBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "DisabledCondBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "FieldBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_FIELD_BREAKPOINT");
        }
        if (this.type == "DisabledFieldBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_FIELD_BREAKPOINT");
        }
        if (this.type == "MethodBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_METHOD_BREAKPOINT");
        }
        if (this.type == "DisabledMethodBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_METHOD_BREAKPOINT");
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }
}

