/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public class QueryBuilderResultTable
extends JTable
implements ActionListener,
KeyListener {
    private DefaultTableModel resultTableModel = null;
    private QueryBuilder _queryBuilder;
    private JPopupMenu resultTablePopup;

    public QueryBuilderResultTable() {
        this((QueryBuilder)null);
    }

    public QueryBuilderResultTable(QueryBuilder queryBuilder) {
        this._queryBuilder = queryBuilder;
        this.resultTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.setModel(this.resultTableModel);
        this.resultTablePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyCellValue"));
        jMenuItem.addActionListener(this);
        this.resultTablePopup.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyRowValues"));
        jMenuItem.addActionListener(this);
        this.resultTablePopup.add(jMenuItem);
        ResultTablePopupListener resultTablePopupListener = new ResultTablePopupListener();
        super.addMouseListener(resultTablePopupListener);
        this.setAutoResizeMode(0);
        this.setForeground(Color.DARK_GRAY);
        this.addKeyListener(this);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this._queryBuilder != null) {
            this._queryBuilder.handleKeyPress(keyEvent);
        }
    }

    void clearModel() {
        ((DefaultTableModel)this.getModel()).setRowCount(0);
    }

    public void displayResultSet(ResultSet resultSet) {
        this.displayResultSet(resultSet, 40, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean displayResultSet(ResultSet resultSet, int n, boolean bl) {
        boolean bl2 = false;
        try {
            Object[] objectArray;
            int n2;
            ResultSetMetaData resultSetMetaData;
            if (resultSet == null || (resultSetMetaData = resultSet.getMetaData()) == null) {
                Log.getLogger().warning("Exception - unable to get query result ! ");
                boolean bl3 = bl2;
                return bl3;
            }
            int n3 = resultSetMetaData.getColumnCount();
            Log.getLogger().finest(" rsmd.getColumnCount(): " + n3);
            Object[] objectArray2 = new String[n3];
            for (n2 = 1; n2 <= n3; ++n2) {
                objectArray2[n2 - 1] = resultSetMetaData.getColumnLabel(n2);
            }
            this.resultTableModel.setColumnIdentifiers(objectArray2);
            this.resultTableModel.setRowCount(0);
            for (n2 = 0; resultSet.next() && n2 < n + 1; ++n2) {
                if (n2 >= n) {
                    bl2 = true;
                    break;
                }
                objectArray = new Object[n3];
                for (int i = 1; i <= n3; ++i) {
                    Object object;
                    if (resultSetMetaData.getColumnType(i) == 2004) {
                        object = resultSet.getBlob(i);
                        if (object == null) continue;
                        objectArray[i - 1] = "[BLOB of size " + object.length() + "]";
                        continue;
                    }
                    if (resultSetMetaData.getColumnType(i) == 2005) {
                        object = resultSet.getClob(i);
                        if (object == null) continue;
                        objectArray[i - 1] = "[CLOB of size " + object.length() + "]";
                        continue;
                    }
                    if (resultSetMetaData.getColumnType(i) == 93) {
                        object = resultSet.getTimestamp(i);
                        if (object == null) continue;
                        objectArray[i - 1] = DateFormat.getDateTimeInstance(3, 2).format((Date)object);
                        continue;
                    }
                    if (resultSetMetaData.getColumnType(i) == 91) {
                        object = resultSet.getDate(i);
                        if (object == null) continue;
                        objectArray[i - 1] = DateFormat.getDateInstance(3).format((Date)object);
                        continue;
                    }
                    if (resultSetMetaData.getColumnType(i) == 92) {
                        object = resultSet.getTime(i);
                        if (object == null) continue;
                        objectArray[i - 1] = DateFormat.getTimeInstance(2).format((Date)object);
                        continue;
                    }
                    objectArray[i - 1] = resultSet.getObject(i);
                }
                this.resultTableModel.addRow(objectArray);
            }
            if (bl2 && bl) {
                objectArray = NbBundle.getMessage(QueryBuilderResultTable.class, (String)"MAX_ENTRIES_DISPLAYED", (Object)Integer.toString(n));
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)((String)objectArray + "\n\n"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            Log.getLogger().warning("Exception - unable to build table");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyCellValue"))) {
            Object object = this.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
            this.setClipboard(object.toString());
        } else if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"LBL_CopyRowValues"))) {
            int[] nArray = this.getSelectedRows();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    if (j > 0) {
                        stringBuffer.append('\t');
                    }
                    Object object = this.getValueAt(nArray[i], j);
                    stringBuffer.append(object.toString());
                }
                stringBuffer.append('\n');
            }
            this.setClipboard(stringBuffer.toString());
        }
    }

    private void setClipboard(String string) {
        ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        StringSelection stringSelection = new StringSelection(string);
        exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
    }

    class ResultTablePopupListener
    extends MouseAdapter {
        ResultTablePopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mousePressed(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                if (n != -1) {
                    jTable.setRowSelectionInterval(n, n);
                }
                QueryBuilderResultTable.this.resultTablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

