/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.ConditionedExecutor;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.ErrorManager;

public class Operator {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    public static final String SILENT_EVENT_PROPERTY = "silent";
    private Thread thread;
    private boolean breakpointsDisabled;
    private List<EventSet> staledEvents = new ArrayList<EventSet>();
    private List<EventRequest> staledRequests = new ArrayList<EventRequest>();
    private boolean stop;
    private boolean canInterrupt;
    private JPDADebuggerImpl debugger;

    public Operator(VirtualMachine virtualMachine, final JPDADebuggerImpl jPDADebuggerImpl, Executor executor, Runnable runnable, final Object object) {
        EventQueue eventQueue = virtualMachine.eventQueue();
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        this.debugger = jPDADebuggerImpl;
        final Object[] objectArray = new Object[]{eventQueue, executor, runnable};
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EventQueue eventQueue = (EventQueue)objectArray[0];
                Executor executor = (Executor)objectArray[1];
                Runnable runnable = (Runnable)objectArray[2];
                objectArray[0] = null;
                objectArray[1] = null;
                objectArray[2] = null;
                boolean bl = false;
                block44: while (true) {
                    try {
                        Mirror mirror;
                        Object object3;
                        Object object2;
                        Object object32;
                        Object object4;
                        Set set;
                        while (true) {
                            Object object5;
                            set = null;
                            if (bl) {
                                Operator operator = Operator.this;
                                synchronized (operator) {
                                    if (Operator.this.staledEvents.size() == 0) {
                                        bl = false;
                                    } else {
                                        set = (EventSet)Operator.this.staledEvents.remove(0);
                                        while (Operator.this.staledRequests.size() > 0) {
                                            object5 = (EventRequest)Operator.this.staledRequests.remove(0);
                                            object5.virtualMachine().eventRequestManager().deleteEventRequest((EventRequest)object5);
                                        }
                                    }
                                }
                            }
                            if (set == null) {
                                Operator operator;
                                block88: {
                                    try {
                                        operator = Operator.this;
                                        synchronized (operator) {
                                            if (Operator.this.stop) {
                                                break block44;
                                            }
                                            Operator.this.canInterrupt = true;
                                        }
                                        set = eventQueue.remove();
                                        if (!logger.isLoggable(Level.FINE)) break block88;
                                        try {
                                            logger.fine("HAVE EVENT(s) in the Queue: " + set);
                                        }
                                        catch (ObjectCollectedException objectCollectedException) {
                                            ErrorManager.getDefault().notify((Throwable)objectCollectedException);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        object5 = Operator.this;
                                        synchronized (object5) {
                                            if (Operator.this.stop) {
                                                break block44;
                                            }
                                        }
                                        bl = true;
                                        continue;
                                    }
                                }
                                operator = Operator.this;
                                synchronized (operator) {
                                    Operator.this.canInterrupt = false;
                                }
                            }
                            boolean bl2 = set.size() > 0;
                            for (Event event : set) {
                                EventRequest eventRequest = event.request();
                                if (eventRequest != null && Boolean.TRUE.equals(eventRequest.getProperty(Operator.SILENT_EVENT_PROPERTY))) continue;
                                bl2 = false;
                                break;
                            }
                            if (!bl2) {
                                object5 = Operator.this;
                                synchronized (object5) {
                                    if (Operator.this.breakpointsDisabled) {
                                        if (set.suspendPolicy() == 2) {
                                            Operator.this.staledEvents.add(set);
                                            set.resume();
                                            if (logger.isLoggable(Level.FINE)) {
                                                logger.fine("RESUMING " + set);
                                            }
                                        }
                                        continue;
                                    }
                                }
                            }
                            object5 = new HashMap();
                            for (Event event : set) {
                                Executor executor2;
                                EventRequest eventRequest = event.request();
                                Executor executor3 = executor2 = eventRequest != null ? (Executor)eventRequest.getProperty("executor") : null;
                                if (executor2 instanceof ConditionedExecutor) {
                                    boolean bl3 = ((ConditionedExecutor)executor2).processCondition(event);
                                    if (!bl3) continue;
                                    object5.put(event, executor2);
                                    continue;
                                }
                                object5.put(event, executor2);
                            }
                            if (object5.size() == 0) {
                                set.resume();
                                continue;
                            }
                            boolean bl4 = true;
                            boolean bl5 = true;
                            int n = set.suspendPolicy();
                            boolean bl6 = n == 2;
                            JPDAThreadImpl jPDAThreadImpl = null;
                            if (!bl2 && bl6) {
                                jPDADebuggerImpl.notifySuspendAll();
                            }
                            if (n == 1) {
                                object4 = null;
                                object32 = set.iterator();
                                while (object32.hasNext() && (object4 = Operator.getEventThread((Event)(object2 = (Event)object32.next()))) == null) {
                                }
                                if (object4 != null && !bl2) {
                                    jPDAThreadImpl = (JPDAThreadImpl)jPDADebuggerImpl.getThread((ThreadReference)object4);
                                    jPDAThreadImpl.notifySuspended();
                                }
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                switch (n) {
                                    case 2: {
                                        logger.fine("JDI new events (suspend all)=============================================");
                                        break;
                                    }
                                    case 1: {
                                        logger.fine("JDI new events (suspend one)=============================================");
                                        break;
                                    }
                                    case 0: {
                                        logger.fine("JDI new events (suspend none)=============================================");
                                        break;
                                    }
                                    default: {
                                        logger.fine("JDI new events (?????)=============================================");
                                    }
                                }
                                logger.fine("  event is silent = " + bl2);
                            }
                            for (Object object32 : set) {
                                if (!object5.containsKey(object32)) continue;
                                if (object32 instanceof VMDeathEvent || object32 instanceof VMDisconnectEvent) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        Operator.this.printEvent((Event)object32, null);
                                    }
                                    object2 = Operator.this;
                                    synchronized (object2) {
                                        Operator.this.stop = true;
                                        break block44;
                                    }
                                }
                                if (object32 instanceof VMStartEvent && executor != null) {
                                    bl4 &= executor.exec((Event)object32);
                                    if (!logger.isLoggable(Level.FINE)) continue;
                                    Operator.this.printEvent(object32, null);
                                    continue;
                                }
                                object2 = null;
                                if (object32.request() == null) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.fine("EVENT: " + object32 + " REQUEST: null");
                                    }
                                } else {
                                    object2 = (Executor)object5.get(object32);
                                }
                                if (logger.isLoggable(Level.FINE)) {
                                    Operator.this.printEvent(object32, (Executor)object2);
                                }
                                if (object2 == null) continue;
                                try {
                                    bl5 = false;
                                    bl4 &= object2.exec((Event)object32);
                                }
                                catch (VMDisconnectedException vMDisconnectedException) {
                                    object3 = Operator.this;
                                    synchronized (object3) {
                                        Operator.this.stop = true;
                                        break block44;
                                    }
                                }
                                catch (Exception exception) {
                                    ErrorManager.getDefault().notify((Throwable)exception);
                                }
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("JDI events dispatched (resume " + (bl4 && !bl5) + ")");
                                logger.fine("  resume = " + bl4 + ", startEventOnly = " + bl5);
                            }
                            if (!bl5) {
                                if (bl4) {
                                    if (!bl2 && bl6) {
                                        jPDADebuggerImpl.notifyToBeResumedAll();
                                    }
                                    if (!bl2 && jPDAThreadImpl != null) {
                                        jPDAThreadImpl.notifyToBeResumed();
                                    }
                                    object4 = object;
                                    synchronized (object4) {
                                        set.resume();
                                    }
                                } else if (!bl2 && (bl6 || jPDAThreadImpl != null)) {
                                    object4 = jPDADebuggerImpl.getSession();
                                    if (object4 != null) {
                                        DebuggerManager.getDebuggerManager().setCurrentSession((Session)object4);
                                    }
                                    object32 = null;
                                    object2 = set.iterator();
                                    while (object2.hasNext() && (object32 = Operator.getEventThread((Event)(mirror = (Event)object2.next()))) == null) {
                                    }
                                    if (object32 != null) {
                                        jPDADebuggerImpl.setStoppedState((ThreadReference)object32);
                                    }
                                }
                            }
                            if (!bl2 && !bl4) break;
                        }
                        object4 = object;
                        synchronized (object4) {
                            object32 = set.virtualMachine().allThreads();
                            object2 = object32.iterator();
                            while (object2.hasNext()) {
                                mirror = (ThreadReference)object2.next();
                                try {
                                    object3 = (JPDAThreadImpl)jPDADebuggerImpl.getExistingThread((ThreadReference)mirror);
                                    while (mirror.suspendCount() > 1) {
                                        if (object3 != null) {
                                            ((JPDAThreadImpl)object3).notifyToBeResumed();
                                        }
                                        mirror.resume();
                                    }
                                }
                                catch (ObjectCollectedException objectCollectedException) {
                                }
                            }
                            continue;
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        continue;
                    }
                    break;
                }
                if (runnable != null) {
                    runnable.run();
                }
                runnable = null;
                eventQueue = null;
                executor = null;
            }
        }, "Debugger operator thread");
    }

    private static final ThreadReference getEventThread(Event event) {
        ThreadReference threadReference = null;
        if (event instanceof LocatableEvent) {
            threadReference = ((LocatableEvent)event).thread();
        } else if (event instanceof ClassPrepareEvent) {
            threadReference = ((ClassPrepareEvent)event).thread();
        } else if (event instanceof ThreadStartEvent) {
            threadReference = ((ThreadStartEvent)event).thread();
        } else if (event instanceof ThreadDeathEvent) {
            threadReference = ((ThreadDeathEvent)event).thread();
        }
        return threadReference;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest eventRequest, Executor executor) {
        eventRequest.putProperty("executor", executor);
        if (this.staledEvents.size() > 0 && eventRequest instanceof StepRequest) {
            boolean bl = false;
            for (EventSet eventSet : this.staledEvents) {
                for (Event event : eventSet) {
                    EventRequest eventRequest2 = event.request();
                    if (!(eventRequest2 instanceof StepRequest)) {
                        bl = true;
                        break;
                    }
                    ThreadReference threadReference = ((StepRequest)eventRequest2).thread();
                    ThreadReference threadReference2 = ((StepRequest)eventRequest).thread();
                    if (!threadReference2.equals(threadReference)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl) {
                this.staledRequests.add(eventRequest);
            }
        }
    }

    public synchronized void unregister(EventRequest eventRequest) {
        Executor executor = (Executor)eventRequest.getProperty("executor");
        eventRequest.putProperty("executor", null);
        if (executor != null) {
            executor.removed(eventRequest);
        }
        this.staledRequests.remove(eventRequest);
        if (eventRequest instanceof StepRequest) {
            ThreadReference threadReference = ((StepRequest)eventRequest).thread();
            ((JPDAThreadImpl)this.debugger.getThread(threadReference)).setInStep(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            this.staledRequests.clear();
            this.staledEvents.clear();
            if (this.stop) {
                return;
            }
            this.stop = true;
            if (this.canInterrupt) {
                this.thread.interrupt();
            }
        }
    }

    public synchronized void breakpointsDisabled() {
        this.breakpointsDisabled = true;
    }

    public synchronized void breakpointsEnabled() {
        this.breakpointsDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushStaledEvents() {
        boolean bl;
        Operator operator = this;
        synchronized (operator) {
            boolean bl2 = bl = this.staledEvents.size() > 0;
            if (bl) {
                this.thread.interrupt();
            }
        }
        return bl;
    }

    private void printEvent(Event event, Executor executor) {
        try {
            if (event instanceof ClassPrepareEvent) {
                logger.fine("JDI EVENT: ClassPrepareEvent " + ((ClassPrepareEvent)event).referenceType());
            } else if (event instanceof ClassUnloadEvent) {
                logger.fine("JDI EVENT: ClassUnloadEvent " + ((ClassUnloadEvent)event).className());
            } else if (event instanceof ThreadStartEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadStartEvent " + ((ThreadStartEvent)event).thread());
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadStartEvent1 " + event);
                }
            } else if (event instanceof ThreadDeathEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadDeathEvent " + ((ThreadDeathEvent)event).thread());
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadDeathEvent1 " + event);
                }
            } else if (event instanceof MethodEntryEvent) {
                try {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
            } else if (event instanceof BreakpointEvent) {
                logger.fine("JDI EVENT: BreakpointEvent " + ((BreakpointEvent)event).thread() + " : " + ((BreakpointEvent)event).location());
            } else if (event instanceof StepEvent) {
                logger.fine("JDI EVENT: StepEvent " + ((StepEvent)event).thread() + " : " + ((StepEvent)event).location());
            } else {
                logger.fine("JDI EVENT: " + event + " : " + executor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

