/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansRefCompletor
extends Completor {
    private final boolean includeGlobal;

    public BeansRefCompletor(boolean bl, int n) {
        super(n);
        this.includeGlobal = bl;
    }

    @Override
    protected int initAnchorOffset(CompletionContext completionContext) {
        return completionContext.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(CompletionContext completionContext) throws IOException {
        Object object;
        final FileObject fileObject = completionContext.getFileObject();
        SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
        if (springConfigModel == null) {
            return;
        }
        final String string = this.getContextPrefix(completionContext);
        final Set<String> set = this.getForbiddenNames(completionContext);
        final ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = completionContext.getTag().getNodeName();
        if (string2.equals("bean") && SpringXMLConfigEditorUtils.hasAttribute(completionContext.getTag(), "id")) {
            object = SpringXMLConfigEditorUtils.getAttribute(completionContext.getTag(), "id");
            arrayList.add((String)object);
        }
        if (string2.equals("bean") && SpringXMLConfigEditorUtils.hasAttribute(completionContext.getTag(), "name")) {
            object = StringUtils.tokenize(SpringXMLConfigEditorUtils.getAttribute(completionContext.getTag(), "name"), ",; ");
            arrayList.addAll((Collection<String>)object);
        }
        if (this.isCancelled()) {
            return;
        }
        springConfigModel.runReadAction(new Action<SpringBeans>(){

            @Override
            public void run(SpringBeans springBeans) {
                Map<String, SpringBean> map = this.getName2Beans(springBeans);
                for (String string2 : map.keySet()) {
                    if (!string2.startsWith(string) || arrayList.contains(string2) || set.contains(string2)) continue;
                    SpringBean springBean = map.get(string2);
                    SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createBeanRefItem(BeansRefCompletor.this.getAnchorOffset(), string2, springBean, fileObject);
                    BeansRefCompletor.this.addCacheItem(springXMLConfigCompletionItem);
                }
            }

            private Map<String, SpringBean> getName2Beans(SpringBeans springBeans) {
                Object object;
                String string3;
                List<SpringBean> list = BeansRefCompletor.this.includeGlobal ? springBeans.getBeans() : springBeans.getFileBeans(fileObject).getBeans();
                HashMap<String, SpringBean> hashMap = new HashMap<String, SpringBean>();
                for (SpringBean object2 : list) {
                    string3 = object2.getId();
                    if (string3 != null) {
                        hashMap.put(string3, object2);
                    }
                    if (!BeansRefCompletor.this.includeGlobal) continue;
                    object = object2.getNames();
                    Iterator<String> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = iterator.next();
                        hashMap.put(string2, object2);
                    }
                }
                if (BeansRefCompletor.this.includeGlobal) {
                    Set<String> set2 = springBeans.getAliases();
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        string3 = (String)iterator.next();
                        object = springBeans.findBean(string3);
                        if (object == null) continue;
                        hashMap.put(string3, (SpringBean)object);
                    }
                }
                return hashMap;
            }
        });
    }

    @Override
    public boolean canFilter(CompletionContext completionContext) {
        return CompletorUtils.canFilter(completionContext.getDocument(), this.getInvocationOffset(), completionContext.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.BEAN_NAME_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext completionContext) {
        return CompletorUtils.filter(this.getCacheItems(), completionContext.getDocument(), this.getInvocationOffset(), completionContext.getCaretOffset(), this.getAnchorOffset());
    }

    protected String getContextPrefix(CompletionContext completionContext) {
        return completionContext.getTypedPrefix();
    }

    protected Set<String> getForbiddenNames(CompletionContext completionContext) {
        return Collections.emptySet();
    }
}

