/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.util.Vector;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.modules.ant.debugger.Task;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class CallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private AntDebugger debugger;
    private Vector listeners = new Vector();

    public CallStackModel(ContextProvider contextProvider) {
        this.debugger = (AntDebugger)((Object)contextProvider.lookupFirst(null, AntDebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            return this.debugger.getCallStack();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof TargetLister.Target) {
            return true;
        }
        if (object instanceof Task) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return this.debugger.getCallStack().length;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof TargetLister.Target) {
            try {
                return ((TargetLister.Target)object).getName();
            }
            catch (IllegalStateException illegalStateException) {
                return "";
            }
        }
        if (object instanceof Task) {
            try {
                return ((Task)object).getTaskStructure().getName();
            }
            catch (IllegalStateException illegalStateException) {
                return "";
            }
        }
        if (object == "Root") {
            return "Root";
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof TargetLister.Target) {
            return CALL_STACK;
        }
        if (object instanceof Task) {
            return CURRENT_CALL_STACK;
        }
        if (object == "Root") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof TargetLister.Target) {
            return null;
        }
        if (object instanceof Task) {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof TargetLister.Target) {
            Utils.showLine(Utils.getLine((TargetLister.Target)object, null));
            return;
        }
        if (object instanceof Task) {
            Utils.showLine(((Task)object).getLine());
            return;
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (string == "CallStackFrameLocation") {
            if (object instanceof TargetLister.Target) {
                TargetLister.Target target = (TargetLister.Target)object;
                return target.getScript().getFile().getName() + ":" + Utils.getLineNumber(Utils.getLine((TargetLister.Target)object, null));
            }
            if (object instanceof Task) {
                Task task = (Task)object;
                return task.getFile().getName() + ":" + Utils.getLineNumber(task.getLine()) + 1;
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (string == "CallStackFrameLocation") {
            if (object instanceof TargetLister.Target) {
                return true;
            }
            if (object instanceof Task) {
                return true;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    void fireChanges() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

